/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.util.Pickable;
import oracle.bali.xml.gui.swing.util.PickableList;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.util.XmlModelUtils;

public class PickablePicker {
    private JComponent _component;
    private PickableList _list;
    private JEditorPane _descArea;
    private final Map<CategoryDefinition, List<Pickable>> _pickableMap;
    private final AbstractModel _model;
    private static final int DEFAULT_COMPONENT_WIDTH = 70;
    private static final int DEFAULT_DESCRIPTION_HEIGHT = 50;
    private static final int DEFAULT_LIST_HEIGHT = 100;
    private static final int DEFAULT_COMPONENT_SPACING = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pickable runDialog(Component owner, String title, String helpId, Map<CategoryDefinition, List<Pickable>> pickableMap, AbstractModel model, CategoryDefinition initialSelection) {
        if (pickableMap.isEmpty()) {
            return null;
        }
        PickablePicker picker = new PickablePicker(pickableMap, model, initialSelection);
        JComponent component = picker._getComponent();
        JList list = picker._getList();
        int buttons = 3;
        if (helpId != null) {
            HelpUtils.setHelpID((JComponent)component, (String)helpId);
            buttons |= 4;
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)title, (int)buttons);
        dialog.setContent((Component)component);
        dialog.setResizable(true);
        dialog.setInitialFocus((Component)list);
        UIUtils.setupListDoubleClickListener(list, dialog);
        try {
            XmlModelUtils.setModalDialogRunning((boolean)true);
            if (dialog.runDialog()) {
                Pickable pickable = picker._getSelectedPickable();
                return pickable;
            }
            Pickable pickable = null;
            return pickable;
        }
        finally {
            dialog.dispose();
            XmlModelUtils.setModalDialogRunning((boolean)false);
        }
    }

    private PickablePicker(Map<CategoryDefinition, List<Pickable>> pickableMap, AbstractModel model, CategoryDefinition initialSelection) {
        this._pickableMap = pickableMap;
        this._model = model;
        this._initUI(initialSelection);
    }

    private Pickable _getSelectedPickable() {
        return this._list.getSelectedPickable();
    }

    private JList _getList() {
        return this._list;
    }

    private JComponent _getComponent() {
        return this._component;
    }

    private void _initUI(CategoryDefinition initialSelection) {
        JLabel elementLabel;
        JPanel mainPanel = new JPanel(new BorderLayout(0, 5));
        Set<CategoryDefinition> categoriesSet = this._pickableMap.keySet();
        Object[] categories = categoriesSet.toArray(new CategoryDefinition[0]);
        Arrays.sort(categories);
        if (initialSelection == null || !categoriesSet.contains(initialSelection)) {
            initialSelection = categories[0];
        }
        PickableListModel pickableListModel = new PickableListModel((CategoryDefinition)initialSelection);
        if (categories.length == 1) {
            elementLabel = this._createLabel("INSERT_DIALOG.MESSAGE_FORMAT", categories[0].getDisplayName());
        } else {
            elementLabel = this._createLabel("KEY_PICKER.ELEMENT_LABEL");
            JComboBox<Object> categoryPicker = new JComboBox<Object>(categories);
            categoryPicker.setSelectedItem(initialSelection);
            categoryPicker.addItemListener(pickableListModel);
            mainPanel.add(this._createLabeledComp(this._createLabel("KEY_PICKER.CATEGORY_LABEL"), categoryPicker), "North");
        }
        this._list = new PickableList((ListModel)pickableListModel);
        Box listAndDescription = Box.createVerticalBox();
        JScrollPane listPane = new JScrollPane(this._list);
        listPane.setMinimumSize(new Dimension(70, 100));
        listAndDescription.add(this._createLabeledComp(elementLabel, listPane));
        listAndDescription.add(Box.createVerticalStrut(5));
        if (pickableListModel.getSize() > 0) {
            this._list.setSelectedIndex(0);
        }
        listAndDescription.add(this._createLabeledComp(this._createLabel("KEY_PICKER.DESCRIPTION"), this._createDescArea()));
        mainPanel.add((Component)listAndDescription, "Center");
        this._component = mainPanel;
    }

    private Component _createDescArea() {
        this._descArea = new JEditorPane();
        this._descArea.setEditable(false);
        this._descArea.setContentType("text/html");
        this._descArea.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this._updateDescArea();
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PickablePicker.this._updateDescArea();
            }
        });
        JScrollPane descPane = new JScrollPane(this._descArea, 22, 31);
        Dimension size = new Dimension(70, 50);
        descPane.setMinimumSize(size);
        descPane.setPreferredSize(size);
        return descPane;
    }

    private void _updateDescArea() {
        Pickable pickable = this._getSelectedPickable();
        String text = null;
        if (pickable != null) {
            text = pickable.getDisplayName();
        }
        if (text == null) {
            text = "";
        }
        EditorKit kit = this._descArea.getEditorKit();
        Document newDoc = kit.createDefaultDocument();
        StyleSheet styleSheet = ((HTMLDocument)newDoc).getStyleSheet();
        styleSheet.addRule("body {font-family: Dialog; font-size: 10px; line-height: 10px}");
        try {
            kit.read(new StringReader(text), newDoc, 0);
            this._descArea.setDocument(newDoc);
        }
        catch (IOException e) {
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private Component _createLabeledComp(JLabel label, Component comp) {
        label.setLabelFor(comp);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        panel.add(comp, "Center");
        return panel;
    }

    private JLabel _createLabel(String bundleKey) {
        return this._createLabelDirect(this._model.getTranslatedString(bundleKey));
    }

    private JLabel _createLabel(String bundleKey, String param) {
        return this._createLabelDirect(this._model.getTranslatedString(bundleKey, param));
    }

    private JLabel _createLabelDirect(String textAndMnemonic) {
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)textAndMnemonic));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)textAndMnemonic));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        return label;
    }

    private class PickableListModel
    extends AbstractListModel
    implements ItemListener {
        private List<Pickable> _items = null;

        public PickableListModel(CategoryDefinition initialCategory) {
            this._setCategory(initialCategory);
        }

        @Override
        public int getSize() {
            return this._items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._items.get(index);
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                List<Pickable> oldItems = this._items;
                CategoryDefinition category = (CategoryDefinition)event.getItem();
                this._setCategory(category);
                this.fireContentsChanged(this, 0, oldItems.size());
                PickablePicker.this._list.setSelectedIndex(0);
                PickablePicker.this._updateDescArea();
            }
        }

        private void _setCategory(CategoryDefinition category) {
            this._items = (List)PickablePicker.this._pickableMap.get(category);
        }
    }
}

