/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.SwingGlobalNodeTypeGui;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.inspector.DatabindingButtonListeners;
import oracle.bali.xml.gui.swing.inspector.IconAddingCellRenderer;
import oracle.bali.xml.gui.swing.inspector.ResetAction;
import oracle.bali.xml.gui.swing.inspector.SpacerIcon;
import oracle.bali.xml.gui.swing.inspector.editors.BigDecimalEditor;
import oracle.bali.xml.gui.swing.inspector.editors.BigIntegerEditor;
import oracle.bali.xml.gui.swing.inspector.editors.ByteEditor;
import oracle.bali.xml.gui.swing.inspector.editors.DoubleEditor;
import oracle.bali.xml.gui.swing.inspector.editors.FloatEditor;
import oracle.bali.xml.gui.swing.inspector.editors.IntegerEditor;
import oracle.bali.xml.gui.swing.inspector.editors.ListEditor;
import oracle.bali.xml.gui.swing.inspector.editors.LongEditor;
import oracle.bali.xml.gui.swing.inspector.editors.QNameEditor;
import oracle.bali.xml.gui.swing.inspector.editors.ShortEditor;
import oracle.bali.xml.gui.swing.inspector.editors.UnsignedIntEditor;
import oracle.bali.xml.gui.swing.inspector.editors.XmlnsEditor;
import oracle.bali.xml.gui.swing.inspector.editors.XsdIdEditor;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlPreferences;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.preference.Preference;
import oracle.bali.xml.preference.PreferenceChangeEvent;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.SimpleTypePropertyEditorManager;
import org.w3c.dom.Node;

public class SwingInspectorGui
extends BaseInspectorGui
implements ComponentXmlGui {
    private Component _component;
    private static final String _PREFERENCE_LISTENER = "oracle.bali.xml.gui.swing.inspector.SwingInspectorGui._PREFERENCE_LISTENER";
    private static final String _BOUND_ICON = "images/databound.png";
    private static final String _TOOLBAR_ICON = "images/bind_to_data.png";
    private static final String _REMOVE_TOOLBAR_ICON = "images/setdefault.png";
    private static final String _SET_ICON = "images/greenDot.png";
    private static final String _CUSTOMIZED_AT_TIP_ICON = "images/orangeDot.png";
    private static final String _WARNING_ICON = "images/warning.gif";
    private static final String _ERROR_ICON = "images/error.gif";
    private static Icon _sDataboundIcon;
    private static Icon _sResetIcon;
    private static Icon _sIcon;
    private static Icon _sCustomizedAtTipIcon;
    private static Icon _sSetIcon;
    private static Icon _sSpacerIcon;
    private static Icon _sWarningIcon;
    private static Icon _sErrorIcon;
    private PropertyModel _propertyModel;
    private static final int _sSpacerIconWidth = 9;

    public SwingInspectorGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        if (this._component == null) {
            this._component = this.createPropertyInspector();
        }
        return this._component;
    }

    public PropertyModel getPropertyModel() {
        if (this._propertyModel == null) {
            this._propertyModel = this.createPropertyModel(true);
        }
        return this._propertyModel;
    }

    public PropertyInspector createPropertyInspector() {
        final PropertyInspector inspector = this.createPropertyInspectorInstance();
        inspector.setStatusVisible(true);
        inspector.setUnderlyingPropertyModel(this.getPropertyModel());
        inspector.setCategorized(true);
        inspector.setAlphabetizeGroupProperties(false);
        inspector.setColumnFilter(PropertyModel.COLUMN_IS_HIDDEN, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        boolean showExpert = Boolean.TRUE.equals(this.getView().getContext().getPreferenceValue(XmlPreferences.SHOW_EXPERT_ITEMS));
        Object filter = showExpert ? PropertyModel.DOES_NOT_EXIST : Boolean.TRUE;
        inspector.setColumnFilter(PropertyModel.COLUMN_IS_EXPERT, filter, (Object)Boolean.FALSE);
        this.attachToolbarButtons(inspector, this.getInspectorToolbar(inspector));
        inspector.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, (TableCellRenderer)new IconAddingCellRenderer(this));
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Preference p;
                if (e instanceof PreferenceChangeEvent && XmlPreferences.SHOW_EXPERT_ITEMS == (p = ((PreferenceChangeEvent)e).getPreference())) {
                    Object filter = Boolean.TRUE.equals(e.getNewValue()) ? PropertyModel.DOES_NOT_EXIST : Boolean.TRUE;
                    inspector.setColumnFilter(PropertyModel.COLUMN_IS_EXPERT, filter, (Object)Boolean.FALSE);
                }
            }
        };
        this.getGuiContext().addPreferenceChangeListener(pcl);
        inspector.putClientProperty((Object)_PREFERENCE_LISTENER, (Object)pcl);
        return inspector;
    }

    public void disposePropertyInspector(PropertyInspector inspector) {
        inspector.setUnderlyingPropertyModel(null);
        inspector.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, null);
        this.detachToolbarButtons(inspector, this.getInspectorToolbar(inspector));
        PropertyChangeListener pcl = (PropertyChangeListener)inspector.getClientProperty((Object)_PREFERENCE_LISTENER);
        if (pcl != null) {
            this.getView().getContext().removePreferenceChangeListener(pcl);
        }
        inspector.putClientProperty((Object)_PREFERENCE_LISTENER, null);
    }

    public PropertyEditor getPropertyEditor(Node node, XmlKey key, Object value) {
        PropertyEditor pe;
        SwingGlobalNodeTypeGui gui;
        if ("http://www.w3.org/2000/xmlns/".equals(key.getTargetNamespace())) {
            return this._getXmlnsEditor();
        }
        if (key instanceof GlobalNodeTypeKey && (gui = (SwingGlobalNodeTypeGui)this.getGuiContext().getGui(XmlUsage.GLOBAL_NODE_TYPE)) != null && (pe = gui.getPropertyEditor(key)) != null) {
            return pe;
        }
        return super.getPropertyEditor(node, key, value);
    }

    protected PropertyEditor createPropertyEditor(Node node, XmlKey nodeKey, Object value) {
        XmlView view = this.getView();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        SimpleType type = resolver.getModifiedSimpleType(node, nodeKey, value);
        if (type != null && type.getVariety() == 1 && resolver.getPropertyEditor(nodeKey) == null) {
            return new ListEditor();
        }
        return super.createPropertyEditor(node, nodeKey, value);
    }

    public void registerPropertyEditors() {
        super.registerPropertyEditors();
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "decimal", BigDecimalEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "float", FloatEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "double", DoubleEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "integer", BigIntegerEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "long", LongEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "unsignedInt", UnsignedIntEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "int", IntegerEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "short", ShortEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "byte", ByteEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "QName", QNameEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "ID", XsdIdEditor.class);
        this.registerDefaultIdentifier(DEFAULT_EDITOR_FLOAT, "oracle.bali.xml.gui.swing.inspector.editors.FloatEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_DOUBLE, "oracle.bali.xml.gui.swing.inspector.editors.DoubleEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_INTEGER, "oracle.bali.xml.gui.swing.inspector.editors.IntegerEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_LONG, "oracle.bali.xml.gui.swing.inspector.editors.LongEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_SHORT, "oracle.bali.xml.gui.swing.inspector.editors.ShortEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BYTE, "oracle.bali.xml.gui.swing.inspector.editors.ByteEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_QUALIFIEDNAME, "oracle.bali.xml.gui.swing.inspector.editors.QNameEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BIGINTEGER, "oracle.bali.xml.gui.swing.inspector.editors.BigIntegerEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BIGDECIMAL, "oracle.bali.xml.gui.swing.inspector.editors.BigDecimalEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_UNSIGNEDINTEGER, "oracle.bali.xml.gui.swing.inspector.editors.UnsignedIntEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_MULTILINE, "oracle.bali.xml.gui.swing.inspector.editors.MultiLineEditor");
    }

    public void showError(XmlKey key, Object value, Throwable t) {
        String error = t.getLocalizedMessage() == null ? (t.getMessage() == null ? t.toString() : t.getMessage()) : t.getLocalizedMessage();
        String keyName = key.getLocalName();
        String titleFormat = this.getTranslatedString("INSPECTOR.ERROR_TITLE_FORMAT");
        String title = FastMessageFormat.formatMessage((String)titleFormat, (String)keyName);
        String errorFormat = this.getTranslatedString("INSPECTOR.ERROR_MESSAGE_FORMAT");
        String valueString = String.valueOf(value);
        String message = FastMessageFormat.formatMessage((String)errorFormat, (String)keyName, (String)valueString, (String)error);
        JOptionPane.showMessageDialog(this.getParentFrame(), message, title, 0);
    }

    public void attachToolbarButtons(PropertyInspector inspector, Container container) {
        this.attachToolbarButtons(inspector, container, this.getView().getXmlMetadataResolver().isDatabindingSupported(), true);
    }

    public void attachToolbarButtons(PropertyInspector inspector, Container container, boolean supportBinding, boolean supportsReset) {
        if (container == null) {
            return;
        }
        try {
            this.detachToolbarButtons(inspector, container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (supportBinding) {
            JToggleButton databindingButton = DatabindingButtonListeners.createButton(this, inspector);
            container.add(databindingButton);
        }
        if (supportsReset) {
            JButton resetButton = ResetAction.createResetButton(inspector, this);
            container.add(resetButton);
        }
        container.validate();
    }

    public void detachToolbarButtons(PropertyInspector inspector, Container container) {
        Component b;
        if (container == null) {
            return;
        }
        Component c = DatabindingButtonListeners.getDataBindingButton(inspector);
        if (c != null) {
            try {
                container.remove(c);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
        }
        if ((b = ResetAction.getResetButton(inspector)) != null) {
            container.remove(b);
        }
    }

    public Icon getDataboundIcon() {
        if (_sDataboundIcon == null) {
            _sDataboundIcon = this._icon(_BOUND_ICON);
        }
        return _sDataboundIcon;
    }

    public Icon getAttributeSetIcon() {
        if (_sSetIcon == null) {
            _sSetIcon = this._icon(_SET_ICON);
        }
        return _sSetIcon;
    }

    public Icon getCustomizedAtTipIcon() {
        if (_sCustomizedAtTipIcon == null) {
            _sCustomizedAtTipIcon = this._icon(_CUSTOMIZED_AT_TIP_ICON);
        }
        return _sCustomizedAtTipIcon;
    }

    public Icon getWarningIcon() {
        if (_sWarningIcon == null) {
            _sWarningIcon = this._icon(_WARNING_ICON);
        }
        return _sWarningIcon;
    }

    public Icon getErrorIcon() {
        if (_sErrorIcon == null) {
            _sErrorIcon = this._icon(_ERROR_ICON);
        }
        return _sErrorIcon;
    }

    public Icon getSpacerIcon() {
        if (_sSpacerIcon == null) {
            _sSpacerIcon = SpacerIcon.createHorizonalSpacer(9);
        }
        return _sSpacerIcon;
    }

    public Component getInspectorContainer(PropertyInspector inspector) {
        return inspector;
    }

    public void dispose() {
        super.dispose();
    }

    protected PropertyInspector createPropertyInspectorInstance() {
        return new PropertyInspector();
    }

    protected Container getInspectorToolbar(PropertyInspector inspector) {
        return inspector.getActionToolBar();
    }

    protected JToggleButton createDatabindingButton() {
        JToggleButton b = new JToggleButton(this.getDatabindingToolbarIcon());
        b.setMargin(new Insets(0, 2, 0, 2));
        b.setEnabled(false);
        b.setSelected(true);
        return b;
    }

    protected JButton createResetButton() {
        JButton b = new JButton();
        b.setMargin(new Insets(0, 2, 0, 2));
        b.setEnabled(false);
        b.setSelected(true);
        return b;
    }

    protected Icon getDatabindingToolbarIcon() {
        if (_sIcon == null) {
            Image image = ImageUtils.getImageResource(SwingInspectorGui.class, (String)_TOOLBAR_ICON);
            _sIcon = new ImageIcon(image);
        }
        return _sIcon;
    }

    protected Icon getResetToolbarIcon() {
        if (_sResetIcon == null) {
            Image image = ImageUtils.getImageResource(SwingInspectorGui.class, (String)_REMOVE_TOOLBAR_ICON);
            _sResetIcon = new ImageIcon(image);
        }
        return _sResetIcon;
    }

    protected Component getParentFrame() {
        if (this.getGuiContext() instanceof SwingXmlContext) {
            return ((SwingXmlContext)this.getGuiContext()).getRootDocumentUIComponent();
        }
        return new JFrame();
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        PropertyChange validityChange;
        if (this.getView().requiresValidModel() && (validityChange = event.getDomDocumentValidPropertyChange()) != null && this._component != null) {
            this._component.setEnabled(validityChange.getNewBooleanValue());
        }
        super.handleModelChangeEvent(event);
    }

    private PropertyEditor _getXmlnsEditor() {
        return new XmlnsEditor();
    }

    private Icon _icon(String relativePath) {
        Image i = ImageUtils.getImageResource(SwingInspectorGui.class, (String)relativePath);
        return new ImageIcon(i);
    }
}

