/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.model.XmlView;

public class XmlJTree
extends JTree {
    private SwingExplorerGui _gui;

    protected XmlJTree(SwingExplorerGui gui) {
        if (gui == null) {
            throw new IllegalArgumentException("Gui required");
        }
        this.enableEvents(48L);
        this._gui = gui;
        this._gui.__getHelper().attachMouseAndKeyboardSupport(this);
    }

    public void dispose() {
        this._gui = null;
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    protected final SwingExplorerGui getGui() {
        return this._gui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (this._gui == null) {
            super.paintComponent(g);
            return;
        }
        XmlView view = this._gui.getView();
        view.acquireReadLock();
        try {
            Boolean updateInProgress = false;
            if (view.getBaseModel().isInTransaction() && view.getBaseModel().getDomModel().hasModifications()) {
                updateInProgress = true;
            }
            if (this._gui.isModelInvalidated()) {
                return;
            }
            if (!updateInProgress.booleanValue()) {
                this._gui.paintBackground(this, g);
                super.paintComponent(g);
                if (this._gui != null) {
                    this._gui.paintSelection(this, g);
                }
            }
        }
        finally {
            view.releaseReadLock();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this._gui.__getHelper().processMouseMotionEvent(this, e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this._gui.__getHelper().processMouseEvent(this, e);
    }

    void __regularProcessMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    void __regularProcessMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }
}

