/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

class SavedExpansionState {
    private final Collection _expandItems;
    private final SwingExplorerGui _gui;
    private final XmlJTree _tree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SavedExpansionState saveState(SwingExplorerGui gui, XmlJTree tree) {
        XmlView view = gui.getView();
        view.acquireReadLock();
        try {
            XmlTreeModel treeModel = gui.getTreeModel();
            TreePath rootPath = new TreePath(tree.getModel().getRoot());
            Enumeration<TreePath> expandedPaths = tree.getExpandedDescendants(rootPath);
            LinkedList<Object> expandItems = new LinkedList<Object>();
            while (expandedPaths.hasMoreElements()) {
                TreePath curPath = expandedPaths.nextElement();
                Object lastComponent = curPath.getLastPathComponent();
                if (lastComponent instanceof Node) {
                    Node node = (Node)lastComponent;
                    if (!view.isInModelDocumentHierarchy(node)) {
                        List ancestorList = XmlTreeModel.getAncestorNodeListFromPath((XmlView)view, (TreePath)curPath);
                        node = view.remapNode(ancestorList);
                    }
                    if (node == null) continue;
                    expandItems.add(node);
                    continue;
                }
                if (!SavedExpansionState._modelContainsPath(treeModel, curPath)) continue;
                expandItems.add(curPath);
            }
            SavedExpansionState savedExpansionState = new SavedExpansionState(gui, tree, expandItems);
            return savedExpansionState;
        }
        finally {
            view.releaseReadLock();
        }
    }

    public void restore() {
        XmlTreeModel treeModel = this._gui.getTreeModel();
        for (Object item : this._expandItems) {
            TreePath path;
            if (item instanceof Node) {
                path = treeModel.getPathForDomElement((Node)item);
                if (path == null) continue;
                this._tree.expandPath(path);
                continue;
            }
            if (!(item instanceof TreePath) || !SavedExpansionState._modelContainsPath(treeModel, path = (TreePath)item)) continue;
            this._tree.expandPath(path);
        }
    }

    private SavedExpansionState(SwingExplorerGui gui, XmlJTree tree, Collection expandItems) {
        this._gui = gui;
        this._tree = tree;
        this._expandItems = expandItems;
    }

    private static boolean _modelContainsPath(XmlTreeModel model, TreePath path) {
        return path.equals(model.getErrorsFolderTreePathIfVisible());
    }
}

