/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.dnd.AutoscrollingDragListener;
import oracle.bali.xml.gui.swing.dnd.DropHandlerHelper;
import oracle.bali.xml.gui.swing.util.PointToModelFinder;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import org.w3c.dom.Node;

public class ModelDropHandler<ComponentType extends JComponent>
extends AutoscrollingDragListener {
    private final DropHandlerHelper _helper;
    private final PointToModelFinder _finder;
    private static final Logger _LOGGER = Logger.getLogger(ModelDropHandler.class.getName());

    public ModelDropHandler(XmlGui gui, PointToModelFinder<ComponentType> finder) {
        if (gui == null) {
            throw new IllegalArgumentException("No XmlGui specified");
        }
        this._finder = finder;
        this._helper = new Helper(gui);
    }

    protected ModelDropHandler(XmlGui gui) {
        this(gui, null);
    }

    public final XmlGui getGui() {
        return this._helper.getGui();
    }

    public final XmlView getView() {
        return this._helper.getView();
    }

    public final XmlModel getModel() {
        return this.getView().getBaseModel();
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        super.dragEnter(event);
        XmlGui gui = this.getGui();
        gui.getGuiContext().acquireDropTarget(gui);
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        super.dragOver(event);
        this.dropStartedHook();
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        super.dropActionChanged(event);
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        super.dragExit(event);
        this._helper.cleanupDrop();
        this.dropStoppedHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dropEvent) {
        super.drop(dropEvent);
        int action = this._helper.considerPossibilities(dropEvent);
        if (action == 0) {
            dropEvent.rejectDrop();
            this._helper.cleanupDrop();
            this.dropStoppedHook();
            return;
        }
        dropEvent.acceptDrop(1);
        boolean success = false;
        try {
            success = this._helper.performDrop(dropEvent);
        }
        finally {
            dropEvent.dropComplete(success);
            this.dropStoppedHook();
        }
    }

    protected void findOtherClosePositions(ComponentType dropComponent, Point location, DomPosition closestPosition, List out) {
    }

    protected DomPosition getClosestDropPosition(ComponentType dropComponent, Point location) {
        if (this._finder == null) {
            throw new IllegalStateException("ModelDropHandler was created without a PointToModelFinder, but getClosestDropPosition was not overridden!");
        }
        int x = location.x;
        int y = location.y;
        Node nearNode = this._finder.getNodeAt(dropComponent, x, y);
        if (nearNode != null) {
            return this._finder.getClosestPosition(dropComponent, nearNode, x, y);
        }
        return null;
    }

    protected void setDropLocation(final DomPosition dropPos) {
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) {
                model.getSelection().setDropLocation(dropPos);
            }
        }.run((AbstractModel)this.getView());
    }

    protected final PointToModelFinder getPointToModelFinder() {
        return this._finder;
    }

    protected void dropStartedHook() {
    }

    protected void dropStoppedHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _considerPossibilitiesAndAcceptOrReject(DropTargetDragEvent event) {
        int action = this._helper.considerPossibilitiesAndSetLocation(event);
        if (action > 0) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                this.getView().acquireReadLock();
                try {
                    DomPosition dropPos = this.getView().getSelection().getDropLocation();
                    _LOGGER.log(Level.FINER, "Accepting drag with action {0}; pos={1}", new Object[]{DropHandlerHelper.getActionText(action), dropPos});
                }
                finally {
                    this.getView().releaseReadLock();
                }
            }
            event.acceptDrag(event.getDropAction());
        } else {
            _LOGGER.finer("Rejecting drag!");
            event.rejectDrag();
        }
    }

    private class Helper
    extends DropHandlerHelper<ComponentType> {
        public Helper(XmlGui gui) {
            super(gui);
        }

        @Override
        protected DomPosition getClosestDropPosition(ComponentType dropComponent, Point location) {
            return ModelDropHandler.this.getClosestDropPosition(dropComponent, location);
        }

        @Override
        protected void findOtherClosePositions(ComponentType dropComponent, Point location, DomPosition closestPosition, List out) {
            ModelDropHandler.this.findOtherClosePositions(dropComponent, location, closestPosition, out);
        }

        @Override
        protected void setDropLocation(DomPosition dropPos) {
            ModelDropHandler.this.setDropLocation(dropPos);
        }
    }
}

