/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.gui.swing.util.XmlKeyPicker;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlMetadataUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.util.XmlSelectionAction;
import org.w3c.dom.Node;

public class SurroundAction
extends XmlSelectionAction {
    private boolean _nameSet = false;

    public SurroundAction() {
        super("", null, "surroundNode", true);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
    }

    public void actionPerformed(final ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        String txnName = this.getModel().getTranslatedString("SURROUND.ACTION_NAME");
        new FixedNameTransactionTask(txnName){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node surroundingNode;
                XmlModel baseModel = model.getBaseModel();
                if (event.getSource() instanceof Node) {
                    baseModel.getSelection().set((Node)event.getSource());
                }
                if (baseModel.getSelection().isEmpty()) {
                    this.cancelTask();
                }
                if ((surroundingNode = SurroundAction._doSurround(baseModel)) == null) {
                    this.cancelTask();
                }
            }
        }.run(this.getModel());
    }

    protected boolean isEnabledImpl() {
        if (!this._nameSet && this.getModel() != null) {
            SurroundAction.setActionName((Action)((Object)this), (String)this.getModel().getTranslatedString("SURROUND.MENU_ITEM"));
            this._nameSet = true;
        }
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel model = this.getModel();
        Selection s = model.getSelection();
        if (s.isEmpty()) {
            return false;
        }
        Node[] nodesToSurround = s.getSelectedNodesArray();
        if (nodesToSurround != null) {
            return model.getXmlMetadataResolver().isSurroundable(nodesToSurround);
        }
        return false;
    }

    private static Node _doSurround(XmlModel model) throws XmlCommitException {
        XmlContext context = model.getContext();
        Node firstNode = model.getSelection().getFirstSelectedNode();
        if (!DomUtils.isElement((Node)firstNode.getParentNode())) {
            return null;
        }
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        DomPosition position = DomPositionFactory.before((Node)firstNode);
        Map keyMap = XmlMetadataUtils.getCreatableChildrenMap((AbstractModel)model, (DomPosition)position);
        SurroundAction._filterMap(keyMap, (AbstractModel)model, model.getSelection().getSelectedNodesArray());
        String initialSelection = resolver.getShortDisplayName(ImmutableXmlKey.createNamespaceKey((String)firstNode.getNamespaceURI()));
        XmlKey selected = XmlKeyPicker.runDialog(UIUtils.getParentFrame(context), model.getTranslatedString("SURROUND.SURROUND_TITLE"), "f1_editorsurroundwith_html", keyMap, (AbstractModel)model, initialSelection);
        if (selected != null) {
            return model.surroundSelection(selected);
        }
        return null;
    }

    private static void _filterMap(Map map, AbstractModel model, Node[] nodesToSurround) {
        if (map.isEmpty()) {
            return;
        }
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Collection keys = (Collection)entry.getValue();
            Iterator keyItor = keys.iterator();
            while (keyItor.hasNext()) {
                XmlKey candidateKey = (XmlKey)keyItor.next();
                if (XmlMetadataUtils.isPossibleSurround((AbstractModel)model, (Node[])nodesToSurround, (XmlKey)candidateKey)) continue;
                keyItor.remove();
            }
            if (!keys.isEmpty()) continue;
            entries.remove();
        }
    }
}

