/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.awt.event.ActionEvent;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.gui.swing.util.Pickable;
import oracle.bali.xml.gui.swing.util.PickablePicker;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.Convertible;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import org.w3c.dom.Node;

public class ConvertAction
extends AbstractAction {
    private XmlContext _xmlContext;
    private Node _node;

    public ConvertAction(XmlContext xmlContext, Node node) {
        this(xmlContext, node, null);
    }

    public ConvertAction(XmlContext xmlContext, Node node, Convertible convertible) {
        this.putValue("show-in-context-menu-not-pi", Boolean.TRUE);
        this.putValue("show-in-context-menu", Boolean.FALSE);
        this.putValue("show-in-pi", Boolean.FALSE);
        this._xmlContext = xmlContext;
        this._node = node;
        Object[] args = convertible != null ? new String[]{convertible.getDisplayName()} : new String[]{""};
        String actionName = this._xmlContext.getModel().getTranslatedString("ConvertElementMenu", args);
        String strippedString = StringUtils.stripMnemonic((String)actionName);
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)actionName);
        this.putValue("Name", strippedString);
        this.putValue("MnemonicKey", IntegerUtils.getInteger((int)mnemonicKeyCode));
    }

    @Override
    public void actionPerformed(final ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        new NoNameTransactionTask(){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Selection baseSelection = ConvertAction.this._xmlContext.getModel().getBaseModel().getSelection();
                Node nodeToConvert = event.getSource() instanceof Node ? (Node)event.getSource() : baseSelection.getFirstSelectedNode();
                ConvertAction.launchDialog(model, nodeToConvert);
            }
        }.run((AbstractModel)this._xmlContext.getModel());
    }

    protected boolean isEnabledImpl(Node node) {
        XmlMetadataResolver resolver = this._xmlContext.getModel().getXmlMetadataResolver();
        return !resolver.isImmutable(node);
    }

    public static boolean launchDialog(AbstractModel model, Node nodeToConvert) throws XmlCommitException {
        if (nodeToConvert != null) {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            List plugins = resolver.getConvertPlugins(nodeToConvert);
            ArrayList<Convertible> convertibles = new ArrayList<Convertible>();
            for (ConvertPlugin plugin : plugins) {
                convertibles.addAll(plugin.getConvertibles(nodeToConvert));
            }
            int size = convertibles.size();
            if (size > 0) {
                Convertible convertible = null;
                convertible = size == 1 ? (Convertible)convertibles.get(0) : ConvertAction._showPickerDialog(model, nodeToConvert, convertibles);
                if (convertible != null) {
                    return convertible.doConvert(nodeToConvert);
                }
            }
        }
        return false;
    }

    private static Convertible _showPickerDialog(AbstractModel model, Node nodeToConvert, List<Convertible> convertibles) {
        ConvertPickable pickable;
        XmlModel baseModel = model.getBaseModel();
        XmlMetadataResolver resolver = baseModel.getXmlMetadataResolver();
        String title = baseModel.getTranslatedString("ConvertElement");
        String displayName = resolver.getMediumDisplayName(nodeToConvert);
        Object[] args = new String[]{displayName};
        Map<CategoryDefinition, List<Pickable>> pickableMap = ConvertAction.groupConvertiblessByCategory(model, convertibles);
        CategoryDefinition initialSelection = null;
        List catDefs = resolver.getCategoryDefinition(nodeToConvert);
        if (catDefs != null && !catDefs.isEmpty()) {
            initialSelection = (CategoryDefinition)catDefs.get(0);
        }
        if ((pickable = (ConvertPickable)PickablePicker.runDialog(UIUtils.getParentFrame(baseModel.getContext()), MessageFormat.format(title, args), "f1_editorconvert_html", pickableMap, (AbstractModel)baseModel, initialSelection)) != null) {
            return pickable.getConvertible();
        }
        return null;
    }

    private static Map<CategoryDefinition, List<Pickable>> groupConvertiblessByCategory(AbstractModel model, List<Convertible> convertibles) {
        if (convertibles == null) {
            return Collections.emptyMap();
        }
        HashMap<CategoryDefinition, ArrayList<ConvertPickable>> firstMap = new HashMap<CategoryDefinition, ArrayList<ConvertPickable>>();
        for (Convertible convertible : convertibles) {
            CategoryDefinition category = convertible.getCategory();
            ArrayList<ConvertPickable> collectionForNs = (ArrayList<ConvertPickable>)firstMap.get(category);
            if (collectionForNs == null) {
                collectionForNs = new ArrayList<ConvertPickable>();
                firstMap.put(category, collectionForNs);
            }
            collectionForNs.add(new ConvertPickable(convertible));
        }
        if (firstMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Collator collator = Collator.getInstance(model.getContext().getLocale());
        TreeMap<CategoryDefinition, List<Pickable>> realMap = new TreeMap<CategoryDefinition, List<Pickable>>(new CategoryDefinitionComparator(collator));
        PickableComparator convertComparator = new PickableComparator(collator);
        for (Map.Entry entry : firstMap.entrySet()) {
            CategoryDefinition category = (CategoryDefinition)entry.getKey();
            List pickables = (List)entry.getValue();
            Collections.sort(pickables, convertComparator);
            realMap.put(category, pickables);
        }
        return realMap;
    }

    private static class PickableComparator
    implements Comparator<Pickable> {
        Collator _collator;

        public PickableComparator(Collator collator) {
            this._collator = collator;
        }

        @Override
        public int compare(Pickable o1, Pickable o2) {
            return this._collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static class CategoryDefinitionComparator
    implements Comparator<CategoryDefinition> {
        Collator _collator;

        public CategoryDefinitionComparator(Collator collator) {
            this._collator = collator;
        }

        @Override
        public int compare(CategoryDefinition o1, CategoryDefinition o2) {
            return this._collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static class ConvertPickable
    implements Pickable {
        private Convertible _convertible;

        public ConvertPickable(Convertible convertible) {
            this._convertible = convertible;
        }

        @Override
        public String getDisplayName() {
            return this._convertible.getDisplayName();
        }

        @Override
        public Icon getIcon() {
            return this._convertible.getIcon();
        }

        public Convertible getConvertible() {
            return this._convertible;
        }
    }
}

