/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.AbstractXMLInsightProvider;
import oracle.bali.xml.editor.insight.AttributeInsightData;
import oracle.bali.xml.editor.insight.ElementEndTagInsightData;
import oracle.bali.xml.editor.insight.ElementInsightData;
import oracle.bali.xml.editor.insight.EnumerationValueInsightData;
import oracle.bali.xml.editor.insight.TextInsightData;
import oracle.bali.xml.editor.insight.ValueInsightData;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.AttributeItem;
import oracle.bali.xml.editor.insight.data.AttributeValueItemItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightView;

public class XMLCompletionInsightProvider
extends AbstractXMLInsightProvider {
    private static final int FEEDBACK_MESSAGE_DELAY = 5000;
    private static final String RESOURCE_KEY_NO_INSIGHT = "XMLEDITOR.INSIGHT.NO_INSIGHT";
    private String _feedBackString = XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.NO_INSIGHT");
    private ValueInsightData _valueInsight;
    private XMLTooltipInsightProvider _tooltipProvider;
    private EnumerationValueInsightData _enumerationValueInsight;

    public XMLCompletionInsightProvider(XmlContext xmlContext, DocumentScannerFactory docScannerFactory) {
        super(xmlContext, docScannerFactory);
    }

    public void setValueInsightData(ValueInsightData valueInsight) {
        this._valueInsight = valueInsight;
    }

    public ValueInsightData getValueInsightData() {
        return this._valueInsight;
    }

    public void setXMLTooltipInsightProvider(XMLTooltipInsightProvider tooltipProvider) {
        this._tooltipProvider = tooltipProvider;
    }

    public XMLTooltipInsightProvider getXMLTooltipInsightProvider() {
        return this._tooltipProvider;
    }

    public int getInsightType() {
        return 1;
    }

    public void showInsight(boolean wasAutoInvoked) {
        super.showInsight(false);
    }

    protected boolean isExactMatchSupported(InsightData data) {
        return data != null && data instanceof ElementEndTagInsightData;
    }

    public boolean isInsightTriggerChar(char typedChar) {
        if (typedChar == '<' || typedChar == ':' || typedChar == ' ') {
            return true;
        }
        if (typedChar == '/') {
            return true;
        }
        return typedChar == '\"';
    }

    public InsightView getInsightView() {
        return new ListInsightView((ListCellRenderer)((Object)new Renderer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InsightData getInsightData(BasicEditorPane editorPane) {
        InsightData insightData = null;
        ReadLockAndInsightLocation lockAndLocation = this._acquireReadLockAndInsightLocation(editorPane, null);
        if (lockAndLocation != null) {
            try {
                Object[] dataList;
                int contextType = lockAndLocation.getContextType();
                insightData = this.getInsightDataImpl(editorPane, lockAndLocation.getInsightLocation(), contextType);
                if (insightData != null && (dataList = insightData.getData()).length == 0) {
                    insightData = null;
                }
                if (insightData == null) {
                    if (contextType == 5 && this._tooltipProvider != null) {
                        this._tooltipProvider.showInsight();
                    } else {
                        this.showFeedback(this._feedBackString, 5000);
                    }
                } else {
                    this.hideFeedback();
                }
            }
            finally {
                lockAndLocation.releaseReadLock();
            }
        }
        return insightData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
        InsightData insightData = null;
        ReadLockAndInsightLocation lockAndLocation = this._acquireReadLockAndInsightLocation(editorPane, lastData);
        if (lockAndLocation != null) {
            try {
                insightData = this.updateInsightDataImpl(editorPane, lastData, lockAndLocation.getInsightLocation(), lockAndLocation.getContextType());
            }
            finally {
                lockAndLocation.releaseReadLock();
            }
        }
        return insightData;
    }

    protected boolean useDefaultReadLock() {
        return false;
    }

    protected InsightData getInsightDataImpl(BasicEditorPane editorPane, InsightLocation insightLocation, int contextType) {
        XMLInsightData insightData = null;
        switch (contextType) {
            case 1: {
                insightData = new ElementInsightData(this, insightLocation, false);
                break;
            }
            case 2: {
                insightData = new ElementInsightData(this, insightLocation, true);
                break;
            }
            case 3: {
                insightData = new AttributeInsightData(this, insightLocation, false, this.supportsAttributeNamespaceInsight());
                break;
            }
            case 4: {
                insightData = new AttributeInsightData(this, insightLocation, true, this.supportsAttributeNamespaceInsight());
                break;
            }
            case 5: {
                insightData = this._getAttributeValueInsightData(insightLocation);
                break;
            }
            case 6: {
                insightData = new ElementEndTagInsightData(this, insightLocation);
                break;
            }
            case 7: {
                insightData = new TextInsightData(this, insightLocation);
                break;
            }
        }
        return insightData;
    }

    protected InsightData updateInsightDataImpl(BasicEditorPane editorPane, InsightData lastData, InsightLocation insightLocation, int contextType) {
        if (lastData instanceof XMLInsightData) {
            XMLInsightData insightData = (XMLInsightData)lastData;
            switch (contextType) {
                case 1: {
                    if (insightData instanceof ElementInsightData && !((ElementInsightData)insightData).inLocalNameMode()) {
                        insightData.updateData();
                        break;
                    }
                    insightData = new ElementInsightData(this, insightLocation, false);
                    break;
                }
                case 2: {
                    if (insightData instanceof ElementInsightData && ((ElementInsightData)insightData).inLocalNameMode()) {
                        insightData.updateData();
                        break;
                    }
                    insightData = new ElementInsightData(this, insightLocation, true);
                    break;
                }
                case 3: {
                    if (insightData instanceof AttributeInsightData && !((AttributeInsightData)insightData).inLocalNameMode()) {
                        insightData.updateData();
                        break;
                    }
                    insightData = new AttributeInsightData(this, insightLocation, false, this.supportsAttributeNamespaceInsight());
                    break;
                }
                case 4: {
                    if (insightData instanceof AttributeInsightData && ((AttributeInsightData)insightData).inLocalNameMode()) {
                        insightData.updateData();
                        break;
                    }
                    insightData = new AttributeInsightData(this, insightLocation, true, this.supportsAttributeNamespaceInsight());
                    break;
                }
                case 5: {
                    if (insightData instanceof ValueInsightData) {
                        insightData.updateData();
                        break;
                    }
                    insightData = this._getAttributeValueInsightData(insightLocation);
                    break;
                }
                case 6: {
                    if (insightData instanceof ElementEndTagInsightData) {
                        insightData.updateData();
                        break;
                    }
                    insightData = new ElementEndTagInsightData(this, insightLocation);
                    break;
                }
                case 7: {
                    if (insightData instanceof TextInsightData) {
                        TextInsightData textData = (TextInsightData)insightData;
                        textData.updateInsightLocation(insightLocation);
                        textData.updateData();
                        break;
                    }
                    insightData = new TextInsightData(this, insightLocation);
                    break;
                }
                default: {
                    insightData = null;
                }
            }
            return insightData;
        }
        return lastData;
    }

    protected boolean supportsAttributeNamespaceInsight() {
        return true;
    }

    protected ValueInsightData getDefaultValueInsightData(InsightLocation insightLocation) {
        if (this._enumerationValueInsight == null) {
            this._enumerationValueInsight = new EnumerationValueInsightData();
        }
        return this._enumerationValueInsight;
    }

    private ValueInsightData _getAttributeValueInsightData(InsightLocation insightLocation) {
        ValueInsightData defaultData;
        ValueInsightData insightData = this.getValueInsightData();
        if (insightData != null) {
            insightData.initialize(this, insightLocation);
            Object[] dataList = insightData.getData();
            if (dataList.length == 0) {
                insightData = null;
            }
        }
        if (insightData == null && (defaultData = this.getDefaultValueInsightData(insightLocation)) != null) {
            defaultData.initialize(this, insightLocation);
            insightData = defaultData;
        }
        return insightData;
    }

    protected boolean isXmlModelLockRequired(BasicEditorPane editorPane, InsightLocation insightLocation, InsightData currentInsightData, int contextType) {
        return contextType == 5 && !(currentInsightData instanceof ValueInsightData);
    }

    private ReadLockAndInsightLocation _acquireReadLockAndInsightLocation(BasicEditorPane editorPane, InsightData currentInsightData) {
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        XmlModel xmlModel = this.getXmlContext().getModel();
        boolean isXmlModelLock = false;
        int contextType = 0;
        InsightLocation insightLocation = null;
        document.readLock();
        try {
            InsightParser parser = this.getInsightParser();
            insightLocation = parser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
            contextType = this.getContextType(insightLocation);
            if (this.isXmlModelLockRequired(editorPane, insightLocation, currentInsightData, contextType)) {
                int changeCount = document.getTextBuffer().getChangeId();
                document.readUnlock();
                xmlModel.acquireReadLock();
                isXmlModelLock = true;
                int newChangeCount = document.getTextBuffer().getChangeId();
                if (changeCount != newChangeCount) {
                    insightLocation = parser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
                    contextType = this.getContextType(insightLocation);
                }
            }
        }
        catch (Throwable t) {
            try {
                document.readUnlock();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.getLogger().log(Level.INFO, "Unexpected exception during XML Code Insight. Cancelling insight request.", t);
            return null;
        }
        return new ReadLockAndInsightLocation(insightLocation, document, xmlModel, contextType, isXmlModelLock);
    }

    private class Renderer
    extends ListDataItemCellRenderer {
        private boolean _required;

        private Renderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AttributeValueItemItem) {
                AttributeValueItemItem item = (AttributeValueItemItem)((Object)value);
                GuiXmlContext context = (GuiXmlContext)XMLCompletionInsightProvider.this.getXmlContext();
                XmlModel xmlModel = context.getModel();
                ListCellRenderer renderer = null;
                xmlModel.acquireReadLock();
                try {
                    BaseInspectorGui gui = (BaseInspectorGui)context.getGui(XmlUsage.PROPERTY_INSPECTOR);
                    renderer = gui.getCustomListCellRenderer(item.getAttribute(), item.getItem());
                }
                finally {
                    xmlModel.releaseReadLock();
                }
                if (renderer != null) {
                    return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                }
            }
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this._required = false;
            Font f = c.getFont();
            if (f == null) {
                f = list.getFont();
            }
            if (value instanceof AttributeItem && ((AttributeItem)((Object)value)).isRequired()) {
                this._required = true;
                if (!f.isBold()) {
                    f = f.deriveFont(1);
                }
            }
            c.setFont(f);
            return c;
        }

        public Dimension getPreferredSize() {
            Font f;
            if (this._required && (f = this.getFont()) != null && !f.isBold()) {
                Font newFont = f.deriveFont(1);
                this.setFont(newFont);
                Dimension d = super.getPreferredSize();
                this.setFont(f);
                return d;
            }
            return super.getPreferredSize();
        }

        public Object getPrototypeCell(JList list, ListModel listModel) {
            ListDataItem largestItem = null;
            int displayWidth = 0;
            Font font = list.getFont();
            FontMetrics metrics = list.getFontMetrics(font);
            Font requiredFont = null;
            FontMetrics requiredMetrics = null;
            int numElements = listModel.getSize();
            for (int i = 0; i < numElements; ++i) {
                AttributeItem ai;
                FontMetrics measureMetrics = metrics;
                ListDataItem item = (ListDataItem)listModel.getElementAt(i);
                if (item instanceof AttributeItem && (ai = (AttributeItem)item).isRequired()) {
                    if (requiredMetrics == null) {
                        requiredFont = font.deriveFont(1);
                        requiredMetrics = list.getFontMetrics(requiredFont);
                    }
                    measureMetrics = requiredMetrics;
                }
                int elementWidth = measureMetrics.stringWidth(item.getDisplayText());
                Icon icon = item.getIcon();
                if (icon != null) {
                    elementWidth = elementWidth + this.getIconTextGap() + icon.getIconWidth();
                }
                if (elementWidth <= displayWidth) continue;
                displayWidth = elementWidth;
                largestItem = item;
            }
            return largestItem;
        }
    }

    private class ReadLockAndInsightLocation {
        private InsightLocation _insightLocation;
        private int _contextType;
        private boolean _isXmlModelLock;
        private BasicDocument _document;
        private XmlModel _xmlModel;

        public ReadLockAndInsightLocation(InsightLocation insightLocation, BasicDocument document, XmlModel xmlModel, int contextType, boolean isXmlModelLock) {
            this._insightLocation = insightLocation;
            this._contextType = contextType;
            this._isXmlModelLock = isXmlModelLock;
            this._document = document;
            this._xmlModel = xmlModel;
        }

        public InsightLocation getInsightLocation() {
            return this._insightLocation;
        }

        public int getContextType() {
            return this._contextType;
        }

        public boolean isXmlModelLock() {
            return this._isXmlModelLock;
        }

        public XmlModel getXmlModel() {
            return this._xmlModel;
        }

        public BasicDocument getDocument() {
            return this._document;
        }

        public void releaseReadLock() {
            if (this.isXmlModelLock()) {
                this.getXmlModel().releaseReadLock();
            } else {
                this.getDocument().readUnlock();
            }
        }
    }
}

