/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.Arrays;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;

public abstract class ValueInsightData
implements XMLInsightData {
    private XMLCompletionInsightProvider _insight;
    private InsightLocation _insightLocation;
    private ReadOnlyListModel _listModel;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private Object _defaultData = null;
    private AttributeLocator _attrLocator = null;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR"));

    public void initialize(XMLCompletionInsightProvider insight, InsightLocation insightLocation) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this._attrLocator = null;
        this._clearData();
        List declarations = this._insightLocation.getElementDeclarations();
        if (declarations.size() > 0) {
            int caretPosition = this._insight.getCaretPosition();
            int lastIndex = declarations.size() - 1;
            ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastIndex);
            ResolvedName attrName = null;
            AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
            int attrIndex = InsightUtils.getAttributeAtCaretPosition(attributes, caretPosition);
            if (attrIndex != -1) {
                attrName = attributes.getResolvedName(attrIndex);
                this._attrLocator = attributes.getLocator(attrIndex);
            }
            if (attrName != null) {
                String namespace = attrName.getNamespace();
                String localName = attrName.getLocalName();
                if (localName != null && localName.length() > 0) {
                    QualifiedName attrQName = QualifiedName.getQualifiedName((String)namespace, (String)localName);
                    AttributeDef attributeDef = null;
                    ElementDef parentElementDef = InsightUtils.getElementDef(this.getProvider().getGrammarProvider(), declarations, lastIndex);
                    if (parentElementDef != null) {
                        attributeDef = parentElementDef.getAttributeDefByName(attrQName);
                    }
                    this._insightDataList = this.getListDataItems(attrQName, parentElementDef, attributeDef, elementDecl, attributes, attrIndex, caretPosition);
                    if (this._insightDataList == null) {
                        this._insightDataList = new ListDataItem[0];
                    } else {
                        Arrays.sort(this._insightDataList);
                        this.updateData();
                    }
                }
            }
        }
    }

    public abstract ListDataItem[] getListDataItems(QualifiedName var1, ElementDef var2, AttributeDef var3, ElementDeclaration var4, AttributeDeclarations var5, int var6, int var7);

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        String selectedName = this.getSelectedText(selectedObject);
        if (selectedName == null) {
            return false;
        }
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        editorPane.beginEdit(EDIT_DESCRIPTOR);
        TextLocator valueLocator = this._attrLocator.getValueLocator();
        int startOffset = valueLocator.getStartOffset();
        int endOffset = this.guessValueEndOffset((ReadTextBuffer)textBuffer, startOffset);
        try {
            String insertString = "\"" + selectedName + "\"";
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, insertString, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editorPane.endEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        textBuffer.writeLock(false);
        try {
            ListDataItem item;
            int i;
            int listSize;
            char lastChar;
            char firstChar;
            TextLocator valueLocator = this._attrLocator.getValueLocator();
            int startOffset = valueLocator.getStartOffset();
            int endOffset = this.guessValueEndOffset((ReadTextBuffer)textBuffer, startOffset);
            if (endOffset - startOffset > 0 && ((firstChar = textBuffer.getChar(startOffset)) == '\"' || firstChar == '\'')) {
                ++startOffset;
            }
            if (endOffset - startOffset > 0 && ((lastChar = textBuffer.getChar(endOffset - 1)) == '\"' || lastChar == '\'')) {
                --endOffset;
            }
            String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
            int startIndex = listSize = this._insightDataList != null ? this._insightDataList.length : 0;
            int endIndex = listSize;
            for (i = 0; i < listSize; ++i) {
                item = this._insightDataList[i];
                String itemName = item.getName();
                if (!itemName.startsWith(userPrefix)) continue;
                startIndex = i;
                break;
            }
            for (i = startIndex; i < listSize; ++i) {
                item = this._insightDataList[i];
                String endItemName = item.getName();
                if (endItemName.startsWith(userPrefix)) continue;
                endIndex = i;
                break;
            }
            if (startIndex == listSize) {
                return;
            }
            ListDataItem firstItem = this._insightDataList[startIndex];
            String commonPrefix = firstItem.getName();
            if (endIndex - startIndex > 1) {
                for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
                    ListDataItem nextItem = this._insightDataList[i2];
                    commonPrefix = InsightUtils.getCommonPrefix(commonPrefix, nextItem.getName());
                }
            }
            if (!commonPrefix.startsWith(userPrefix)) {
                System.err.println("userPrefix: " + userPrefix);
                System.err.println("commonPrefix: " + commonPrefix);
                throw new IllegalStateException("Common text/prefix error");
            }
            editorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                document.remove(startOffset, endOffset - startOffset);
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editorPane.endEdit();
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    @Override
    public void updateData() {
        char lastChar;
        char firstChar;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        TextLocator valueLocator = this._attrLocator.getValueLocator();
        int startOffset = valueLocator.getStartOffset();
        int endOffset = this.guessValueEndOffset((ReadTextBuffer)textBuffer, startOffset);
        if (caretOffset < startOffset || caretOffset > endOffset) {
            this._clearData();
            return;
        }
        if (endOffset - startOffset > 0 && ((firstChar = textBuffer.getChar(startOffset)) == '\"' || firstChar == '\'')) {
            ++startOffset;
        }
        if (endOffset - startOffset > 0 && ((lastChar = textBuffer.getChar(endOffset - 1)) == '\"' || lastChar == '\'')) {
            --endOffset;
        }
        String userPrefix = "";
        if (caretOffset > startOffset) {
            if (caretOffset < endOffset) {
                endOffset = caretOffset;
            }
            userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        }
        this._setDefault(userPrefix);
        this.fillMatchingData(userPrefix);
    }

    protected String getSelectedText(Object o) {
        ListDataItem selectedItem = (ListDataItem)o;
        return selectedItem.getName();
    }

    protected int guessValueEndOffset(ReadTextBuffer textBuffer, int startOffset) {
        char quote = '\u0000';
        int endOffset = startOffset;
        boolean done = false;
        boolean containsFishyCharacter = false;
        boolean terminatedNormally = true;
        int firstSpaceOrFishyCharacter = -1;
        int lastSlashCharacter = -1;
        if (endOffset >= 0) {
            while (endOffset < textBuffer.getLength() && !done) {
                char currentChar = textBuffer.getChar(endOffset);
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (quote == '\u0000') {
                            done = true;
                        }
                        if (firstSpaceOrFishyCharacter != -1) break;
                        firstSpaceOrFishyCharacter = endOffset;
                        break;
                    }
                    case '/': {
                        if (quote == '\u0000') {
                            done = true;
                        }
                        lastSlashCharacter = endOffset;
                        break;
                    }
                    case '=': 
                    case '>': 
                    case '?': {
                        if (quote == '\u0000') {
                            done = true;
                            break;
                        }
                        containsFishyCharacter = true;
                        if (firstSpaceOrFishyCharacter != -1) break;
                        firstSpaceOrFishyCharacter = endOffset;
                        break;
                    }
                    case '<': {
                        done = true;
                        terminatedNormally = false;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (quote != '\u0000') {
                            if (quote != currentChar) break;
                            quote = '\u0000';
                            break;
                        }
                        quote = currentChar;
                        break;
                    }
                }
                if (done) continue;
                ++endOffset;
            }
            if (!terminatedNormally || containsFishyCharacter) {
                if (lastSlashCharacter != -1 && lastSlashCharacter < endOffset) {
                    endOffset = lastSlashCharacter;
                }
                if (firstSpaceOrFishyCharacter != -1 && firstSpaceOrFishyCharacter < endOffset) {
                    endOffset = firstSpaceOrFishyCharacter;
                }
            }
        }
        return endOffset;
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._listModel = null;
        this._matchingDataList = null;
    }

    private void fillMatchingData(String userPrefix) {
        this._matchingDataList = SortedInsightInputFilter.INSTANCE.getMatchingData(this._insightDataList, userPrefix);
    }

    private void _setDefault(String userPrefix) {
        this._defaultData = null;
        if (this._insightDataList.length == 0 || userPrefix == null) {
            return;
        }
        int listSize = this._insightDataList.length;
        int prefixLength = userPrefix.length();
        String lowerCasePrefix = userPrefix.toLowerCase();
        for (int j = prefixLength; j > 0; --j) {
            String shortenedPrefix = userPrefix.substring(0, j);
            ListDataItem lowerCaseMatch = null;
            for (int i = 0; i < listSize; ++i) {
                ListDataItem item = this._insightDataList[i];
                String itemName = item.getName();
                if (itemName.startsWith(shortenedPrefix)) {
                    this._defaultData = item;
                    return;
                }
                if (lowerCaseMatch != null || !itemName.toLowerCase().startsWith(lowerCasePrefix)) continue;
                lowerCaseMatch = item;
            }
            if (lowerCaseMatch == null) continue;
            this._defaultData = lowerCaseMatch;
            return;
        }
    }

    protected XMLCompletionInsightProvider getProvider() {
        return this._insight;
    }

    protected InsightLocation getInsightLocation() {
        return this._insightLocation;
    }

    private ReadOnlyListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ReadOnlyListModel((Object[])this._insightDataList);
        }
        return this._listModel;
    }
}

