/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.ElementItem;
import oracle.bali.xml.editor.insight.data.NamespaceItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;

public class ElementInsightData
implements XMLInsightData {
    private Object _defaultData = null;
    private boolean _localNameMode = false;
    private XMLCompletionInsightProvider _insight;
    private ReadOnlyListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));
    private static final HashSet _NAMESPACE_DECL_FILTER = new HashSet();

    public ElementInsightData(XMLCompletionInsightProvider insight, InsightLocation insightLocation, boolean localNameMode) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this._localNameMode = localNameMode;
        this.fillDataList();
        this._updateDataImpl();
    }

    public final boolean inLocalNameMode() {
        return this._localNameMode;
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private ReadOnlyListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ReadOnlyListModel((Object[])this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        int colonIndex;
        int startOffset;
        int endOffset;
        boolean retriggerInsight = false;
        BaseItem selectedItem = (BaseItem)((Object)selectedObject);
        String selectedName = selectedItem.getName();
        if (selectedItem instanceof NamespaceItem) {
            retriggerInsight = true;
        }
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        editorPane.beginEdit(EDIT_DESCRIPTOR);
        List declarations = this._insightLocation.getElementDeclarations();
        int lastDeclIndex = declarations.size() - 1;
        ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastDeclIndex);
        for (endOffset = startOffset = elementDecl.getElementLocator().getStartOffset() + 1; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '/' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
        }
        String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        if (this._localNameMode && (colonIndex = userPrefix.indexOf(":")) != -1) {
            startOffset += colonIndex + 1;
        }
        TreeSet requiredAttributes = null;
        if (selectedItem instanceof ElementItem) {
            try {
                if (EditorProperties.getProperties().getBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION")) {
                    ElementItem elItem = (ElementItem)selectedItem;
                    ElementDef anElementDef = elItem.getElementDef();
                    requiredAttributes = this.getMissingRequiredAttributes(anElementDef, elementDecl, caretOffset);
                }
            }
            catch (Exception e) {
                requiredAttributes = null;
            }
        }
        try {
            StringBuffer insertStringBuffer = new StringBuffer();
            insertStringBuffer.append(selectedName);
            if (requiredAttributes != null && requiredAttributes.size() > 0) {
                NamespaceDeclarations namespaceDecls = this._insightLocation.getNamespaceDeclarations();
                for (QualifiedName missingAttrName : requiredAttributes) {
                    String namespacePrefix = null;
                    String namespace = missingAttrName.getNamespace();
                    if (namespace != null && namespace.length() > 0 && (namespacePrefix = InsightUtils.getPrefix(namespaceDecls, namespace)) == null) continue;
                    insertStringBuffer.append(" ");
                    if (namespacePrefix != null) {
                        insertStringBuffer.append(namespacePrefix);
                        insertStringBuffer.append(":");
                    }
                    insertStringBuffer.append(missingAttrName.getName());
                    insertStringBuffer.append("=\"\"");
                }
            }
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, insertStringBuffer.toString(), null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editorPane.endEdit();
        }
        return retriggerInsight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        textBuffer.writeLock(false);
        try {
            BaseItem item;
            int i;
            int listSize;
            int colonIndex;
            int startOffset;
            int endOffset;
            List declarations = this._insightLocation.getElementDeclarations();
            int lastDeclIndex = declarations.size() - 1;
            ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastDeclIndex);
            for (endOffset = startOffset = elementDecl.getElementLocator().getStartOffset() + 1; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '/' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
            }
            String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
            if (this._localNameMode && (colonIndex = userPrefix.indexOf(":")) != -1) {
                userPrefix = userPrefix.substring(colonIndex + 1);
                startOffset += colonIndex + 1;
            }
            int startIndex = listSize = this._insightDataList != null ? this._insightDataList.length : 0;
            int endIndex = listSize;
            for (i = 0; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (!itemName.startsWith(userPrefix)) continue;
                startIndex = i;
                break;
            }
            for (i = startIndex; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String endItemName = item.getName();
                if (endItemName.startsWith(userPrefix)) continue;
                endIndex = i;
                break;
            }
            if (startIndex == listSize) {
                return;
            }
            BaseItem firstItem = (BaseItem)this._insightDataList[startIndex];
            String commonPrefix = firstItem.getName();
            if (endIndex - startIndex > 1) {
                for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
                    BaseItem nextItem = (BaseItem)this._insightDataList[i2];
                    commonPrefix = InsightUtils.getCommonPrefix(commonPrefix, nextItem.getName());
                }
            }
            if (!commonPrefix.startsWith(userPrefix)) {
                System.err.println("userPrefix: " + userPrefix);
                System.err.println("commonPrefix: " + commonPrefix);
                throw new IllegalStateException("Common text/prefix error");
            }
            editorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                document.remove(startOffset, endOffset - startOffset);
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editorPane.endEdit();
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    @Override
    public void updateData() {
        this._updateDataImpl();
    }

    protected final XMLCompletionInsightProvider getInsightProvider() {
        return this._insight;
    }

    protected final InsightLocation getInsightLocation() {
        return this._insightLocation;
    }

    protected void fillDataList() {
        TreeSet listData = new TreeSet();
        List declarations = this._insightLocation.getElementDeclarations();
        if (declarations.size() > 0) {
            ElementDef parentElementDef;
            int lastIndex = declarations.size() - 1;
            int parentIndex = declarations.size() - 2;
            NamespaceDeclarations namespaceDecls = this._insightLocation.getNamespaceDeclarations();
            String defaultNamespace = namespaceDecls.getDefaultNamespace();
            if (declarations.size() > 1 && (parentElementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), declarations, parentIndex)) != null) {
                String lastNamespace;
                ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastIndex);
                if (this._localNameMode) {
                    ResolvedName elementName = elementDecl.getResolvedName();
                    lastNamespace = elementName.getNamespace();
                } else {
                    this.addPrefixes(listData, namespaceDecls);
                    lastNamespace = defaultNamespace;
                }
                this.addValidChildren(listData, parentElementDef, lastNamespace);
            }
            if (declarations.size() == 1) {
                String namespace;
                ElementDeclaration onlyDecl = (ElementDeclaration)declarations.get(lastIndex);
                if (this._localNameMode) {
                    ResolvedName onlyName = onlyDecl.getResolvedName();
                    namespace = onlyName.getNamespace();
                } else {
                    this.addPrefixes(listData, namespaceDecls);
                    namespace = defaultNamespace;
                }
                GrammarProvider provider = this._insight.getGrammarProvider();
                this.addTopLevelElements(listData, provider.getGrammarForNamespace(namespace));
            }
        }
        this.postProcessDataList(listData);
        this._insightDataList = new ListDataItem[listData.size()];
        listData.toArray(this._insightDataList);
    }

    protected void postProcessDataList(TreeSet listData) {
    }

    protected void addPrefixes(TreeSet listData, NamespaceDeclarations namespaceDecls) {
        Collection prefixDecls = namespaceDecls.getPrefixDeclarations();
        for (NamespaceDeclaration decl : prefixDecls) {
            if (_NAMESPACE_DECL_FILTER.contains(decl.getNamespace())) continue;
            listData.add(new NamespaceItem(decl.getNamespace(), decl.getPrefix()));
        }
    }

    protected void addValidChildren(TreeSet listData, ElementDef parentElementDef, String namespace) {
        if (parentElementDef != null) {
            GrammarProvider provider;
            Grammar g;
            this.addCollection(listData, parentElementDef.getElementDefs(), namespace);
            List wildcards = TypeUtils.getElementWildcards((ElementDef)parentElementDef);
            Wildcard wildcard = TypeUtils.getMatchingWildcard((List)wildcards, (String)namespace);
            if (wildcard != null && (g = (provider = this._insight.getGrammarProvider()).getGrammarForNamespace(namespace)) != null) {
                this.addCollection(listData, g.getElementDefs(), namespace);
            }
        }
    }

    protected void addCollection(TreeSet listData, Collection elements, String namespace) {
        if (elements != null) {
            ArrayList elemArray = new ArrayList(elements);
            for (int i = 0; i < elemArray.size(); ++i) {
                ElementDef anEl = (ElementDef)elemArray.get(i);
                String elementNamespace = anEl.getTargetNamespace();
                if (namespace == null) {
                    if (elementNamespace != null) continue;
                    listData.add(new ElementItem(anEl));
                    continue;
                }
                if (!namespace.equals(elementNamespace)) continue;
                listData.add(new ElementItem(anEl));
            }
        }
    }

    protected void addTopLevelElements(TreeSet listData, Grammar aGrammar) {
        if (aGrammar != null) {
            this.addCollection(listData, aGrammar.getElementDefs(), aGrammar.getTargetNamespace());
        }
    }

    protected TreeSet getMissingRequiredAttributes(ElementDef elementDef, ElementDeclaration elementDecl, int caretPosition) {
        Collection attributeDefs;
        TreeSet<QualifiedName> missingRequiredAttributes = new TreeSet<QualifiedName>();
        if (elementDef != null && (attributeDefs = elementDef.getAttributeDefs()) != null) {
            ArrayList requiredAttributeDefs = InsightUtils.getRequiredAttributeDefs(attributeDefs);
            Set existingAttrs = InsightUtils.getExistingAttributes(elementDecl, caretPosition);
            for (int i = 0; i < requiredAttributeDefs.size(); ++i) {
                AttributeDef anAttribute = (AttributeDef)requiredAttributeDefs.get(i);
                QualifiedName attrQName = anAttribute.getQualifiedName();
                if (existingAttrs.contains(attrQName)) continue;
                missingRequiredAttributes.add(attrQName);
            }
        }
        return missingRequiredAttributes;
    }

    private void _updateDataImpl() {
        int startOffset;
        int endOffset;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        List declarations = this._insightLocation.getElementDeclarations();
        ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(declarations.size() - 1);
        for (endOffset = startOffset = elementDecl.getElementLocator().getStartOffset() + 1; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '/' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
        }
        String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        boolean caretAfterIndex = false;
        boolean modeChanged = false;
        int colonIndex = userPrefix.indexOf(58);
        if (colonIndex != -1 && caretOffset > startOffset + colonIndex) {
            caretAfterIndex = true;
        }
        if (caretAfterIndex) {
            if (this._localNameMode) {
                startOffset += colonIndex + 1;
            } else {
                modeChanged = true;
            }
        } else if (this._localNameMode) {
            modeChanged = true;
        }
        if (modeChanged || caretOffset < startOffset || caretOffset > endOffset) {
            this._clearData();
            return;
        }
        userPrefix = new String(textBuffer.getChars(startOffset, caretOffset - startOffset));
        this._fillDefault(userPrefix);
        this._fillMatchingData(userPrefix);
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void _fillMatchingData(String userPrefix) {
        this._matchingDataList = SortedInsightInputFilter.INSTANCE.getMatchingData(this._insightDataList, userPrefix);
    }

    private void _fillDefault(String userPrefix) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int listSize = this._insightDataList.length;
        int prefixLength = userPrefix.length();
        String lowerCasePrefix = userPrefix.toLowerCase();
        for (int j = prefixLength; j > 0; --j) {
            String shortenedPrefix = userPrefix.substring(0, j);
            BaseItem lowerCaseMatch = null;
            for (int i = 0; i < listSize; ++i) {
                BaseItem item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (itemName.startsWith(shortenedPrefix)) {
                    this._defaultData = item;
                    return;
                }
                if (lowerCaseMatch != null || !itemName.toLowerCase().startsWith(lowerCasePrefix)) continue;
                lowerCaseMatch = item;
            }
            if (lowerCaseMatch == null) continue;
            this._defaultData = lowerCaseMatch;
            return;
        }
    }

    static {
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/XML/1998/namespace");
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/2000/xmlns/");
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/2001/XMLSchema-instance");
        _NAMESPACE_DECL_FILTER.add("http://xmlns.oracle.com/jdeveloper/xmlef/ignored");
    }
}

