/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.AttributeItem;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.NamespaceItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;

public class AttributeInsightData
implements XMLInsightData {
    private Object _defaultData = null;
    private XMLCompletionInsightProvider _insight;
    private ReadOnlyListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private boolean _localNameMode = false;
    private boolean _showNamespacePrefixes = true;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ATTRIBUTE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ATTRIBUTE_DESCRIPTOR"));

    public AttributeInsightData(XMLCompletionInsightProvider insight, InsightLocation insightLocation, boolean localNameMode) {
        this(insight, insightLocation, localNameMode, true);
    }

    public AttributeInsightData(XMLCompletionInsightProvider insight, InsightLocation insightLocation, boolean localNameMode, boolean showNamespacePrefixes) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this._localNameMode = localNameMode;
        this._showNamespacePrefixes = showNamespacePrefixes;
        this.fillDataList();
        this.updateData();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    public boolean inLocalNameMode() {
        return this._localNameMode;
    }

    private ReadOnlyListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ReadOnlyListModel((Object[])this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        int colonIndex;
        int endOffset;
        int startOffset;
        boolean retriggerInsight = true;
        BaseItem selectedItem = (BaseItem)((Object)selectedObject);
        String selectedName = selectedItem.getName();
        boolean selectedNamespacePrefix = selectedItem instanceof NamespaceItem;
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        editorPane.beginEdit(EDIT_DESCRIPTOR);
        for (startOffset = caretOffset - 1; startOffset >= 0 && textBuffer.getChar(startOffset) != ' ' && textBuffer.getChar(startOffset) != '\t' && textBuffer.getChar(startOffset) != '\n'; --startOffset) {
        }
        int endingChar = 32;
        for (endOffset = ++startOffset; endOffset < textBuffer.getLength(); ++endOffset) {
            if (textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '=' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>' && textBuffer.getChar(endOffset) != '/') continue;
            endingChar = textBuffer.getChar(endOffset);
            break;
        }
        String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        if (this._localNameMode && (colonIndex = userPrefix.indexOf(":")) != -1) {
            userPrefix = userPrefix.substring(colonIndex + 1);
            startOffset += colonIndex + 1;
        }
        try {
            String insertString = selectedName;
            if (!selectedNamespacePrefix) {
                if (endingChar != 61) {
                    insertString = insertString + "=\"";
                } else {
                    retriggerInsight = false;
                }
            }
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, insertString, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editorPane.endEdit();
        }
        return retriggerInsight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        textBuffer.writeLock(false);
        try {
            BaseItem item;
            int i;
            int listSize;
            int colonIndex;
            int endOffset;
            int startOffset;
            for (startOffset = caretOffset - 1; startOffset >= 0 && textBuffer.getChar(startOffset) != ' ' && textBuffer.getChar(startOffset) != '\t' && textBuffer.getChar(startOffset) != '\n'; --startOffset) {
            }
            for (endOffset = ++startOffset; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '=' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>' && textBuffer.getChar(endOffset) != '/'; ++endOffset) {
            }
            String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
            if (this._localNameMode && (colonIndex = userPrefix.indexOf(":")) != -1) {
                userPrefix = userPrefix.substring(colonIndex + 1);
                startOffset += colonIndex + 1;
            }
            int startIndex = listSize = this._insightDataList != null ? this._insightDataList.length : 0;
            int endIndex = listSize;
            for (i = 0; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (!itemName.startsWith(userPrefix)) continue;
                startIndex = i;
                break;
            }
            for (i = startIndex; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String endItemName = item.getName();
                if (endItemName.startsWith(userPrefix)) continue;
                endIndex = i;
                break;
            }
            if (startIndex == listSize) {
                return;
            }
            BaseItem firstItem = (BaseItem)this._insightDataList[startIndex];
            String commonPrefix = firstItem.getName();
            if (endIndex - startIndex > 1) {
                for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
                    BaseItem nextItem = (BaseItem)this._insightDataList[i2];
                    commonPrefix = InsightUtils.getCommonPrefix(commonPrefix, nextItem.getName());
                }
            }
            if (!commonPrefix.startsWith(userPrefix)) {
                System.err.println("userPrefix: " + userPrefix);
                System.err.println("commonPrefix: " + commonPrefix);
                throw new IllegalStateException("Common text/prefix error");
            }
            editorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                document.remove(startOffset, endOffset - startOffset);
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editorPane.endEdit();
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    @Override
    public void updateData() {
        int endOffset;
        int startOffset;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        for (startOffset = caretOffset - 1; startOffset >= 0 && textBuffer.getChar(startOffset) != ' ' && textBuffer.getChar(startOffset) != '\t' && textBuffer.getChar(startOffset) != '\n'; --startOffset) {
        }
        for (endOffset = ++startOffset; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '=' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>' && textBuffer.getChar(endOffset) != '/'; ++endOffset) {
        }
        String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        boolean caretAfterIndex = false;
        boolean modeChanged = false;
        int colonIndex = userPrefix.indexOf(58);
        if (colonIndex != -1 && caretOffset > startOffset + colonIndex) {
            caretAfterIndex = true;
        }
        if (caretAfterIndex) {
            if (this._localNameMode) {
                userPrefix = userPrefix.substring(colonIndex + 1);
                startOffset += colonIndex + 1;
            } else {
                modeChanged = true;
            }
        } else if (this._localNameMode) {
            modeChanged = true;
        }
        if (modeChanged || caretOffset < startOffset || caretOffset > endOffset) {
            this.clearData();
            return;
        }
        char[] chars = textBuffer.getChars(startOffset, caretOffset - startOffset);
        userPrefix = new String(chars);
        this.fillDefault(userPrefix);
        this.fillMatchingData(userPrefix);
    }

    private void clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void fillDataList() {
        TreeSet listData = new TreeSet();
        List declarations = this._insightLocation.getElementDeclarations();
        if (declarations.size() > 0) {
            int caretPosition = this._insight.getCaretPosition();
            int lastIndex = declarations.size() - 1;
            ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastIndex);
            NamespaceDeclarations namespaceDecls = this._insightLocation.getNamespaceDeclarations();
            ElementDef parentElementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), declarations, lastIndex);
            if (parentElementDef != null) {
                Set existingAttrs = InsightUtils.getExistingAttributes(elementDecl, caretPosition);
                if (!this._localNameMode) {
                    this._addPrefixes(listData, namespaceDecls);
                    this._addValidAttributes(listData, parentElementDef, existingAttrs, null);
                } else {
                    String namespace;
                    ResolvedName attrName = null;
                    AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
                    int attrIndex = InsightUtils.getAttributeAtCaretPosition(attributes, caretPosition);
                    if (attrIndex != -1) {
                        attrName = attributes.getResolvedName(attrIndex);
                    }
                    if (attrName != null && (namespace = attrName.getNamespace()) != null) {
                        this._addValidAttributes(listData, parentElementDef, existingAttrs, namespace);
                    }
                }
            }
        }
        this._insightDataList = new ListDataItem[listData.size()];
        listData.toArray(this._insightDataList);
    }

    private void _addPrefixes(TreeSet listData, NamespaceDeclarations namespaceDecls) {
        if (this._showNamespacePrefixes) {
            Collection prefixDecls = namespaceDecls.getPrefixDeclarations();
            for (NamespaceDeclaration decl : prefixDecls) {
                if ("http://xmlns.oracle.com/jdeveloper/xmlef/ignored".equals(decl.getNamespace())) continue;
                listData.add(new NamespaceItem(decl.getNamespace(), decl.getPrefix(), true));
            }
        }
    }

    private void _addValidAttributes(TreeSet listData, ElementDef parentElementDef, Set existingAttrs, String namespace) {
        if (parentElementDef != null) {
            GrammarProvider provider;
            Grammar g;
            ComplexType complexType;
            Wildcard attrWildcard;
            this._addCollection(listData, parentElementDef.getAttributeDefs(), existingAttrs, namespace);
            Type elementType = parentElementDef.getType();
            if (elementType instanceof ComplexType && (attrWildcard = (complexType = (ComplexType)elementType).getAttributeWildcard()) != null && TypeUtils.wildcardAllowsNamespace((Wildcard)attrWildcard, (String)namespace) && (g = (provider = this._insight.getGrammarProvider()).getGrammarForNamespace(namespace)) != null) {
                this._addCollection(listData, g.getAttributeDefs(), existingAttrs, namespace);
            }
        }
    }

    private void _addCollection(TreeSet listData, Collection attributeDefs, Set existingAttrs, String namespace) {
        if (attributeDefs != null) {
            ArrayList attArray = new ArrayList(attributeDefs);
            for (int i = 0; i < attArray.size(); ++i) {
                AttributeDef anAttribute = (AttributeDef)attArray.get(i);
                QualifiedName attrQName = anAttribute.getQualifiedName();
                if (existingAttrs.contains(attrQName)) continue;
                String attrNamespace = attrQName.getNamespace();
                if (namespace != null) {
                    if (!namespace.equals(attrNamespace)) continue;
                    listData.add(new AttributeItem(anAttribute));
                    continue;
                }
                if (attrNamespace != null) continue;
                listData.add(new AttributeItem(anAttribute));
            }
        }
    }

    private void fillMatchingData(String userPrefix) {
        this._matchingDataList = SortedInsightInputFilter.INSTANCE.getMatchingData(this._insightDataList, userPrefix);
    }

    private void fillDefault(String userPrefix) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int listSize = this._insightDataList.length;
        int prefixLength = userPrefix.length();
        String lowerCasePrefix = userPrefix.toLowerCase();
        for (int j = prefixLength; j > 0; --j) {
            String shortenedPrefix = userPrefix.substring(0, j);
            BaseItem lowerCaseMatch = null;
            for (int i = 0; i < listSize; ++i) {
                BaseItem item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (itemName.startsWith(shortenedPrefix)) {
                    this._defaultData = item;
                    return;
                }
                if (lowerCaseMatch != null || !itemName.toLowerCase().startsWith(lowerCasePrefix)) continue;
                lowerCaseMatch = item;
            }
            if (lowerCaseMatch == null) continue;
            this._defaultData = lowerCaseMatch;
            return;
        }
    }
}

