/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.ide.panels.TraversableContext;

public class SummaryTreeModel {
    private TraversableContext m_context;

    public SummaryTreeModel(TraversableContext traversableContext) {
        this.m_context = traversableContext;
    }

    public DefaultMutableTreeNode getApplicationTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_SUMMARY_TITLE"));
        defaultMutableTreeNode.add(this.getApplicationDetails());
        defaultMutableTreeNode.add(this.getDatabaseType());
        if (this.hasRulesTree()) {
            defaultMutableTreeNode.add(this.getRulesTree());
        }
        defaultMutableTreeNode.add(this.getAppDirectory());
        defaultMutableTreeNode.add(this.getOutputTree());
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getAppDirectory() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_APP_DIR")));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode((String)this.m_context.get("INPUT_DIR")));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDatabaseType() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_DATABASE_TYPE")));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode((String)this.m_context.get("DATABASE_TYPE")));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getOutputTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_ACTIONS"));
        String string = (String)this.m_context.get("STATE");
        if (string.equals("SCAN_ONLY")) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(AppScanArb.get("SCAN_APP")));
        } else if (string.equals("INPLACE")) {
            if (this.m_context.contains("INPLACE") && ((String)this.m_context.get("INPLACE")).equals("true")) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_REPLACEMENT"));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_INPLACE")));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        } else if (string.equals("OUTPUT")) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_REPLACEMENT"));
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_OUTPUT"));
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode(this.m_context.get("OUTPUT_DIR")));
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode;
    }

    private boolean hasRulesTree() {
        return this.m_context.contains("RULESDIR");
    }

    private DefaultMutableTreeNode getRulesTree() {
        if (this.m_context.contains("RULESDIR")) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_RULES"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode((String)this.m_context.get("RULESDIR")));
            return defaultMutableTreeNode;
        }
        return null;
    }

    public DefaultMutableTreeNode getApplicationDetails() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(AppScanArb.get("APPSCAN_DETAILS"));
        defaultMutableTreeNode.add(this.getApplicationName());
        defaultMutableTreeNode.add(this.getApplicationDescription());
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getApplicationDescription() {
        String string = (String)this.m_context.get("APPLICATION_DESC");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Description");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getApplicationName() {
        String string = (String)this.m_context.get("APPLICATION_NAME");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Name");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
        return defaultMutableTreeNode;
    }

    public DefaultTreeModel getTreeModel() {
        return new DefaultTreeModel(this.getApplicationTree());
    }
}

