/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorWindow;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.raptor.migration.applications.ui.AppScanWiz;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;

public class MigrateApplicationContextMenuListener
implements ContextMenuListener {
    private static Logger LOGGER = Logger.getLogger(MigrateApplicationContextMenuListener.class.getName());
    private IdeAction _applicationScanAction;
    private static final int APPLICATION_SCAN_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.ApplicationScan");

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof MigrationProjectNavigatorWindow && elementArray.length == 1) {
            if (elementArray[0] instanceof CapturedConnectionNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getApplicationScanAction()));
            } else if (elementArray[0] instanceof ApplicationsFolderNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getApplicationScanAction()));
            } else if (elementArray[0] instanceof MigrationProjectNode) {
                // empty if block
            }
        }
    }

    private IdeAction getApplicationScanAction() {
        if (null == this._applicationScanAction) {
            Icon icon = null;
            this._applicationScanAction = IdeAction.get((int)APPLICATION_SCAN_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString((String)"APPLICATION_SCAN_CMD"), null, null, icon, null, (boolean)true);
            this._applicationScanAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (APPLICATION_SCAN_CMD_ID == n) {
                        Element[] elementArray = context.getSelection();
                        CustomNode customNode = (CustomNode)elementArray[0];
                        MigrateApplicationContextMenuListener.this.applicationScan(customNode);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (APPLICATION_SCAN_CMD_ID == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._applicationScanAction;
    }

    private void applicationScan(final CustomNode customNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppScanWiz appScanWiz = new AppScanWiz();
                appScanWiz.setNode(customNode);
                appScanWiz.launch();
            }
        });
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }
}

