/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.migration.applications.report.ReportEngine;
import oracle.dbtools.raptor.migration.applications.report.ReportEngineFactory;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessor;
import oracle.dbtools.raptor.migration.applications.ui.OnlineScannerDetails;
import oracle.dbtools.raptor.migration.applications.ui.SummaryTreeModel;
import oracle.ide.model.Element;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class AppScanTreeSummary
extends DefaultTraversablePanel {
    private static Logger LOGGER = Logger.getLogger(AppScanTreeSummary.class.getName());
    private static final long serialVersionUID = 1L;
    protected JTree summary = new JTree();
    private TraversableContext m_ctx;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public AppScanTreeSummary() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.summary.setCellRenderer(new NodeRenderer());
        jScrollPane.setViewportView(this.summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        SummaryTreeModel summaryTreeModel = new SummaryTreeModel(traversableContext);
        this.summary.setModel(summaryTreeModel.getTreeModel());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            DatabaseQueryTask<Object> databaseQueryTask = new DatabaseQueryTask<Object>("Scanning Application", IRaptorTaskRunMode.MODAL_OPTIONAL, false, false){

                public String getConnectionName() {
                    return MigrationAddin.getDefaultMigrationRepository();
                }

                public String getQuery() {
                    return AppScanArb.getString("APPSCAN_SCANNING_APPLICATION");
                }

                protected Object doWork() throws TaskException {
                    try {
                        OnlineScannerDetails onlineScannerDetails = new OnlineScannerDetails(AppScanTreeSummary.this.m_ctx);
                        FileProcessor fileProcessor = new FileProcessor(onlineScannerDetails);
                        ReportEngine reportEngine = ReportEngineFactory.getEngine(onlineScannerDetails);
                        fileProcessor.addListener(reportEngine);
                        fileProcessor.process();
                        fileProcessor.removeListener(reportEngine);
                    }
                    catch (Exception exception) {
                        AppScanTreeSummary.log(exception);
                    }
                    return null;
                }
            };
            final Element element = (Element)this.m_ctx.get("nodeToRefresh");
            if (element != null) {
                databaseQueryTask.getDescriptor().addListener(new IRaptorTaskListener(){

                    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                        switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
                            case FINISHED: 
                            case FAILED: {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            ((MigrationProjectNavigatorManager)MigrationProjectNavigatorManager.getInstance()).refreshElement(element);
                                        }
                                        catch (Exception exception) {
                                            AppScanTreeSummary.log(exception);
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
                    }

                    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
                    }
                });
            }
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                if (jLabel.getText().equals(AppScanArb.get("APPSCAN_SUMMARY_TITLE"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else if (StringUtils.stripMnemonic((String)jLabel.getText()).equals(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_DATABASE_TYPE")))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"database.png"));
                } else if (jLabel.getText().equals(AppScanArb.get("APPSCAN_DETAILS"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"detail.gif"));
                } else if (jLabel.getText().equals(AppScanArb.get("APPSCAN_ACTIONS"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"action.png"));
                } else if (StringUtils.stripMnemonic((String)jLabel.getText()).equals(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_APP_DIR")))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"directorytreeview.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

