/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.report.ReportEngine;
import oracle.dbtools.raptor.migration.applications.report.Summary;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorAppEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdbc.internal.OraclePreparedStatement;

public class RepositoryEngine
extends ReportEngine {
    private static Logger LOGGER = Logger.getLogger(RepositoryEngine.class.getName());
    private Connection m_repo;
    private PreparedStatement artifactStatement;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public RepositoryEngine(ScannerDetails scannerDetails) {
        try {
            this.m_repo = this.getConnection(scannerDetails);
        }
        catch (DBException dBException) {
            RepositoryEngine.log(dBException);
        }
    }

    private Connection getConnection(ScannerDetails scannerDetails) throws DBException {
        if (scannerDetails.isRepositorySpecified() && scannerDetails.isDefaultRepo()) {
            return Connections.getInstance().getConnection(MigrationAddin.getDefaultMigrationRepository());
        }
        return null;
    }

    @Override
    public void generateReport(Summary summary) {
    }

    private int createApplication(FileProcessorEvent fileProcessorEvent, Connection connection) {
        int n = 0;
        FileProcessorAppEvent fileProcessorAppEvent = (FileProcessorAppEvent)fileProcessorEvent;
        if (fileProcessorAppEvent.getAppName() != null && !fileProcessorAppEvent.getAppName().toLowerCase().equals("finished")) {
            String string = "INSERT INTO MD_APPLICATIONS ( DESCRIPTION, BASE_DIR, OUTPUT_DIR, INPLACE, CONNECTION_ID_FK,NAME) VALUES  ( ?, ?, ?, ?, ?,?)";
            try {
                String[] stringArray = new String[]{"ID"};
                PreparedStatement preparedStatement = this.m_repo.prepareStatement(string, stringArray);
                preparedStatement.setString(1, fileProcessorAppEvent.getDescription());
                preparedStatement.setString(2, fileProcessorAppEvent.getBaseDir());
                preparedStatement.setString(3, fileProcessorAppEvent.getOutputDir());
                preparedStatement.setInt(4, fileProcessorAppEvent.isInPlace() ? 1 : 0);
                preparedStatement.setLong(5, fileProcessorAppEvent.getCaptureId());
                preparedStatement.setString(6, fileProcessorAppEvent.getAppName());
                preparedStatement.executeUpdate();
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                RepositoryEngine.log(sQLException);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createFile(FileProcessorEvent fileProcessorEvent, Connection connection, int n) {
        Statement statement = null;
        FileProcessorFileEvent fileProcessorFileEvent = (FileProcessorFileEvent)fileProcessorEvent;
        try {
            String string = "insert into md_applicationfiles (APPLICATIONS_ID_FK, NAME, URI, TYPE, STATE, LANGUAGE) values (?,?,?,?,?,?) ";
            String[] stringArray = new String[]{"ID"};
            statement = this.m_repo.prepareStatement(string, stringArray);
            statement.setInt(1, n);
            statement.setString(2, fileProcessorFileEvent.getFileName());
            statement.setString(3, fileProcessorFileEvent.getURI());
            statement.setString(4, fileProcessorFileEvent.getFileType());
            String string2 = fileProcessorFileEvent.getFileType();
            String string3 = fileProcessorFileEvent.getState();
            String string4 = fileProcessorFileEvent.getLanguageType();
            if (string2.toLowerCase().equals("binary")) {
                string3 = "IGNORED";
                string4 = "NONE";
            }
            statement.setString(5, string3);
            statement.setString(6, string4);
            statement.executeUpdate();
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                return n2;
            }
        }
        catch (SQLException sQLException) {
            RepositoryEngine.log(sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    RepositoryEngine.log(sQLException);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishFile(FileProcessorFileEvent fileProcessorFileEvent, int n) {
        PreparedStatement preparedStatement = null;
        FileProcessorFileEvent fileProcessorFileEvent2 = fileProcessorFileEvent;
        try {
            String string = "update md_applicationfiles set  STATE=?, LOC=? where ID=? ";
            preparedStatement = this.m_repo.prepareStatement(string);
            preparedStatement.setString(1, fileProcessorFileEvent2.getFileState());
            preparedStatement.setInt(2, fileProcessorFileEvent2.getLineCount());
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            RepositoryEngine.log(sQLException);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    RepositoryEngine.log(sQLException);
                }
            }
        }
    }

    @Override
    protected int createApplication(FileProcessorAppEvent fileProcessorAppEvent) {
        return this.createApplication(fileProcessorAppEvent, this.m_repo);
    }

    @Override
    protected void createArtifact(FileProcessorArtifactEvent fileProcessorArtifactEvent, int n) {
    }

    @Override
    protected int createFile(FileProcessorFileEvent fileProcessorFileEvent, int n) {
        return this.createFile(fileProcessorFileEvent, this.m_repo, n);
    }

    @Override
    public void raiseEvent(ArrayList<FileProcessorArtifactEvent> arrayList) {
        try {
            String string = "INSERT INTO MD_FILE_ARTIFACTS  (APPLICATIONFILES_ID, PATTERN, STRING_FOUND, STRING_REPLACED, TYPE, STATUS,LINE, PATTERN_START, PATTERN_END, DB_TYPE, CODE_TYPE,DESCRIPTION ) values (:A,:B,:C,:D,:E,:F,:G,:H,:I, :J, :K, :L)";
            this.artifactStatement = this.m_repo.prepareStatement(string);
            int n = 0;
            for (FileProcessorArtifactEvent fileProcessorArtifactEvent : arrayList) {
                ((OraclePreparedStatement)this.artifactStatement).setIntAtName("A", this.m_fileId);
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("B", fileProcessorArtifactEvent.getRegex());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("C", fileProcessorArtifactEvent.getStringFound());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("D", fileProcessorArtifactEvent.getReplacement());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("E", fileProcessorArtifactEvent.getType());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("F", fileProcessorArtifactEvent.getStatus());
                ((OraclePreparedStatement)this.artifactStatement).setIntAtName("G", fileProcessorArtifactEvent.getLineNo());
                ((OraclePreparedStatement)this.artifactStatement).setIntAtName("H", fileProcessorArtifactEvent.getStart());
                ((OraclePreparedStatement)this.artifactStatement).setIntAtName("I", fileProcessorArtifactEvent.getFinish());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("J", fileProcessorArtifactEvent.getDbType());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("K", fileProcessorArtifactEvent.getRegexName());
                ((OraclePreparedStatement)this.artifactStatement).setStringAtName("L", fileProcessorArtifactEvent.getRegexDescription());
                this.artifactStatement.addBatch();
                if (++n < 200) continue;
                this.artifactStatement.executeBatch();
                n = 0;
            }
            if (n > 0) {
                this.artifactStatement.executeBatch();
            }
            this.artifactStatement.close();
        }
        catch (SQLException sQLException) {
            RepositoryEngine.log(sQLException);
        }
    }

    @Override
    protected void finishApplication(FileProcessorAppEvent fileProcessorAppEvent) {
        try {
            this.m_repo.commit();
        }
        catch (SQLException sQLException) {
            RepositoryEngine.log(sQLException);
        }
    }
}

