/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.engine;

import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.raptor.migration.applications.engine.ApplicationEngine;
import oracle.dbtools.raptor.migration.applications.engine.EngineCogState;
import oracle.dbtools.raptor.migration.applications.engine.EngineCogStateVector;
import oracle.dbtools.raptor.migration.applications.engine.WorkPackageDescriptor;

public class EngineCog
implements Runnable,
Cancelable {
    public static final String STATE_INITIALISING = "Initialising";
    public static final String STATE_WORKING = "Working";
    public static final String STATE_FINISHED = "Finished";
    public static final boolean KEEP_ALIVE = true;
    private volatile boolean m_cancelled = false;
    private volatile EngineCogStateVector m_stateVector;
    private ApplicationEngine m_engine;
    private boolean m_keepAlive = false;

    public EngineCog(String string, ApplicationEngine applicationEngine, boolean bl) {
        this(string, applicationEngine);
        this.m_keepAlive = true;
    }

    public EngineCog(String string, ApplicationEngine applicationEngine) {
        this.m_stateVector = new EngineCogStateVector(string);
        this.m_engine = applicationEngine;
    }

    @Override
    public void run() {
        System.out.println(this.getId());
        this.m_stateVector.setProcessState(STATE_FINISHED);
        WorkPackageDescriptor workPackageDescriptor = this.m_engine.getWorkPackage();
        while (this.m_keepAlive || workPackageDescriptor != null) {
            if (workPackageDescriptor != null) {
                workPackageDescriptor.run();
            }
            if (this.isCanceled()) break;
            workPackageDescriptor = this.m_engine.getWorkPackage();
        }
    }

    public void signalCancel() {
        this.m_cancelled = true;
    }

    public boolean isCanceled() {
        return this.m_cancelled;
    }

    public String getId() {
        return this.m_stateVector.getId();
    }

    public EngineCogState getState() {
        return this.m_stateVector.takeSnapshot();
    }
}

