/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.cmdline;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmdHelp;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.migration.applications.cmdline.UsageHelp;

public class ScannerDetails {
    private static ScannerDetails INSTANCE = null;
    public static final String RULESDIR = "rulesdir";
    public static final String INPLACE = "inplace";
    public static final String IGNORE_LIST = "ignore";
    public static final String LOG_FILE = "log";
    public static final String BACKUP_DIR = "backup";
    public static final String OUTPUT_DIR = "output";
    private static final String DEFAULT = "true";
    public static final String FILES = "files";
    public static final String REPO = "repo";
    public static final String ANALYSIS = "analysis";
    public static final String DBTYPE = "type";
    public static final String INPUT_DIR = "dir";
    public static final String APPDESC = "appdesc";
    public static final String APPNAME = "appname";
    public static final String FILE = "FILE";
    public static final String DIR = "DIR";
    private static final String SYBASE = "SYBASE";
    private String error_message = "";
    private MigrationDetails m_details;
    private FilenameFilter m_filter;
    private String m_fileIgnoreExpression;
    private String _outDir;
    private URI _dirURI;
    private URI _outDirURI;

    public static ScannerDetails getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScannerDetails();
        }
        return INSTANCE;
    }

    public String getError_message() {
        return "Error:\n" + this.error_message;
    }

    private void setError_message(String string) {
        this.error_message = string;
    }

    public boolean isDirBased() {
        return this.m_details.get("dir_based") != null;
    }

    public void setOptions(MigrationDetails migrationDetails) {
        this.m_details = migrationDetails;
    }

    public boolean isTypeDefined() {
        if (this.m_details != null) {
            return this.m_details.contains(DBTYPE);
        }
        return false;
    }

    public String getType() {
        if (this.isTypeDefined()) {
            String string = this.m_details.get(DBTYPE).toLowerCase();
            return string;
        }
        return null;
    }

    public boolean isAnalysisRequired() {
        if (this.m_details != null) {
            return this.m_details.contains(ANALYSIS);
        }
        return false;
    }

    public boolean isRepositorySpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(REPO);
        }
        return false;
    }

    public String getRepositorySpecified() {
        if (this.m_details != null) {
            return this.getNameAndPassword(this.m_details.get(REPO))[0];
        }
        return null;
    }

    public boolean isRepositoryPasswordSpecified() {
        if (this.m_details != null) {
            return this.isPasswordSpecified(this.m_details.get(REPO));
        }
        return false;
    }

    private boolean isPasswordSpecified(String string) {
        return string.indexOf("/") != -1;
    }

    public String[] getfileList() {
        String string;
        if (this.m_details != null && (string = this.m_details.get(FILES)) != null) {
            return string.split(",");
        }
        return null;
    }

    private String[] getNameAndPassword(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return new String[]{string, null};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    public String getRepositoryPassword() {
        if (this.m_details != null) {
            return this.getNameAndPassword(this.m_details.get(REPO))[1];
        }
        return null;
    }

    public boolean isDefaultRepo() {
        return this.isRepositorySpecified() && this.m_details.get(REPO) != null && this.m_details.get(REPO).toLowerCase().equals(DEFAULT);
    }

    public boolean isOutputSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(OUTPUT_DIR);
        }
        return false;
    }

    public boolean isBackupSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(BACKUP_DIR);
        }
        return false;
    }

    public boolean isLogSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(LOG_FILE);
        }
        return false;
    }

    public String getLog() {
        if (this.m_details != null) {
            return this.m_details.get(LOG_FILE);
        }
        return null;
    }

    public MigrationDetails getMigrationDetails() {
        this.resetCachedData();
        return this.m_details;
    }

    private void resetCachedData() {
        this._outDir = null;
        this._dirURI = null;
        this._outDirURI = null;
    }

    public String getDir() {
        if (this.m_details != null) {
            return this.m_details.get(INPUT_DIR);
        }
        return null;
    }

    public boolean isDirSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(INPUT_DIR);
        }
        return false;
    }

    public URI getDirURI() {
        if (this.getDir() != null) {
            if (null == this._dirURI) {
                this._dirURI = new File(this.getDir()).toURI();
            }
            return this._dirURI;
        }
        return null;
    }

    public String getDirURIPath() {
        URI uRI = this.getDirURI();
        return uRI == null ? null : uRI.getRawPath();
    }

    public boolean isFileSpecified() {
        return this.m_details.contains(FILES);
    }

    public boolean isValid() {
        String string;
        if (!this.isTypeDefined()) {
            this.m_details.put(DBTYPE, SYBASE);
        }
        if (this.isRepositorySpecified() && !this.isDefaultRepo()) {
            this.setError_message("Repository option not specified correctly. Use -repo=true");
            return false;
        }
        if (this.isLogSpecified() && this.getLog() == null) {
            this.setError_message("Log option has been specified without the log file");
            return false;
        }
        if (!this.isDirSpecified() && !this.isFileSpecified()) {
            this.setError_message(AppScanArb.getString("CL_APPSCAN_DIR_OR_FILE"));
            return false;
        }
        if (this.isRepositorySpecified() && this.m_details.getCapturedModelCount() == 0) {
            this.setError_message(AppScanArb.getString("CL_APPSCAN_NO_CAP_MODEL"));
            return false;
        }
        if (this.isRepositorySpecified() && !this.isCaptureDefined()) {
            this.setError_message("Specify a captured model ID, when using a repository");
            return false;
        }
        if (this.isInPlace() && this.isOutputSpecified()) {
            this.setError_message("Specify a captured model ID, when using a repository");
            return false;
        }
        if (this.isRulesDirSpecified() && ((string = this.m_details.get(RULESDIR)) == null || string.equals(""))) {
            this.setError_message("Rules directory needs to be a valid directory");
            return false;
        }
        this.setSourceMode();
        this.setDefaults();
        return true;
    }

    public boolean isRulesDirSpecified() {
        return this.m_details.contains(RULESDIR);
    }

    private void setSourceMode() {
        if (this.isDirSpecified()) {
            this.m_details.put("dir_based", DEFAULT);
        }
    }

    public void usage(String string) {
        System.err.println(string);
        MigrationCmdHelp.usage((String)"scan", (CMDOut)this.getMigrationDetails().getOut());
    }

    public void help() {
        UsageHelp.help();
    }

    public boolean isBackupDirSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(BACKUP_DIR);
        }
        return false;
    }

    public boolean isVerboseSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains("verbose");
        }
        return false;
    }

    public String getBackupDir() {
        if (this.m_details != null) {
            String string = this.m_details.get(BACKUP_DIR);
            return string;
        }
        return null;
    }

    public String getOutputDir() {
        if (this.m_details != null) {
            String string;
            if (null == this._outDir && (string = this.m_details.get(OUTPUT_DIR)) != null) {
                int n;
                if (string.endsWith(File.separator)) {
                    string = string.substring(0, string.length() - 1);
                }
                String string2 = this.getDir();
                assert (string2 != null);
                if (string2.endsWith(File.separator)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if ((n = string2.lastIndexOf(File.separatorChar)) > -1) {
                    string2 = string2.substring(n);
                }
                this._outDir = string + string2 + File.separator;
            }
            return this._outDir;
        }
        return null;
    }

    public URI getOutputDirURI() {
        if (this.getOutputDir() != null) {
            if (null == this._outDirURI) {
                File file = new File(this.getOutputDir());
                if (!file.exists()) {
                    file.mkdirs();
                }
                this._outDirURI = file.toURI();
            }
            return this._outDirURI;
        }
        return null;
    }

    public String getOutputDirURIPath() {
        URI uRI = this.getOutputDirURI();
        return uRI == null ? null : uRI.getRawPath();
    }

    public boolean isHelpSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains("help");
        }
        return false;
    }

    public boolean isIgnoreSpecified() {
        if (this.m_details != null) {
            return this.m_details.contains(IGNORE_LIST);
        }
        return false;
    }

    public String[] getIgnoreList() {
        String string;
        if (this.m_details != null && (string = this.m_details.get(IGNORE_LIST)) != null) {
            return string.split(",");
        }
        return null;
    }

    public FilenameFilter getIgnoreFilter() {
        if (this.m_filter != null) {
            return this.m_filter;
        }
        if (this.isIgnoreSpecified() && this.getIgnoreList().length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getIgnoreList().length; ++i) {
                stringBuffer.append(this.getIgnoreList()[i] + (i + 1 < this.getIgnoreList().length ? "|" : ""));
            }
            this.m_fileIgnoreExpression = stringBuffer.toString();
            this.m_filter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return !string.matches(ScannerDetails.this.m_fileIgnoreExpression.toString());
                }
            };
            return this.m_filter;
        }
        return null;
    }

    public String getIgnoreExpression() {
        if (this.isIgnoreSpecified() && this.getIgnoreList().length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getIgnoreList().length; ++i) {
                stringBuffer.append(this.getIgnoreList()[i] + (i + 1 < this.getIgnoreList().length ? "|" : ""));
            }
            this.m_fileIgnoreExpression = stringBuffer.toString();
        }
        return this.m_fileIgnoreExpression;
    }

    public Long getCapture() {
        if (this.isCaptureDefined()) {
            return this.getCaptureId();
        }
        return new Long(0L);
    }

    private Long getCaptureId() {
        if (this.m_details != null) {
            if (this.m_details.get("modelid") != null && !this.m_details.get("modelid").equals("")) {
                if (this.m_details.get("modelid").trim().equalsIgnoreCase("latest")) {
                    return this.m_details.getLastCapturedModelId();
                }
                return Long.parseLong(this.m_details.get("modelid"));
            }
            if (this.m_details.get("capturedmodel") != null) {
                return Long.parseLong(this.m_details.get("capturedmodel"));
            }
            return this.m_details.getLastCapturedModelId();
        }
        return null;
    }

    private boolean isCaptureDefined() {
        if (this.m_details != null) {
            return this.m_details.contains("modelid") || this.m_details.getLastCapturedModelId() != null;
        }
        return false;
    }

    public String getApplicationName() {
        if (this.m_details != null) {
            if (this.m_details.contains(APPNAME)) {
                return this.m_details.get(APPNAME);
            }
            return AppScanArb.getString("APPSCAN_DEFAULT_APPNAME");
        }
        return AppScanArb.getString("APPSCAN_DEFAULT_APPNAME");
    }

    public String getApplicationDescription() {
        if (this.m_details != null) {
            if (this.m_details.contains(APPDESC)) {
                return this.m_details.get(APPDESC);
            }
            return AppScanArb.getString("APPSCAN_DEFAULT_APPDESC");
        }
        return AppScanArb.getString("APPSCAN_DEFAULT_APPDESC");
    }

    public void setDefaults() {
        if (this.m_details != null) {
            if (!this.isTypeDefined()) {
                this.m_details.put(DBTYPE, "sybase");
            }
            if (!this.isAnalysisRequired()) {
                this.m_details.put(ANALYSIS, DEFAULT);
            }
        }
    }

    public boolean isInPlace() {
        return this.m_details != null && this.m_details.contains(INPLACE) && this.m_details.get(INPLACE) != null && this.m_details.get(INPLACE).toLowerCase().equals(DEFAULT);
    }

    public String getRulesDir() {
        if (this.m_details != null && this.m_details.contains(RULESDIR)) {
            return this.m_details.get(RULESDIR);
        }
        return null;
    }

    public void addRulesDir(String string) {
        if (this.m_details != null) {
            this.m_details.put(RULESDIR, string);
        }
    }

    public void setInplace(String string) {
        this.m_details.put(INPLACE, string);
    }
}

