/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import oracle.dbtools.raptor.migration.applications.client.CommandRunner;
import oracle.dbtools.raptor.migration.applications.engine.WorkPackageDescriptor;

public class ApplicationClient {
    private int m_port;
    private Socket socket;

    public ApplicationClient(int n) {
        this.m_port = n;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.socket = new Socket(inetAddress.getHostName(), this.m_port);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void stopEngine() {
        CommandRunner commandRunner = new CommandRunner("", "");
        commandRunner.lastJob = true;
    }

    public void submitJob(String string, String string2) {
        CommandRunner commandRunner = new CommandRunner(string, string2);
        this.submitJob(commandRunner);
    }

    private void submitJob(WorkPackageDescriptor workPackageDescriptor) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
            objectOutputStream.writeObject(workPackageDescriptor);
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            String string = (String)objectInputStream.readObject();
            System.out.println("Message: " + string);
            objectInputStream.close();
            objectOutputStream.close();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ApplicationClient applicationClient = new ApplicationClient(7777);
        applicationClient.submitJob("OS Job", "ls -al");
        applicationClient.stopEngine();
    }
}

