/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.filenav.DirectoryDeleteHandler;
import oracle.dbtools.raptor.filenav.DirectoryFilter;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.DirectoryRoot;
import oracle.dbtools.raptor.filenav.FileNavigatorWindow;
import oracle.dbtools.raptor.filenav.FilesRootFilter;
import oracle.dbtools.raptor.filenav.FilesRootFolder;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.dbtools.raptor.filenav.ProjectRootFilter;
import oracle.dbtools.raptor.filenav.PseudoRoot;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.DeleteHandlerService;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorManager;

public class FileNavigatorManager
extends DefaultNavigatorManager {
    private static final String FILE_ROOT = "Files";
    static final String DEFAULT_PROJECT_NAME = "Files.jpr";
    static final String WORKSPACE_FILENAME = "Files.jws";
    private static final String FILE_NAVIGATOR_WINDOW_ID = "FileNavigatorWindow";
    private static final String FILE_NAV_CMD = "FileNavigator.SHOW_NAVIGATOR";
    private static final int FILE_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"FileNavigator.SHOW_NAVIGATOR");
    private static FileNavigatorManager s_instance;

    public static FileNavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new FileNavigatorManager();
        }
        return s_instance;
    }

    private FileNavigatorManager() {
        this.registerFilter(NavRoot.class, ProjectRootFilter.class, null);
        this.registerFilter(FilesRootFolder.class, FilesRootFilter.class, null);
        this.registerFilter(DirectoryRoot.class, DirectoryFilter.class, null);
        this.registerFilter(DirectoryFolder.class, DirectoryFilter.class, null);
        this.registerFilter(PseudoRoot.class, DirectoryFilter.class, null);
    }

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
        DeleteHandlerService.registerDeleteActionHandler(DirectoryFolder.class, DirectoryDeleteHandler.class);
    }

    protected IdeAction createShowNavigatorAction() {
        IdeAction ideAction = IdeAction.get((int)FILE_NAV_CMD_ID);
        return ideAction;
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow(NavRoot.getInstance(), false, 0);
    }

    protected String getDefaultName() {
        return FILE_ROOT;
    }

    protected String getViewCategory() {
        return FILE_NAVIGATOR_WINDOW_ID;
    }

    static boolean isFileNavigatorContext(Context context) {
        return context.getView() instanceof FileNavigatorWindow;
    }

    protected IdeAction createToggleToolbarAction() {
        return null;
    }

    protected DockingParam createNavigatorDockingParam() {
        NavigatorWindow navigatorWindow;
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        if (navigatorManager != null && (navigatorWindow = navigatorManager.getNavigatorWindow()) != null) {
            dockingParam.setTabbedWith((Dockable)navigatorWindow);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new FileNavigatorWindow(context, viewId.getId(), FILE_ROOT);
    }
}

