/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugProbeVariableInfo
implements DebugVariableInfo {
    DebugProbe dp;
    DebugProbeStackFrameInfo sf;
    String name;
    DebugProbeValue dpv;
    boolean argument;
    boolean local;
    DebugProbeClassInfo classInfo;
    int stoppedCount;
    DebugProbeDataInfo dataInfo;

    DebugProbeVariableInfo(DebugProbe dp, DebugProbeStackFrameInfo sf, String name, DebugProbeValue dpv, boolean argument, boolean local) {
        this.dp = dp;
        this.sf = sf;
        this.name = name;
        this.dpv = dpv;
        this.argument = argument;
        this.local = local;
        this.classInfo = dp.getClassInfoForDataType(dpv);
        this.stoppedCount = dp.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dp.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Variable has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getGenericSignature() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInScope() {
        return true;
    }

    public boolean isArgument() {
        return this.argument;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isReturn() {
        return false;
    }

    public boolean isReturned() {
        return false;
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.dataInfo == null) {
            this.dataInfo = this.dpv.isArray() ? new DebugProbeDataArrayInfo(this.dp, this.classInfo, this.dpv, this) : new DebugProbeDataInfo(this.dp, this.classInfo, this.dpv, this);
        }
        return this.dataInfo;
    }

    public int getSlotSize() {
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeVariableInfo) {
            DebugProbeVariableInfo other = (DebugProbeVariableInfo)o;
            return ModelUtil.areEqual((Object)this.dp, (Object)other.dp) && ModelUtil.areEqual((Object)this.name, (Object)other.name);
        }
        return false;
    }
}

