/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.plsql.old.PlsqlUtilities;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.TypeSymbol;
import oracle.javatools.parser.plsql.old.symbol.VariableSymbol;

abstract class DebugProbeVariableContainer {
    private Map typesMap = new HashMap();

    protected DebugProbeVariableContainer() {
    }

    protected void processVariables(VariableSymbol[] variables, List listOfVariableNames, List list) {
        if (variables != null) {
            for (VariableSymbol variable : variables) {
                NameSymbol nameSymbol = variable.getName();
                if (nameSymbol == null) continue;
                String name = nameSymbol.getValue();
                TypeSymbol typeSymbol = variable.getType();
                String type = typeSymbol != null ? typeSymbol.getValue() : null;
                this.processVariable(name, type, listOfVariableNames, list);
            }
        }
    }

    protected void processVariable(String name, String type, List listOfVariableNames, List list) {
        Object var;
        if (name != null && name.length() > 0 && !listOfVariableNames.contains(name) && (var = this.getVariable(name, type)) != null) {
            listOfVariableNames.add(name);
            list.add(var);
        }
    }

    protected abstract Object getVariable(String var1, String var2);

    abstract void clearCachedData();

    protected void processTypes(VariableSymbol[] types) {
        if (types != null) {
            for (VariableSymbol typeVar : types) {
                String type;
                TypeSymbol typeSymbol;
                String name;
                NameSymbol nameSymbol = typeVar.getName();
                if (nameSymbol == null || (name = nameSymbol.getValue()) == null || name.length() <= 0 || this.typesMap.containsKey(name) || (typeSymbol = typeVar.getType()) == null || (type = typeSymbol.getValue()) == null || type.length() <= 0) continue;
                type = PlsqlUtilities.blankOutComments((String)type);
                this.typesMap.put(name, type);
            }
        }
    }

    String getTypeDefinition(String type) {
        if (this.typesMap != null) {
            return (String)this.typesMap.get(type);
        }
        return null;
    }
}

