/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.Database;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;

final class DebugProbeBackTrace {
    DebugProbe dp;
    int stackDepth;
    DebugProbeStackFrameInfo[] stackFrames;

    DebugProbeBackTrace(DebugProbe dp) {
        this.dp = dp;
    }

    void clear() {
        if (this.stackFrames != null) {
            for (int i = 0; i < this.stackDepth; ++i) {
                this.stackFrames[i].clear();
            }
        }
        this.stackDepth = 0;
        this.stackFrames = null;
    }

    static String code(int stackDepth, String varName) {
        StringBuffer sb = new StringBuffer();
        for (int f = 1; f <= stackDepth; ++f) {
            sb.append(DebugProbeStackFrameInfo.code(varName + "(" + f + ")"));
        }
        return sb.toString();
    }

    static int registerParameters(int stackDepth, CallableStatement cs, int index) throws Exception {
        for (int i = stackDepth - 1; i >= 0; --i) {
            index = DebugProbeStackFrameInfo.registerParameters(cs, index);
        }
        return index;
    }

    int getParameters(int stackDepth, CallableStatement cs, int index) throws Exception {
        int i;
        ArrayList<DebugProbeStackFrameInfo> temp = new ArrayList<DebugProbeStackFrameInfo>();
        int f = 1;
        for (i = stackDepth - 1; i >= 0; --i) {
            DebugProbeStackFrameInfo stackFrame = new DebugProbeStackFrameInfo(this.dp, i, f);
            index = stackFrame.getParameters(cs, index);
            if (!stackFrame.location.isAnonymousBlock()) {
                temp.add(0, stackFrame);
            }
            ++f;
        }
        this.stackDepth = stackDepth = temp.size();
        this.stackFrames = new DebugProbeStackFrameInfo[stackDepth];
        for (i = 0; i < stackDepth; ++i) {
            this.stackFrames[i] = (DebugProbeStackFrameInfo)temp.get(i);
            this.stackFrames[i].frameNumber = i;
        }
        return index;
    }

    String dump(String margin, String backTraceName) {
        StringBuffer sb = new StringBuffer();
        sb.append(margin);
        sb.append(backTraceName);
        sb.append("\n");
        for (int i = 0; i < this.stackDepth; ++i) {
            sb.append(this.stackFrames[i].dump(margin + "  ", "stackFrames[" + i + "]"));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fill(Database db, int stackDepth) {
        if (this.stackFrames == null && this.dp.checkVersion(2, 1) && stackDepth > 0) {
            try {
                Connection c = db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("DECLARE\n");
                sb.append("  backtrace   DBMS_DEBUG.backtrace_table;\n");
                sb.append("begin\n");
                sb.append("  DBMS_DEBUG.print_backtrace(backtrace);\n");
                sb.append(DebugProbeBackTrace.code(stackDepth, "backtrace"));
                sb.append("end; ");
                String s = sb.toString();
                CallableStatement cs = c.prepareCall(s);
                try {
                    DebugProbeBackTrace.registerParameters(stackDepth, cs, 1);
                    cs.execute();
                    this.getParameters(stackDepth, cs, 1);
                }
                finally {
                    cs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    DebugProbeStackFrameInfo[] listStack() {
        return this.stackFrames;
    }

    int getStackFrameCount() {
        return this.stackDepth;
    }

    DebugProbeStackFrameInfo getStackFrame(int frame) {
        if (frame < this.stackDepth) {
            return this.stackFrames[frame];
        }
        return null;
    }
}

