/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.resource.GalleryArb;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.controls.WashedIcon;
import oracle.javatools.util.ModelUtil;

public final class GalleryElement
implements Comparable,
Element {
    private static final Collator COLLATOR = Collator.getInstance();
    static final Comparator<GalleryElement> LABEL_ONLY_COMPARATOR = new LabelOnlyComparator();
    private String _name;
    private String[] _wizardParams;
    private String _iconFile;
    private ClassLoader _classLoader;
    private String _wizClass;
    private boolean _unsorted;
    private String _description;
    private String _resClass;
    private String[] _technologyKeys;
    private transient Wizard _wizard;
    private transient TechId[] _techIds;
    private transient Icon _icon;
    private transient Icon _disabledIcon;
    private static final boolean _debug = Boolean.getBoolean("ObjectGallery.debug");

    public GalleryElement() {
        this(null);
    }

    public GalleryElement(Wizard wizard) {
        this._wizard = wizard;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    public void setWizardClassLoader(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        this._classLoader = loader;
    }

    public void setWizardClass(String clazz) {
        this._wizClass = clazz;
    }

    public ClassLoader getWizardClassLoader() {
        return this._classLoader;
    }

    public String getWizardClass() {
        return this._wizClass;
    }

    public Wizard getWizard() {
        String wizardClass;
        if (this._wizard == null && null != (wizardClass = this.getWizardClass())) {
            this._wizard = WizardManager.getInstance().getWizard(this.getWizardClassLoader(), wizardClass);
        }
        return this._wizard;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String[] getWizardParameters() {
        return this._wizardParams;
    }

    public void setWizardParameters(String[] wizardParams) {
        this._wizardParams = wizardParams;
    }

    public void setIconFile(String iconFile) {
        this._iconFile = iconFile;
    }

    public String getIconFile() {
        return this._iconFile;
    }

    public String[] getTechnologyKeys() {
        return this._technologyKeys;
    }

    public void setTechnologyKeys(String[] technologyKeys) {
        this._technologyKeys = technologyKeys;
    }

    public String getResClass() {
        return this._resClass;
    }

    public void setResClass(String resClass) {
        this._resClass = resClass;
    }

    public Object getData() {
        return this;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public String getShortLabel() {
        String wizName = this.getWizardName();
        Wizard wizard = this.getWizard();
        String ret = "";
        try {
            if (wizard != null) {
                ret = wizard.getShortLabel();
                if (!(ModelUtil.hasLength((String)ret) || ModelUtil.hasLength((String)(ret = wizard.getLongLabel())) || ModelUtil.hasLength((String)(ret = wizard.getToolTipText())))) {
                    ret = wizName;
                }
            } else {
                ret = wizName;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String getLongLabel() {
        String ret = this._description;
        try {
            if (!ModelUtil.hasLength((String)ret)) {
                String wizName = this.getWizardName();
                Wizard wizard = this.getWizard();
                if (wizard != null) {
                    ret = wizard.getLongLabel();
                    if (!(ModelUtil.hasLength((String)ret) || ModelUtil.hasLength((String)(ret = wizard.getToolTipText())) || ModelUtil.hasLength((String)(ret = wizard.getShortLabel())))) {
                        ret = wizName;
                    }
                } else {
                    ret = GalleryArb.format((int)21, (Object)wizName, (Object)this.getWizardClass());
                }
            } else if (this._resClass != null) {
                return this.getString(ret);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String getToolTipText() {
        String ret = "";
        try {
            String wizName = this.getWizardName();
            Wizard wizard = this.getWizard();
            if (wizard != null) {
                ret = wizard.getToolTipText();
                if (!(ModelUtil.hasLength((String)ret) || ModelUtil.hasLength((String)(ret = wizard.getLongLabel())) || ModelUtil.hasLength((String)(ret = wizard.getShortLabel())))) {
                    ret = wizName;
                }
            } else {
                ret = wizName;
            }
            if (_debug) {
                ret = ret + " (" + this.getWizardClass() + ")";
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            Wizard wizard;
            ImageIcon icon;
            URL url;
            if (this._iconFile != null && (url = ClassLoader.getSystemResource(this._iconFile)) != null && ((icon = new ImageIcon(url)).getImageLoadStatus() & 8) != 0) {
                this._icon = icon;
            }
            if (this._icon == null && (wizard = this.getWizard()) != null) {
                try {
                    this._icon = wizard.getIcon();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this._icon;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GalleryElement)) {
            return false;
        }
        GalleryElement other = (GalleryElement)object;
        if (!(this.getShortLabel() != null ? this.getShortLabel().equals(other.getShortLabel()) : other.getShortLabel() == null)) {
            return false;
        }
        if (!(this._description != null ? this._description.equals(other._description) : other._description == null)) {
            return false;
        }
        return Arrays.equals(this._technologyKeys, other._technologyKeys);
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.getShortLabel() == null ? 0 : this.getShortLabel().hashCode());
        result = 37 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 37 * result + Arrays.hashCode(this._technologyKeys);
        return result;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public int compareTo(Object o) {
        if (o instanceof GalleryFolder) {
            return 1;
        }
        if (o instanceof GalleryElement) {
            GalleryElement e = (GalleryElement)o;
            if (this.getUnsorted() != e.getUnsorted()) {
                return this.getUnsorted() ? -1 : 1;
            }
            if (this.getUnsorted() && e.getUnsorted()) {
                return 0;
            }
            return COLLATOR.compare(this.getShortLabel(), e.getShortLabel());
        }
        return COLLATOR.compare(this.getShortLabel(), o.toString());
    }

    protected String getWizardDescription() {
        return this.getLongLabel();
    }

    protected String getWizardName() {
        Wizard w;
        if (this._name == null && (w = this.getWizard()) != null) {
            this._name = w.getShortLabel();
        }
        return this._name;
    }

    protected boolean isAvailable(Context context) {
        return ObjectGallery.isWizardAvailable(this.getWizard(), context);
    }

    protected Icon getDisabledIcon() {
        if (this._disabledIcon == null) {
            Icon icon = this.getIcon();
            this._disabledIcon = icon instanceof ImageIcon ? new WashedIcon(icon, 0.35f) : icon;
        }
        return this._disabledIcon;
    }

    boolean isInScope(TechnologyScope scope) {
        if (scope == null) {
            return false;
        }
        TechId[] techIds = this.getTechIds();
        if (techIds.length == 0) {
            return false;
        }
        for (int i = 0; i < techIds.length; ++i) {
            TechId techId = techIds[i];
            if (techId != null && techId.isInScope(scope)) continue;
            return false;
        }
        return true;
    }

    private TechId[] getTechIds() {
        if (this._techIds == null) {
            if (this._technologyKeys != null) {
                this._techIds = new TechId[this._technologyKeys.length];
                for (int i = 0; i < this._technologyKeys.length; ++i) {
                    this._techIds[i] = TechnologyRegistry.getInstance().getTechId(this._technologyKeys[i]);
                }
            } else {
                this._techIds = new TechId[0];
            }
        }
        return this._techIds;
    }

    private String getString(String index) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(this._resClass);
            return rb.getString(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static class LabelOnlyComparator
    implements Comparator<GalleryElement> {
        private LabelOnlyComparator() {
        }

        @Override
        public int compare(GalleryElement o1, GalleryElement o2) {
            int compare = COLLATOR.compare(o1.getShortLabel(), o2.getShortLabel());
            return compare;
        }
    }
}

