/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.Messages_Tuning;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.profiler.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class PLSQLEditorToolbar
implements EditorPlugin {
    public void install(BasicEditorPane basicEditorPane) {
        DBObject dBObject;
        String string;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Toolbar toolbar = codeEditor.getToolbar();
        if (!(!DBURLFormatHelper.isDBURL((URL)codeEditor.getContext().getNode().getURL()) || (string = (dBObject = new DBObject((Element)codeEditor.getContext().getNode())).getObjectType()) == null || "XML SCHEMA".equals(string) || "TRIGGER".equals(string) || "TYPE".equals(string) || "PACKAGE BODY".equals(string))) {
            this.addRunActions(codeEditor, toolbar, dBObject);
        }
        View.updateToolbarActions((Toolbar)toolbar);
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, DBObject dBObject) {
        URL uRL = codeEditor.getContext().getNode().getURL();
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        try {
            Database database = Connections.getInstance().getDatabase(string, true);
            Connection connection = database.getConnection();
            int n = connection.getMetaData().getDatabaseMajorVersion();
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            String string2 = properties.getProperty("driver");
            if ("oracle.jdbc.OracleDriver".equals(string2) && n > 10) {
                ToolButton toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, CommonArb.getIcon((String)"AUTOTRACE_ICON"), Messages_Tuning.getString("PLSQLEditorToolbar.1"), PLSQLController.getProfileAction(), true));
                toolbar.add((Component)toolButton, toolbar.getComponentCount() - 2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, IdeAction ideAction, boolean bl) {
        IdeAction ideAction2 = ideAction.newLocalAction(view);
        ideAction2.putValue("SmallIcon", (Object)icon);
        ideAction2.putValue("ShortDescription", (Object)string);
        ideAction2.setEnabled(bl);
        return ideAction2;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

