/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.GeneratePreparedStatement;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataFileParser
extends DefaultHandler {
    private XMLReader s_parser = null;
    private Locator _locator;
    public StringBuffer sbCurrValue = new StringBuffer();
    private List _fieldDataList = new ArrayList();
    private int _currentDbId;
    private String _currentDbIdAsStr = null;
    private String _currentTableName;
    private URL _currentFile;
    private int _currUnqIndexId = 1000;
    private GeneratePreparedStatement _genPrepStmt = null;
    private int _numRecordsInserted = 0;
    private boolean _bSS2K_SYSLOGINS_table = false;

    public MetadataFileParser(int n, URL uRL, String string) {
        this._currentDbId = n;
        this._currentDbIdAsStr = new String("" + this._currentDbId);
        this._currentFile = uRL;
        this._currentTableName = string;
        this._numRecordsInserted = 0;
        if (this._currentTableName.equalsIgnoreCase("SS2K_SYSLOGINS")) {
            this._bSS2K_SYSLOGINS_table = true;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("er")) {
            this._fieldDataList.clear();
            this._fieldDataList.add(this._currentDbIdAsStr);
        } else if (string2.equalsIgnoreCase("ec")) {
            this.sbCurrValue.setLength(0);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("er")) {
            if (this._fieldDataList.size() > 1) {
                this._executePreparedStatement();
            }
        } else if (string2.equalsIgnoreCase("ec")) {
            this._fieldDataList.add(this.sbCurrValue.toString());
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.sbCurrValue.append(cArray, n, n2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException.getMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException.getMessage());
    }

    public int loadData() throws OfflineCaptureException {
        try {
            this.s_parser = new SAXParser();
            this.s_parser.setContentHandler(this);
            this.s_parser.setEntityResolver(this);
            this.s_parser.setDTDHandler(this);
            this.s_parser.setErrorHandler(this);
            this.s_parser.parse(this._currentFile.toString());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw new OfflineCaptureException(exception);
        }
        finally {
            this.cleanUp();
        }
        return this._numRecordsInserted;
    }

    public void createPrepardStatement(Connection connection, String[] stringArray) throws SQLException {
        this._genPrepStmt = new GeneratePreparedStatement(connection, this._currentDbId, stringArray, this._currentTableName);
    }

    private void _executePreparedStatement() {
        try {
            if (this._bSS2K_SYSLOGINS_table) {
                this._fieldDataList.add("" + this._numRecordsInserted + 1);
            }
            this._genPrepStmt.setPreparedStatementValues(this._fieldDataList);
            this._genPrepStmt.executeUpdate();
            ++this._numRecordsInserted;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public void cleanUp() {
        this._genPrepStmt.cleanUp();
    }
}

