/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.extract.models.ExtractObject;

public class dbDeployAPI {
    ZipOutputStream out;
    DbCartDeployOptions _deployOptions;

    protected void openZip(String string) throws FileNotFoundException {
        this.out = new ZipOutputStream(new FileOutputStream(string));
    }

    protected void closeZip() throws IOException {
        this.out.close();
    }

    protected void writeFile(String string) throws IOException {
        int n;
        File file = new File(string);
        if (file.isDirectory()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(file.getPath());
        this.out.putNextEntry(zipEntry);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            this.out.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    protected void writeObject(ExtractObject extractObject) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(extractObject.getDDL(1));
        ZipEntry zipEntry = new ZipEntry(extractObject.getUrl().toString());
        this.out.putNextEntry(zipEntry);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            this.out.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    public void deployCart(DbCartDeployOptions dbCartDeployOptions) {
        try {
            this._deployOptions = dbCartDeployOptions;
            for (ExtractObject extractObject : this._deployOptions.getExtractObjectList()) {
                try {
                    this.writeObject(extractObject);
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
            this.closeZip();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
    }
}

