/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartController;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.panels.PredicatePanel;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.TableToolbar;

public class DBCartReorderableTableModel
extends ListReorderableTableModel<ExtractObject> {
    private static final long serialVersionUID = 1L;
    private static final int INCLUDE = 0;
    private static final int TYPE = 1;
    private static final int OWNER = 2;
    private static final int NAME = 3;
    private static final int DDL = 4;
    private static final int DATA = 5;
    private static final int WHERE = 6;
    private static final int CONNECTION = 7;
    private static final String[] COL_NAMES = new String[]{DbCartAddinArb.getString("INCLUDE"), DbCartAddinArb.getString("TYPE"), DbCartAddinArb.getString("OWNER"), DbCartAddinArb.getString("NAME"), DbCartAddinArb.getString("DDL"), DbCartAddinArb.getString("DATA"), DbCartAddinArb.getString("WHERE"), DbCartAddinArb.getString("CONNECTION")};
    private static final String[] COL_TIPS = new String[]{DbCartAddinArb.getString("INCLUDE_TIP"), DbCartAddinArb.getString("TYPE_TIP"), DbCartAddinArb.getString("OWNER_TIP"), DbCartAddinArb.getString("NAME_TIP"), DbCartAddinArb.getString("DDL_TIP"), DbCartAddinArb.getString("DATA_TIP"), DbCartAddinArb.getString("WHERE_TIP"), DbCartAddinArb.getString("CONNECTION_TIP")};
    public static final String SCRIPT_FILE_PATH = "DBCART_FILE_PATH";
    private ExtractListModel _extractListModel;
    private JEWTDialog _dialog;
    private String _fileString;
    private TableToolbar _toolbar;
    private GenericTable _table;
    private CheckBoxHeader _includeCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("INCLUDE"));
    private CheckBoxHeader _ddlCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("DDL"));
    private CheckBoxHeader _dataCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("DATA"));
    private IncludeCheckBoxRenderer _includeCheckBoxRenderer = new IncludeCheckBoxRenderer();
    private DdlCheckBoxRenderer _ddlCheckBoxRenderer = new DdlCheckBoxRenderer();
    private DataCheckBoxRenderer _dataCheckBoxRenderer = new DataCheckBoxRenderer();

    public DBCartReorderableTableModel(ExtractListModel extractListModel) {
        super(COL_NAMES, COL_TIPS);
        this._extractListModel = extractListModel;
        this.setRowList(this._extractListModel.getList(0));
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        this._table = (GenericTable)jTable;
        this.setEditable(true);
        jTable.setDefaultRenderer(URL.class, new URLCellRenderer());
        jTable.setDefaultEditor(String.class, new CustomCellEditor());
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setSelectionMode(2);
        jTable.setCellSelectionEnabled(false);
        jTable.setRowSelectionAllowed(true);
        if (jTable instanceof GenericTable) {
            GenericTable genericTable = (GenericTable)jTable;
            genericTable.setSelectAllEnabled(true);
        }
        jTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(6).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(5).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(7).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(0).setHeaderRenderer(this._includeCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._includeCheckBoxHeader);
        jTable.getColumnModel().getColumn(4).setHeaderRenderer(this._ddlCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._ddlCheckBoxHeader);
        jTable.getColumnModel().getColumn(5).setHeaderRenderer(this._dataCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._dataCheckBoxHeader);
        jTable.getColumnModel().getColumn(0).setCellRenderer(this._includeCheckBoxRenderer);
        jTable.getColumnModel().getColumn(4).setCellRenderer(this._ddlCheckBoxRenderer);
        jTable.getColumnModel().getColumn(5).setCellRenderer(this._dataCheckBoxRenderer);
    }

    protected Object getValueAt(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return new Boolean(extractObject.isPreSelected());
            }
            case 1: {
                return extractObject.getUrl();
            }
            case 2: {
                return extractObject.getUrl();
            }
            case 3: {
                return extractObject.getUrl();
            }
            case 4: {
                return new Boolean(extractObject.isExtractMetaData());
            }
            case 5: {
                return this._extractListModel.isDataObject(extractObject.getDBObject()) ? new Boolean(extractObject.isSelectedData()) : new Boolean(false);
            }
            case 6: {
                return this._extractListModel.isDataObject(extractObject.getDBObject()) ? extractObject.getWhere() : "";
            }
            case 7: {
                Connections.getInstance();
                return Connections.getDisplayName((String)Connections.getConnectionName((String)extractObject.getSourceConnName()));
            }
        }
        return null;
    }

    protected boolean isCellEditable(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return extractObject.isExtractMetaData() || extractObject.isExtractData();
            }
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return this._extractListModel.isDataObject(extractObject.getDBObject());
            }
            case 6: {
                return this._extractListModel.isDataObject(extractObject.getDBObject());
            }
        }
        return false;
    }

    protected void setValueAt(Object object, ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                extractObject.isPreSelected(((Boolean)object).booleanValue());
                this.handleButtons();
                this.handleIncludeCheckBoxHeader();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                extractObject.isSelectedMetaData(((Boolean)object).booleanValue());
                extractObject.isExtractMetaData(((Boolean)object).booleanValue());
                this.handleDDLCheckBoxHeader();
                break;
            }
            case 5: {
                if (!this._extractListModel.isDataObject(extractObject.getDBObject())) break;
                extractObject.isSelectedData(((Boolean)object).booleanValue());
                extractObject.isExtractData(((Boolean)object).booleanValue());
                extractObject.isDataObject(true);
                this.handleDataCheckBoxHeader();
                break;
            }
            case 6: {
                extractObject.setWhere((String)object);
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public int rowExists(URL uRL) {
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            URL uRL2 = ((ExtractObject)list.get(i)).getUrl();
            if (!uRL.equals(uRL2)) continue;
            return i;
        }
        return -1;
    }

    public ExtractObject getRow(URL uRL) {
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            URL uRL2 = ((ExtractObject)list.get(i)).getUrl();
            if (!uRL.equals(uRL2)) continue;
            return (ExtractObject)list.get(i);
        }
        return null;
    }

    public List<ExtractObject> addRow(DBObject dBObject, String string) {
        Object[] objectArray = new Object[1];
        ExtractObject extractObject = new ExtractObject(dBObject, this._extractListModel);
        extractObject.setSourceConnName(string);
        extractObject.isExistsSource(true);
        extractObject.isExtractMetaData(true);
        extractObject.isSelectedMetaData(true);
        extractObject.isPreSelected(true);
        if (!extractObject.isInList(this.getRowList())) {
            objectArray[0] = extractObject;
            super.addRow(objectArray);
            DbCartController.getInstance().setModelEnable(true);
            DbCartController.getInstance().toggleToolbar();
            this._toolbar.setDeleteEnabled(true);
            this.handleIncludeCheckBoxHeader();
            this.handleDDLCheckBoxHeader();
            this.handleDataCheckBoxHeader();
        }
        return this._extractListModel.getList(0);
    }

    public void removeRow(int n) {
        super.removeRow(n);
        if (this._rowList.isEmpty()) {
            DbCartController.getInstance().setModelEnable(false);
            DbCartController.getInstance().toggleToolbar();
        }
        this.handleButtons();
        this.handleIncludeCheckBoxHeader();
        this.handleDDLCheckBoxHeader();
        this.handleDataCheckBoxHeader();
    }

    public void removeAll() {
        super.removeAll();
        DbCartController.getInstance().setModelEnable(false);
        DbCartController.getInstance().toggleToolbar();
        this.handleButtons();
        this.handleIncludeCheckBoxHeader();
        this.handleDDLCheckBoxHeader();
        this.handleDataCheckBoxHeader();
    }

    public boolean isEmpty() {
        return this._rowList.isEmpty();
    }

    public ArrayList<ExtractObject> getIncludedRows() {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : this._rowList) {
            if (!extractObject.isPreSelected()) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public ArrayList<ExtractObject> getDBORows() {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public void setToolbar(TableToolbar tableToolbar) {
        this._toolbar = tableToolbar;
    }

    public void getFileWithDialog() {
        String string = DbCartAddinArb.getString("FILEDIALOGTITLE");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        DBConfig dBConfig = DBConfig.getInstance();
        String string2 = dBConfig.getString("EXPORTDIR");
        FilePathActionControl filePathActionControl = new FilePathActionControl(SCRIPT_FILE_PATH, DbCartAddinArb.getString("SCRIPT_FILE"), string2, 0);
        jPanel.add((Component)filePathActionControl.getUI(), "Center");
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)7);
        this._dialog.setOKButtonEnabled(true);
        boolean bl = WizardLauncher.runDialog((JDialog)this._dialog);
        if (bl) {
            ActionControl.Value value = filePathActionControl.getValue();
            this._fileString = value.get();
        } else {
            this._fileString = null;
        }
    }

    private void handleButtons() {
        for (ExtractObject extractObject : this._extractListModel.getList(this._rowList, new int[]{107})) {
            this._toolbar.setDeleteEnabled(true);
            if (!extractObject.isExtractMetaData() && !extractObject.isExtractData()) continue;
            DbCartController.getInstance().setModelEnable(true);
            DbCartController.getInstance().toggleToolbar();
            return;
        }
        DbCartController.getInstance().setModelEnable(false);
        DbCartController.getInstance().toggleToolbar();
    }

    private void handleIncludeCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.isPreSelected()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    public void handleDataCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (!this._extractListModel.isDataObject(extractObject.getDBObject())) continue;
            if (extractObject.isSelectedData()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    public void handleDDLCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.isExtractMetaData()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    class CheckBoxHeader
    extends TriStateCheckBox
    implements TableCellRenderer,
    MouseListener {
        protected CheckBoxHeader rendererComponent = this;
        protected int column;
        protected boolean mousePressed = false;
        String colName;

        public CheckBoxHeader(String string) {
            this.colName = string;
            this.setCanUserSetPartial(false);
            this.setDirection(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setBorderPainted(true);
            this.setBorder(jTableHeader.getBorder());
            this.setFont(jTableHeader.getFont());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setColumn(n2);
            this.rendererComponent.setText(this.colName);
            this.rendererComponent.setHorizontalAlignment(0);
            this.rendererComponent.setEnabled(true);
            return this.rendererComponent;
        }

        protected void setColumn(int n) {
            this.column = n;
        }

        public int getColumn() {
            return this.column;
        }

        protected void handleClickEvent(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                this.doClick();
                TriStateCheckBox.State state = this.getState();
                boolean bl = true;
                if (this.rendererComponent.getState().equals((Object)TriStateCheckBox.State.FALSE)) {
                    bl = false;
                }
                int n3 = DBCartReorderableTableModel.this._table.getRowCount();
                for (int i = 0; i < n3; ++i) {
                    DBCartReorderableTableModel.this._table.getModel().setValueAt(bl, i, n2);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleClickEvent(mouseEvent);
            ((JTableHeader)mouseEvent.getSource()).repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class DataCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DataCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            Component component = jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!DBCartReorderableTableModel.this._extractListModel.isDataObject(extractObject.getDBObject())) {
                component.setVisible(false);
                component = new JLabel();
            }
            DBCartReorderableTableModel.this.handleButtons();
            return component;
        }
    }

    class DdlCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DdlCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            JCheckBox jCheckBox = (JCheckBox)jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jCheckBox.setSelected(extractObject.isExtractMetaData());
            DBCartReorderableTableModel.this.handleButtons();
            return jCheckBox;
        }
    }

    class IncludeCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        IncludeCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            JCheckBox jCheckBox = (JCheckBox)jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jCheckBox.setSelected(extractObject.isPreSelected());
            jCheckBox.setEnabled(extractObject.isExtractMetaData() || extractObject.isExtractData());
            return jCheckBox;
        }
    }

    class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTable _table;
        ExtractObject _dataObject;
        Object _value;
        int _rowIndex;
        int _vColIndex;
        PredicatePanel _whereEditor;
        JButton _editButton;

        CustomCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this._table = jTable;
            this._value = object;
            this._rowIndex = n;
            this._vColIndex = n2;
            this._dataObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            this._editButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
            this._editButton.setMargin(new Insets(2, 2, 2, 2));
            this._editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomCellEditor.this.handleEdit();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public void requestFocus() {
                    CustomCellEditor.this._editButton.requestFocus();
                }
            };
            jPanel.setName("CustomCellEditor.Panel" + n2);
            JLabel jLabel = new JLabel((String)object);
            jPanel.add("Center", jLabel);
            jPanel.add("East", this._editButton);
            this._editButton.setName("CustomCellEditor.EditButton" + n2);
            return jPanel;
        }

        private void handleEdit() {
            if (this._vColIndex == 6) {
                this._whereEditor = new PredicatePanel(this._dataObject, (String)this._table.getModel().getValueAt(this._rowIndex, this._vColIndex), false);
                HelpSystem.getHelpSystem().registerTopic((JComponent)this._whereEditor, "f1_idedexporttabledata_html");
                this._whereEditor.setVerticalDisplay(false);
                if (WizardLauncher.runDialog((JDialog)this.getDialog((Component)this._whereEditor, ExtractResources.getString((String)"EO_TITLE_WHERE")))) {
                    this._dataObject.setTable((JTable)this._whereEditor.getTable());
                    this._value = this._whereEditor.toString();
                    this.stopCellEditing();
                } else {
                    this.cancelCellEditing();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CustomCellEditor.this._table.isVisible()) {
                            CustomCellEditor.this._table.requestFocusInWindow();
                        }
                    }
                });
            }
        }

        private JEWTDialog getDialog(Component component, String string) {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)5);
            jEWTDialog.setResizable(true);
            jEWTDialog.setOKButtonEnabled(true);
            return jEWTDialog;
        }

        @Override
        public Object getCellEditorValue() {
            return this._value == null ? "" : this._value;
        }
    }

    class URLCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        URLCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            String string = null == object ? null : object.toString();
            URL uRL = null;
            if (object != null && object instanceof URL) {
                uRL = (URL)object;
                jLabel = (ExtractObject)DBCartReorderableTableModel.this._rowList.get(n);
                if (jLabel.getType() == 0) {
                    if (n2 == 2) {
                        String string2 = DBURLFormatHelper.getConnectionName((URL)uRL);
                        String string3 = string2 == null ? null : Connections.getInstance().getConnectionInfo(string2).getProperty("user");
                        String string4 = DBURLFormatHelper.getSchema((URL)uRL);
                        string = string4 != null && string4.length() > 0 ? string4 : string3;
                    } else {
                        string = n2 == 1 ? DBURLFormatHelper.getBaseType((URL)uRL) : DBURLFormatHelper.getName((URL)uRL);
                    }
                } else {
                    string = n2 == 2 ? "" : (n2 == 1 ? DbCartAddinArb.getString("FILE_TYPE") : uRL.getFile());
                }
            }
            jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            return jLabel;
        }
    }
}

