/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.GeometryContext;
import oracle.dbtools.spatial.mapviewer.MapViewerGeometryResultSet;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.spatial.geometry.JGeometry;

public class ShowContextDialog
extends JDialog {
    JGeometry currentGeometry = null;
    String currentQuery = null;
    MapViewerGeometryResultSet mvrs = null;
    GeometryContext[] attrValues = null;
    private JToggleButton closeButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public ShowContextDialog(Frame frame, boolean bl, String string, JGeometry jGeometry) {
        super(frame, bl);
        this.currentQuery = string;
        this.currentGeometry = jGeometry;
        this.queryContextInformation();
        this.initComponents();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this);
    }

    private void queryContextInformation() {
        block5: {
            try {
                if (this.currentQuery != null) {
                    this.mvrs = MapViewerGeometryResultSet.getInstance();
                    this.mvrs.setQuery(this.currentQuery);
                    this.attrValues = this.mvrs.getGeometryContextObjects(this.currentGeometry);
                    if (this.attrValues == null) {
                        throw new Exception(SpatialArb.getString("SpatialError13510"));
                    }
                    for (int i = 0; i < this.attrValues.length; ++i) {
                        this.attrValues[i].print();
                    }
                    break block5;
                }
                throw new Exception(SpatialArb.getString("SpatialError13511"));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.closeButton = new JToggleButton();
        this.closeButton.setName("CloseButtonShowContextDialogMapViewer");
        this.setDefaultCloseOperation(2);
        this.setTitle(SpatialArb.getString("MapViewerGeometryContextDialogTitle"));
        this.setBounds(new Rectangle(0, 0, 500, 300));
        this.setModal(true);
        this.setResizable(false);
        this.jLabel1.setText(SpatialArb.getString("MapViewerGeometryContextDialogLabel"));
        Vector<String> vector = new Vector<String>();
        vector.add(SpatialArb.getString("MapViewerGeometryContextColumn"));
        vector.add(SpatialArb.getString("MapViewerGeometryContextValue"));
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(SpatialArb.getString("MapViewerGeometryContextColumn"));
        defaultTableModel.addColumn(SpatialArb.getString("MapViewerGeometryContextValue"));
        if (this.attrValues != null && this.attrValues.length > 0) {
            for (int i = 0; i < this.attrValues.length; ++i) {
                if (!this.attrValues[i].isShowAllowed()) continue;
                defaultTableModel.addRow(new String[]{this.attrValues[i].getName(), this.attrValues[i].getValue()});
            }
        }
        this.jTable1.setModel(defaultTableModel);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.closeButton.setText(SpatialArb.getString("MapViewerGeometryContextCloseButtonText"));
        this.closeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerGeometryContextCloseButtonText")));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowContextDialog.this.closeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING, -2, 100, -2)).addGap(22, 22, 22)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 180, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.closeButton).addGap(25, 25, 25)));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void setGeometry(JGeometry jGeometry) {
        this.currentGeometry = jGeometry;
    }

    public void setQuery(String string) {
        this.currentQuery = string;
    }
}

