/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.spatial.mapviewer.MapViewerHistoryDB;
import oracle.dbtools.spatial.mapviewer.MapViewerHistoryItem;
import oracle.dbtools.util.Resource;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MapViewerHistoryDBTableModel
extends AbstractTableModel {
    private static String[] colNames = new String[]{"SQL", "Connection", "Timestamp"};
    private static MapViewerHistoryDBTableModel _INSTANCE;

    public static synchronized MapViewerHistoryDBTableModel getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new MapViewerHistoryDBTableModel();
        }
        return _INSTANCE;
    }

    private MapViewerHistoryDBTableModel() {
        if (MapViewerHistoryDB.getDatabase().getRowCount() == 0L) {
            this.readHistory();
        }
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return (int)MapViewerHistoryDB.getDatabase().getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MapViewerHistoryItem mapViewerHistoryItem = MapViewerHistoryDB.getDatabase().getRowAt(n + 1);
        String string = null;
        if (mapViewerHistoryItem != null) {
            switch (n2) {
                case 0: {
                    string = mapViewerHistoryItem.getSql();
                    break;
                }
                case 1: {
                    string = mapViewerHistoryItem.getConn();
                    break;
                }
                case 2: {
                    string = mapViewerHistoryItem.getTime();
                }
            }
        }
        return string;
    }

    public synchronized void readHistory() {
        Node node = null;
        File file = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "SqlHistory.xml");
        if (file.exists()) {
            Object object;
            EntityCursor<MapViewerHistoryItem> entityCursor;
            try {
                entityCursor = new DOMParser();
                object = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")));
                entityCursor.setPreserveWhitespace(false);
                entityCursor.parse((Reader)object);
                node = entityCursor.getDocument();
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (node != null) {
                entityCursor = node.getFirstChild();
                object = entityCursor.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    MapViewerHistoryItem mapViewerHistoryItem = new MapViewerHistoryItem();
                    String string = XMLHelper.getNodeValue((Node)object.item(i), (String)"SQL");
                    String string2 = XMLHelper.getNodeValue((Node)object.item(i), (String)"Connection");
                    String string3 = XMLHelper.getNodeValue((Node)object.item(i), (String)"TimeStamp");
                    int n = 0;
                    try {
                        n = Integer.parseInt(XMLHelper.getNodeValue((Node)object.item(i), (String)"Executed"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    mapViewerHistoryItem.setConn(string2);
                    mapViewerHistoryItem.setTime(string3);
                    mapViewerHistoryItem.setSql(string);
                    MapViewerHistoryDB.getDatabase().put(mapViewerHistoryItem);
                }
            }
            try {
                entityCursor = MapViewerHistoryDB.getDatabase().getAllRows();
                for (MapViewerHistoryItem mapViewerHistoryItem : entityCursor) {
                    System.out.println(mapViewerHistoryItem.id + ":" + mapViewerHistoryItem.getSql());
                }
            }
            catch (DatabaseException databaseException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            }
            this.fireTableDataChanged();
        }
    }
}

