/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.log.LogException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.spatial.mapviewer.MapViewerHistoryItem;
import oracle.ide.ExtensionRegistry;

public class MapViewerHistoryDB {
    private Environment myEnv;
    private EntityStore store;
    private static MapViewerHistoryDB INSTANCE;
    private PrimaryIndex<Long, MapViewerHistoryItem> historyByID = null;
    private EnvironmentConfig envConfig = null;
    private StoreConfig storeConfig = null;
    private File envHome = null;

    public static synchronized MapViewerHistoryDB getDatabase() {
        if (INSTANCE == null) {
            INSTANCE = new MapViewerHistoryDB();
        }
        return INSTANCE;
    }

    private MapViewerHistoryDB() {
        try {
            this.openDB();
            this.historyByID = this.store.getPrimaryIndex(Long.class, MapViewerHistoryItem.class);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    public MapViewerHistoryItem findMatch(String string, String string2) {
        MapViewerHistoryItem mapViewerHistoryItem = null;
        try {
            EntityCursor entityCursor = this.historyByID.entities();
            for (MapViewerHistoryItem mapViewerHistoryItem2 : entityCursor) {
                if (mapViewerHistoryItem != null || !mapViewerHistoryItem2.getSql().equals(string) || !mapViewerHistoryItem2.getConn().equals(string2)) continue;
                mapViewerHistoryItem = mapViewerHistoryItem2;
            }
            entityCursor.close();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        return mapViewerHistoryItem;
    }

    public MapViewerHistoryItem findMatchByTitle(String string, String string2) {
        MapViewerHistoryItem mapViewerHistoryItem = null;
        try {
            EntityCursor entityCursor = this.historyByID.entities();
            for (MapViewerHistoryItem mapViewerHistoryItem2 : entityCursor) {
                if (mapViewerHistoryItem != null || !mapViewerHistoryItem2.getTitle().equals(string) || !mapViewerHistoryItem2.getConn().equals(string2)) continue;
                mapViewerHistoryItem = mapViewerHistoryItem2;
            }
            entityCursor.close();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        return mapViewerHistoryItem;
    }

    public boolean deleteByTitle(String string, String string2) {
        Object var3_3 = null;
        try {
            Vector<Long> vector = new Vector<Long>();
            EntityCursor entityCursor = this.historyByID.keys();
            for (Long l : entityCursor) {
                EntityCursor entityCursor2 = this.historyByID.entities((Object)l, true, (Object)l, true);
                for (MapViewerHistoryItem mapViewerHistoryItem : entityCursor2) {
                    if (!mapViewerHistoryItem.getTitle().equals(string) || !mapViewerHistoryItem.getConn().equals(string2)) continue;
                    vector.add(l);
                }
                entityCursor2.close();
            }
            entityCursor.close();
            for (int i = 0; i < vector.size(); ++i) {
                Long l;
                l = (Long)vector.elementAt(i);
                this.historyByID.delete((Object)l);
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        return true;
    }

    public boolean deleteByConnection(String string) {
        Object var2_2 = null;
        try {
            Vector<Long> vector = new Vector<Long>();
            EntityCursor entityCursor = this.historyByID.keys();
            for (Long l : entityCursor) {
                EntityCursor entityCursor2 = this.historyByID.entities((Object)l, true, (Object)l, true);
                for (MapViewerHistoryItem mapViewerHistoryItem : entityCursor2) {
                    if (!mapViewerHistoryItem.getConn().equals(string)) continue;
                    vector.add(l);
                }
                entityCursor2.close();
            }
            entityCursor.close();
            for (int i = 0; i < vector.size(); ++i) {
                Long l;
                l = (Long)vector.elementAt(i);
                this.historyByID.delete((Object)l);
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        return true;
    }

    public boolean containsItem(String string, String string2) {
        Object var3_3 = null;
        try {
            EntityCursor entityCursor = this.historyByID.entities();
            for (MapViewerHistoryItem mapViewerHistoryItem : entityCursor) {
                if (var3_3 != null || !mapViewerHistoryItem.getTitle().equals(string) || !mapViewerHistoryItem.getConn().equals(string2)) continue;
                return true;
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(MapViewerHistoryItem mapViewerHistoryItem) {
        try {
            PrimaryIndex<Long, MapViewerHistoryItem> primaryIndex = this.historyByID;
            synchronized (primaryIndex) {
                this.historyByID.putNoReturn(null, (Object)mapViewerHistoryItem);
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    public void put(MapViewerHistoryItem[] mapViewerHistoryItemArray) {
        if (mapViewerHistoryItemArray != null) {
            for (MapViewerHistoryItem mapViewerHistoryItem : mapViewerHistoryItemArray) {
                this.put(mapViewerHistoryItem);
            }
        }
    }

    public MapViewerHistoryItem[] getAllHistoryItems() {
        Object[] objectArray;
        Vector<MapViewerHistoryItem> vector = new Vector<MapViewerHistoryItem>();
        try {
            objectArray = this.historyByID.entities();
            for (MapViewerHistoryItem mapViewerHistoryItem : objectArray) {
                vector.add(mapViewerHistoryItem);
            }
            objectArray.close();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
        objectArray = new MapViewerHistoryItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void showHistory() {
        try {
            EntityCursor entityCursor = this.historyByID.entities();
            for (MapViewerHistoryItem mapViewerHistoryItem : entityCursor) {
                String string = mapViewerHistoryItem.getTitle();
                String string2 = mapViewerHistoryItem.getConn();
                String string3 = mapViewerHistoryItem.getSql();
                String string4 = mapViewerHistoryItem.getLineColor();
                String string5 = mapViewerHistoryItem.getFillColor();
                System.out.println("MapViewerHistoryItem.showHistory: title=" + string + "/sql=" + string3 + "/conn=" + string2);
            }
            entityCursor.close();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    public EntityCursor<MapViewerHistoryItem> searchFor(String string) throws DatabaseException, UnsupportedEncodingException {
        return this.historyByID.entities();
    }

    private void openDB() {
        File file = new File(ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.spatial").getFile());
        try {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setTransactional(true);
            this.envConfig.setAllowCreate(true);
            this.envConfig.setReadOnly(false);
            this.storeConfig = new StoreConfig();
            this.storeConfig.setTransactional(true);
            this.storeConfig.setAllowCreate(true);
            this.myEnv = new Environment(file, this.envConfig);
            this.store = new EntityStore(this.myEnv, "HistoryStore", this.storeConfig);
            SequenceConfig sequenceConfig = this.store.getSequenceConfig("ID");
            sequenceConfig.setRange(0L, Long.MAX_VALUE);
            this.store.setSequenceConfig("ID", sequenceConfig);
        }
        catch (LogException logException) {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setTransactional(true);
            this.envConfig.setReadOnly(true);
            this.storeConfig = new StoreConfig();
            this.storeConfig.setTransactional(true);
            this.storeConfig.setReadOnly(true);
            try {
                this.myEnv = new Environment(file, this.envConfig);
                this.store = new EntityStore(this.myEnv, "HistoryStore", this.storeConfig);
                SequenceConfig sequenceConfig = this.store.getSequenceConfig("ID");
                sequenceConfig.setRange(0L, Long.MAX_VALUE);
                this.store.setSequenceConfig("ID", sequenceConfig);
            }
            catch (DatabaseException databaseException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            }
        }
        catch (IncompatibleClassException incompatibleClassException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, incompatibleClassException.getStackTrace()[0].toString(), incompatibleClassException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalArgumentException.getStackTrace()[0].toString(), illegalArgumentException);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    public long getRowCount() {
        try {
            return this.historyByID.count();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return 0L;
        }
    }

    public MapViewerHistoryItem getRowAt(int n) {
        try {
            return (MapViewerHistoryItem)this.historyByID.get((Object)n);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return null;
        }
    }

    public EntityCursor<MapViewerHistoryItem> getAllRows() throws DatabaseException {
        return this.historyByID.entities();
    }

    public boolean isReadOnly() {
        return this.envConfig.getReadOnly();
    }
}

