/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.DropTargetJPanel;
import oracle.dbtools.spatial.mapviewer.MapViewerPanel3;
import oracle.ide.Ide;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

class MapViewerDropTargetListener
implements DropTargetListener {
    DropTargetJPanel dp;
    private String currentConnectionName = null;
    private ObjectNode objN = null;
    private String type = null;
    private String objectName = null;

    public MapViewerDropTargetListener(DropTargetJPanel dropTargetJPanel) {
        this.dp = dropTargetJPanel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(1);
        try {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            List list = RaptorDnD.getTransferableNodes((Transferable[])new Transferable[]{transferable});
            for (int i = 0; i < list.size(); ++i) {
                Object object = null;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                defaultMutableTreeNode = list.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)list.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)list.get(i);
                object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DatabaseConnection) {
                    if (!Connections.getInstance().isOracle(((DatabaseConnection)object).getConnectionName())) {
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                    break;
                }
                if (object instanceof ObjectNode) {
                    this.objN = (ObjectNode)object;
                    this.objectName = this.objN.getObjectName();
                    this.type = this.objN.getObjectType();
                    try {
                        if (!Connections.getInstance().isOracle(Connections.getInstance().getConnection(this.objN.getConnectionName()))) {
                            dropTargetDragEvent.rejectDrag();
                            break;
                        }
                        String string = ((MapViewerPanel3)this.dp).getCurrentConnectionName();
                        if (string.equals("")) {
                            throw new Exception(SpatialArb.getString("SpatialError13512"));
                        }
                        if (!string.equals("") && !string.equals(this.objN.getConnectionName())) {
                            throw new Exception(SpatialArb.getString("SpatialError13513"));
                        }
                    }
                    catch (DBException dBException) {
                        dropTargetDragEvent.rejectDrag();
                        break;
                    }
                }
                if (this.type != null && (this.type.equals("TABLE") || this.type.equals("VIEW"))) continue;
                dropTargetDragEvent.rejectDrag();
                break;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
            ExceptionHandler.handleException((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        catch (Exception exception) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)"", null);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        String string = ((MapViewerPanel3)this.dp).getCurrentConnectionName();
        if (this.objN != null && (string == null || string.equals(""))) {
            ((MapViewerPanel3)this.dp).setUserPreferredConnection(this.objN.getConnectionName());
        }
        this.objectName = this.objN.getObjectName();
        if (this.objectName != null && this.objectName.length() > 0) {
            ((MapViewerPanel3)this.dp).invokeNewQueryDialog(this.objectName, "SELECT * FROM " + this.objectName, false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragActionChanged: e.source=" + dropTargetDragEvent.getSource().toString());
        dropTargetDragEvent.acceptDrag(1);
    }
}

