/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JPanel;
import oracle.dbtools.spatial.mapviewer.MapViewerFrame;
import oracle.dbtools.spatial.mapviewer.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.mapviewer.MapViewerPanel3;
import oracle.dbtools.spatial.mapviewer.OracleDatabaseConnector;
import oracle.spatial.geometry.JGeometry;

public class MapViewerController3 {
    MapViewerFrame mvf = null;
    private static final boolean USE_GENERAL_CONNECTION = true;
    private static final boolean USE_LOCALHOST_FOR_DEBUG = false;
    MapViewerGeometryResultSet mvrs = null;
    MapViewerPanel3 mvp = null;
    private static MapViewerController3 mapViewerController3 = null;

    private MapViewerController3() {
    }

    public static MapViewerController3 getInstance() {
        if (mapViewerController3 == null) {
            mapViewerController3 = new MapViewerController3();
        }
        return mapViewerController3;
    }

    public void launchMapViewer(JPanel jPanel) {
        MapViewerPanel3.cleanStaticReferences();
        this.mvp = MapViewerPanel3.getInstance();
        jPanel.add(this.mvp);
    }

    public void processNonMapviewerGeometry(JGeometry jGeometry) {
        MapViewerPanel3.cleanStaticReferences();
        this.mvp = MapViewerPanel3.getInstance();
        this.mvp.highLightExternalGeometryInMap(jGeometry);
    }

    public void processExternalAddQueryDialogRequest(String string, String string2, String string3) {
        MapViewerPanel3.cleanStaticReferences();
        this.mvp = MapViewerPanel3.getInstance();
        if (this.mvp.setUserPreferredConnection(string)) {
            this.mvp.invokeNewQueryDialog(string2, string3, false);
        }
    }

    public void removeHoldingReferences() {
        this.mvrs = null;
        this.mvp = null;
    }

    public Connection connectToLocalHostDatabase() {
        Connection connection = null;
        try {
            OracleDatabaseConnector oracleDatabaseConnector = new OracleDatabaseConnector();
            oracleDatabaseConnector.register("adc2170297", "ora112", "1521", "self", "self");
            connection = oracleDatabaseConnector.connect();
            oracleDatabaseConnector.testConnection(connection);
        }
        catch (SQLException sQLException) {
            System.out.println("MapViewerController.Error Message: " + sQLException.getMessage());
            return null;
        }
        catch (Exception exception) {
            System.out.println("MapViewerController.Error Message: " + exception.getMessage());
            return null;
        }
        return connection;
    }
}

