/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.MapGeometry;
import oracle.dbtools.spatial.mapviewer.MapGeometryCache;
import oracle.dbtools.spatial.mapviewer.MapViewerPanel3;
import oracle.dbtools.spatial.mapviewer.MapViewerRenderer;
import oracle.dbtools.spatial.mapviewer.ShowContextDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.sdovis.XFViewPort;
import oracle.spatial.geometry.JGeometry;

public class ImagePanel
extends JPanel {
    private Image image = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private JPopupMenu popup = null;
    private JMenuItem menuItem1 = null;
    private JMenuItem menuItem2 = null;
    private JMenuItem menuItem3 = null;
    private JMenuItem menuItem4 = null;
    private ShowContextDialog showContextDialog = null;
    private Point validGeometryPoint = null;
    private JGeometry validGeometry = null;
    private String validQuery = null;
    private ImageIcon pan_ico;
    private ImageIcon pan_down_ico;
    private ImageIcon crosswire_ico;
    private final int MAXIMAGESIZE = 15000;
    private boolean DEBUG = false;
    private boolean DEBUG1 = true;
    private Point previousImageCenter = null;
    private static ImagePanel imgPanel = null;
    private Icon panIcon = OracleIcons.getIcon((String)"pan.png");
    int state = 0;
    int ZOOM_IN = 50;
    int ZOOM_OUT = 50;
    Point startDragPoint = new Point(0, 0);
    Point endDragPoint = new Point(0, 0);
    Point diffPoint = new Point(0, 0);
    Point offset = new Point(0, 0);
    Point newPoint = new Point(0, 0);
    Point startMarqueeZoomDragPoint = new Point(0, 0);
    Point endMarqueeZoomDragPoint = new Point(0, 0);

    private ImagePanel() {
        this.init();
    }

    public static ImagePanel getInstance() {
        if (imgPanel == null) {
            imgPanel = new ImagePanel();
        }
        return imgPanel;
    }

    private void init() {
        this.popup = new JPopupMenu();
        this.popup.setBackground(Color.white);
        this.popup.setVisible(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImagePanel.this.DEBUG) {
                    System.out.println("ShowLocation.e.getSource=" + actionEvent.getSource());
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImagePanel.this.DEBUG) {
                    System.out.println("ShowContext.DialogListener.e.getSource=" + actionEvent.getSource());
                }
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (ImagePanel.this.DEBUG) {
                    System.out.println("validQuery=" + ImagePanel.this.validQuery);
                    System.out.println("validGeometry=" + ImagePanel.this.validGeometry);
                    System.out.println("image=" + ImagePanel.this.image);
                }
                if (ImagePanel.this.validQuery != null && ImagePanel.this.validGeometry != null && ImagePanel.this.image != null) {
                    ImagePanel.this.showContextDialog = new ShowContextDialog((Frame)new JFrame(), true, ImagePanel.this.validQuery, ImagePanel.this.validGeometry);
                    ImagePanel.this.showContextDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                        }
                    });
                    ImagePanel.this.showContextDialog.setVisible(true);
                    ImagePanel.this.showContextDialog.setGeometry(ImagePanel.this.validGeometry);
                    ImagePanel.this.showContextDialog.setQuery(ImagePanel.this.validQuery);
                }
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImagePanel.this.DEBUG) {
                    System.out.println("e.getSource=" + actionEvent.getSource());
                }
            }
        };
        this.menuItem3 = new JMenuItem(SpatialArb.getString("MapViewerImagePanelShowGeometryContext"));
        this.menuItem3.addActionListener(actionListener2);
        this.menuItem3.setEnabled(true);
        this.popup.add(this.menuItem3);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        PanningMouseListener panningMouseListener = new PanningMouseListener();
        this.addMouseListener(panningMouseListener);
        PanningMotionListener panningMotionListener = new PanningMotionListener();
        this.addMouseMotionListener(panningMotionListener);
        MarqueeZoomMouseListener marqueeZoomMouseListener = new MarqueeZoomMouseListener();
        this.addMouseListener(marqueeZoomMouseListener);
        MarqueeZoomMotionListener marqueeZoomMotionListener = new MarqueeZoomMotionListener();
        this.addMouseMotionListener(marqueeZoomMotionListener);
    }

    private void setPanCursor() {
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void releasePanCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setMarqueeZoomCursor() {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void releaseMarqueeZoomCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        MapViewerPanel3.getInstance().resetMarqueeButton();
    }

    private boolean isMarqueeZoomState() {
        return this.getState() == 4;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.DEBUG) {
            System.out.println("ImagePanel.paintComponent().Entering paintComponent ...getState()=" + this.getState());
        }
        if (this.image != null) {
            if (this.DEBUG) {
                System.out.println("ImagePanel.paintComponent().Entering paintComponent ...Image[Width=" + this.getImageWidth() + ", Height=" + this.getImageHeight() + "]");
            }
            this.imageWidth = this.image.getWidth(null);
            this.imageHeight = this.image.getHeight(null);
            switch (this.getState()) {
                case 0: {
                    this.previousImageCenter = this.getCurrentImageCenterPoint(this.image);
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    if (!this.DEBUG) break;
                    System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_DEFAULT> newPoint.x =" + this.newPoint.x + ", newPoint.y = " + this.newPoint.y);
                    break;
                }
                case 1: {
                    this.recalculateOriginPoint(this.image, this.previousImageCenter);
                    this.previousImageCenter = this.getCurrentImageCenterPoint(this.image);
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    this.setStateDefault();
                    break;
                }
                case 2: {
                    this.recalculateOriginPoint(this.image, this.previousImageCenter);
                    this.previousImageCenter = this.getCurrentImageCenterPoint(this.image);
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    this.setStateDefault();
                    break;
                }
                case 3: {
                    this.newPoint.x = 0;
                    this.newPoint.y = 0;
                    this.previousImageCenter = this.getCurrentImageCenterPoint(this.image);
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    this.setStateDefault();
                    break;
                }
                case 4: {
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    if (this.DEBUG) {
                        if (this.image == null) {
                            System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE> (IMAGE == NULL) newPoint.x =" + this.newPoint.x + ", newPoint.y = " + this.newPoint.y);
                        } else {
                            System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE> (IMAGE != NULL) newPoint.x =" + this.newPoint.x + ", newPoint.y = " + this.newPoint.y);
                        }
                    }
                    if (this.endMarqueeZoomDragPoint != null && this.startMarqueeZoomDragPoint != null) {
                        graphics.setColor(Color.yellow);
                        int n = this.endMarqueeZoomDragPoint.x - this.startMarqueeZoomDragPoint.x;
                        int n2 = this.endMarqueeZoomDragPoint.y - this.startMarqueeZoomDragPoint.y;
                        graphics.drawRect(this.startMarqueeZoomDragPoint.x, this.startMarqueeZoomDragPoint.y, n, n2);
                        graphics.setColor(new Color(0.5f, 0.5f, 0.5f, 0.2f));
                        graphics.fillRect(this.startMarqueeZoomDragPoint.x, this.startMarqueeZoomDragPoint.y, n, n2);
                        break;
                    }
                    if (!this.DEBUG) break;
                    if (this.endMarqueeZoomDragPoint == null) {
                        System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE_DRAWIMAGE> endMarqueeZoomDragPoint == null");
                    } else {
                        System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE_DRAWIMAGE> endMarqueeZoomDragPoint != null");
                    }
                    if (this.startMarqueeZoomDragPoint == null) {
                        System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE_DRAWIMAGE> startMarqueeZoomDragPoint == null");
                        break;
                    }
                    System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE_DRAWIMAGE> startMarqueeZoomDragPoint != null");
                    break;
                }
                case 5: {
                    if (this.DEBUG) {
                        System.out.println("ImagePanel.paintComponent().MapViewerPanel3.STATE_ZOOM_MARQUEE_DRAWIMAGE> newPoint.x =" + this.newPoint.x + ", newPoint.y = " + this.newPoint.y);
                    }
                    this.previousImageCenter = this.getCurrentImageCenterPoint(this.image);
                    graphics.drawImage(this.image, this.newPoint.x, this.newPoint.y, this);
                    this.setStateDefault();
                }
            }
        } else {
            if (this.DEBUG) {
                System.out.println("ImagePanel.paintComponent(). Image is now null ... no image was processed!");
            }
            graphics.drawImage(null, 0, 0, this);
        }
        graphics.dispose();
        if (this.DEBUG) {
            if (this.image != null) {
                System.out.println("ImagePanel.paintComponent().Exiting paintComponent ...Image[Width=" + this.getImageWidth() + ", Height=" + this.getImageHeight() + "]");
            } else {
                System.out.println("ImagePanel.paintComponent().Exiting paintComponent ...Image [0,0]");
            }
            System.out.println("ImagePanel.paintComponent().Exiting paintComponent ...getState()=" + this.getState());
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public synchronized void removeImage() {
        this.menuItem3.setEnabled(false);
        if (this.image != null) {
            this.image.flush();
            this.image = null;
            System.gc();
            this.repaint();
        }
    }

    public void setImage(Image image) {
        this.removeImage();
        this.menuItem3.setEnabled(true);
        this.image = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.setPreferredSize(new Dimension(this.imageWidth, this.imageHeight));
        if (this.DEBUG) {
            System.out.println("ImagePanel.setImage().Setting Image ... calling repaint() ...imageWidth =" + this.imageWidth + ", imageHeight=" + this.imageHeight + ",  getState()=" + this.getState());
        }
        this.repaint();
        if (this.DEBUG) {
            System.out.println("ImagePanel.setImage(). After invoking repaint() ...");
        }
    }

    public void setImage(Image image, Point point) {
        this.newPoint = point;
        this.setImage(image);
    }

    public void setImage(Image image, Point point, boolean bl) {
        this.setImage(image);
        if (!bl) {
            this.newPoint = point;
        } else {
            if (this.DEBUG) {
                System.out.println("ImagePanel.setImage.(this.imageHeight/2)=" + this.imageHeight / 2 + ", IMAGE_H=" + this.imageHeight);
                System.out.println("ImagePanel.setImage.(this.imageWidth/2)=" + this.imageWidth / 2 + ", IMAGE_W=" + this.imageWidth);
                System.out.println("ImagePanel.setImage.(this.getHeight()/2)=" + this.getHeight() / 2 + ", this.getHeight()=" + this.getHeight());
                System.out.println("ImagePanel.setImage.(this.getWidth()/2)=" + this.getWidth() / 2 + ", this.getWidth()=" + this.getWidth());
            }
            int n = -(point.x - this.getWidth() / 2);
            int n2 = -(point.y - this.getHeight() / 2);
            if (this.DEBUG) {
                System.out.println("ImagePanel.setImage.atPoint.x=" + point.x);
                System.out.println("ImagePanel.setImage.atPoint.y=" + point.y);
                System.out.println("ImagePanel.setImage.x=" + n);
                System.out.println("ImagePanel.setImage.y=" + n2);
            }
            this.newPoint = new Point(n, n2);
            if (this.DEBUG) {
                System.out.println("ImagePanel.setImage.this.newPoint.x=" + this.newPoint.x);
                System.out.println("ImagePanel.setImage.this.newPoint.y=" + this.newPoint.y);
            }
        }
    }

    private void imagePanelComponentResized(ComponentEvent componentEvent) {
        Point point = this.getLocationOnScreen();
    }

    private void imagePanelMouseClicked(MouseEvent mouseEvent) {
        this.validGeometry = null;
        this.validQuery = null;
        if (this.DEBUG) {
            System.out.println("ImagePanelMouseClicked.evt.getSource=" + mouseEvent.getSource());
        }
        if (mouseEvent.getButton() == 3) {
            Object[] objectArray;
            Point point = mouseEvent.getPoint();
            if (this.DEBUG) {
                System.out.println("ImagePanelMouseClicked.Point p1=" + point.toString());
            }
            XFViewPort xFViewPort = new XFViewPort();
            xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, this.getImageWidth(), this.getImageHeight()));
            xFViewPort.setStrict(true);
            Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
            MapGeometry[] mapGeometryArray = this.getMapGeometries();
            if (mapGeometryArray == null) {
                return;
            }
            for (int i = 0; i < mapGeometryArray.length; ++i) {
                objectArray = mapGeometryArray[i].getGeometries();
                for (int j = 0; j < objectArray.length; ++j) {
                    vector.add(objectArray[j]);
                }
            }
            Object[] objectArray2 = new AnnotatedGeometry[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = new double[objectArray2.length];
            double[] dArray = new double[objectArray2.length];
            double[] dArray2 = new double[objectArray2.length];
            double[] dArray3 = new double[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                double[] dArray4 = ((AnnotatedGeometry)objectArray2[i]).getGeometry().getMBR();
                objectArray[i] = (AnnotatedGeometry)dArray4[0];
                dArray[i] = dArray4[1];
                dArray2[i] = dArray4[2];
                dArray3[i] = dArray4[3];
            }
            double[] dArray5 = new double[4];
            Arrays.sort((double[])objectArray);
            dArray5[0] = (double)objectArray[0];
            Arrays.sort(dArray);
            dArray5[1] = dArray[0];
            Arrays.sort(dArray2);
            dArray5[2] = dArray2[objectArray2.length - 1];
            Arrays.sort(dArray3);
            dArray5[3] = dArray3[objectArray2.length - 1];
            double d = dArray5[2] - dArray5[0];
            double d2 = dArray5[3] - dArray5[1];
            xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray5[0], dArray5[1], d, d2));
            AffineTransform affineTransform = xFViewPort.getAffineTransform();
            Vector<GeomInfo> vector2 = new Vector<GeomInfo>();
            point = this.getPointRelativeToImage(point);
            if (this.DEBUG) {
                System.out.println("ImagePanelMouseClicked.Point p1 after relative change =" + point.toString());
            }
            if (point.getX() <= (double)this.getImageWidth() && point.getY() <= (double)this.getImageHeight()) {
                if (this.DEBUG) {
                    System.out.println("ImagePanelMouseClicked.Point (IN AREA) p1=" + point.toString() + "[" + this.getImageWidth() + "," + this.getImageHeight() + "]");
                }
                MapGeometry[] mapGeometryArray2 = this.getMapGeometries();
                int n = this.getLowestVisibleLayer();
                for (int i = 0; i < mapGeometryArray2.length; ++i) {
                    AnnotatedGeometry[] annotatedGeometryArray = mapGeometryArray2[i].getGeometries();
                    int n2 = mapGeometryArray2[i].getLayerNumber();
                    for (int j = 0; j < annotatedGeometryArray.length; ++j) {
                        Shape shape = null;
                        if (this.DEBUG) {
                            System.out.println("ageoms[" + j + "].getType()=" + annotatedGeometryArray[j].getGeometry().getType());
                        }
                        if (annotatedGeometryArray[j].getGeometry().getType() == 1) {
                            double[] dArray6 = annotatedGeometryArray[j].getGeometry().getPoint();
                            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray6[0], dArray6[1], 0.1f, 0.1f);
                            shape = affineTransform.createTransformedShape(double_);
                        } else {
                            shape = annotatedGeometryArray[j].getGeometry().createShape(affineTransform, true);
                            if (this.DEBUG) {
                                System.out.println("shp.x=" + shape.getBounds().x + "/shp.y=" + shape.getBounds().y + "/shp.width=" + shape.getBounds().width + "/shp.height=" + shape.getBounds().height);
                            }
                        }
                        boolean bl = shape.contains(point);
                        if (this.DEBUG) {
                            System.out.println("ImagePanelMouseClicked.Point (IS_POINT_CONTAINED) =" + bl + ", currentLayerId=" + n2 + ", lowestLayerId=" + n);
                        }
                        if (!bl || n2 != n) continue;
                        vector2.add(new GeomInfo(i, j, shape.getBounds2D().getWidth() * shape.getBounds2D().getHeight()));
                    }
                    annotatedGeometryArray = null;
                }
                if (vector2 == null || vector2.size() == 0) {
                    return;
                }
                GeomInfo geomInfo = (GeomInfo)vector2.elementAt(0);
                for (int i = 1; i < vector2.size(); ++i) {
                    if (!(((GeomInfo)vector2.elementAt(i)).getGeomArea() < geomInfo.getGeomArea())) continue;
                    geomInfo = (GeomInfo)vector2.elementAt(i);
                }
                this.validGeometryPoint = point;
                this.validGeometry = (JGeometry)mapGeometryArray2[geomInfo.getMapNumber()].getGeometries()[geomInfo.getMapIndex()].getGeometry().clone();
                this.validQuery = new String(mapGeometryArray2[geomInfo.getMapNumber()].getQuery());
            } else if (this.DEBUG) {
                System.out.println("ImagePanelMouseClicked.Point (NOT IN AREA) p1=" + point.toString() + "[" + this.imageWidth + "," + this.imageHeight + "]");
            }
            vector = null;
            vector2 = null;
        }
    }

    private void calculateMarqueeZoomedImage2(Point point, Point point2, Point point3) {
        int n;
        MapGeometry[] mapGeometryArray = this.getMapGeometries();
        if (mapGeometryArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Point point4 = new Point(point.x, point.y);
        int n4 = point2.x;
        int n5 = point2.y;
        int n6 = point3.x;
        int n7 = point3.y;
        double d = Math.abs(n6 - n4);
        double d2 = Math.abs(n7 - n5);
        if (d == 0.0 || d2 == 0.0) {
            return;
        }
        n2 = imgPanel.getWidth();
        n3 = imgPanel.getHeight();
        double d3 = (double)n3 / d2;
        double d4 = (double)n2 / d;
        double d5 = Math.min(d3, d4);
        double[] dArray = this.getImageMBR();
        double d6 = dArray[2] - dArray[0];
        double d7 = dArray[3] - dArray[1];
        int n8 = Math.round((float)d5 * (float)this.getImageWidth());
        if (!this.isImageSizeAllowedInHeapMemory(n8, n = Math.round((float)((double)n8 * (d7 / d6))))) {
            n8 = this.getImageWidth();
            n = this.getImageHeight();
        }
        this.newPoint.x = -Math.round((float)(n4 - point4.x) / (float)this.getImageWidth() * (float)n8);
        this.newPoint.y = -Math.round((float)(n5 - point4.y) / (float)this.getImageHeight() * (float)n);
        MapViewerRenderer mapViewerRenderer = new MapViewerRenderer();
        Image image = mapViewerRenderer.generateClippedImage(mapGeometryArray, n8, n, dArray);
        this.previousImageCenter = this.getCurrentImageCenterPoint(image);
        this.setImage(image);
    }

    private long getFreeHeapMemorySize() {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return l;
    }

    private boolean isImageSizeAllowedInHeapMemory(int n, int n2) {
        int n3;
        long l = (long)n * (long)n2;
        long l2 = this.getFreeHeapMemorySize();
        long l3 = l2 / (long)(n3 = 3);
        return l < l3;
    }

    private double[] getImageMBR() {
        Object[] objectArray;
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        MapGeometry[] mapGeometryArray = this.getMapGeometries();
        if (mapGeometryArray == null) {
            return null;
        }
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            objectArray = mapGeometryArray[i].getGeometries();
            for (int j = 0; j < objectArray.length; ++j) {
                vector.add(objectArray[j]);
            }
        }
        Object[] objectArray2 = new AnnotatedGeometry[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new double[objectArray2.length];
        double[] dArray = new double[objectArray2.length];
        double[] dArray2 = new double[objectArray2.length];
        double[] dArray3 = new double[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            double[] dArray4 = ((AnnotatedGeometry)objectArray2[i]).getGeometry().getMBR();
            objectArray[i] = (AnnotatedGeometry)dArray4[0];
            dArray[i] = dArray4[1];
            dArray2[i] = dArray4[2];
            dArray3[i] = dArray4[3];
        }
        double[] dArray5 = new double[4];
        Arrays.sort((double[])objectArray);
        dArray5[0] = (double)objectArray[0];
        Arrays.sort(dArray);
        dArray5[1] = dArray[0];
        Arrays.sort(dArray2);
        dArray5[2] = dArray2[objectArray2.length - 1];
        Arrays.sort(dArray3);
        dArray5[3] = dArray3[objectArray2.length - 1];
        if (this.DEBUG) {
            System.out.println("getImageMBR.newMBR[0]=" + dArray5[0] + ", newMBR[1]=" + dArray5[1] + ", newMBR[2]=" + dArray5[2] + ", newMBR[3]=" + dArray5[3]);
        }
        vector = null;
        return dArray5;
    }

    public MapGeometry[] getMapGeometries() {
        MapGeometryCache mapGeometryCache = MapGeometryCache.getInstance();
        return mapGeometryCache.getMapCache();
    }

    private int getLowestVisibleLayer() {
        MapGeometryCache mapGeometryCache = MapGeometryCache.getInstance();
        return mapGeometryCache.getLowestVisibleLayer();
    }

    protected void setState(int n) {
        this.state = n;
    }

    protected int getState() {
        return this.state;
    }

    protected boolean isStateDefault() {
        return this.state == 0;
    }

    protected void setStateDefault() {
        this.setState(0);
    }

    private Point getPointRelativeToImage(Point point) {
        int n = point.x - this.newPoint.x;
        int n2 = point.y - this.newPoint.y;
        if (this.DEBUG) {
            System.out.println("p.x=" + point.x + "|p.y=" + point.y + "|x=" + n + "|y=" + n2);
        }
        return new Point(n, n2);
    }

    public Point getCurrentImageCenterPoint(Image image) {
        if (image == null) {
            return null;
        }
        return new Point(this.newPoint.x + image.getWidth(null) / 2, this.newPoint.y + image.getHeight(null) / 2);
    }

    private void printImageDetails(Image image, Point point) {
        if (image != null && point != null) {
            System.out.println("---------------- Image Details --------------");
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            Point point2 = this.getCurrentImageCenterPoint(image);
            System.out.println("Current image size = [" + n + "," + n2 + "]");
            System.out.println("Current newPoint = [" + this.newPoint.x + ", " + this.newPoint.y + "], newImageCenterPoint=[" + point2.x + ", " + point2.y + "], oldImageCenterPoint=[" + point.x + ", " + point.y + "]");
            System.out.println("=============================================");
        } else {
            if (image == null) {
                System.out.println("img == null");
            }
            if (point == null) {
                System.out.println("oldImageCenterPoint == null");
            }
        }
    }

    private void recalculateOriginPoint(Image image, Point point) {
        if (image == null || point == null) {
            return;
        }
        this.newPoint.x = point.x - image.getWidth(null) / 2;
        this.newPoint.y = point.y - image.getHeight(null) / 2;
    }

    class GeomInfo {
        int map = 0;
        int index = 0;
        double area = 0.0;

        public GeomInfo(int n, int n2, double d) {
            this.map = n;
            this.index = n2;
            this.area = d;
        }

        public int getMapNumber() {
            return this.map;
        }

        public int getMapIndex() {
            return this.index;
        }

        public double getGeomArea() {
            return this.area;
        }

        public void print() {
            System.out.println("Map#=" + this.map + ", Index=" + this.index + ", area=" + this.area);
        }
    }

    class MarqueeZoomMotionListener
    extends MouseMotionAdapter {
        MarqueeZoomMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isMarqueeZoomState()) {
                ImagePanel.this.endMarqueeZoomDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.repaint();
            }
        }
    }

    class MarqueeZoomMouseListener
    extends MouseAdapter {
        MarqueeZoomMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isMarqueeZoomState()) {
                ImagePanel.this.startMarqueeZoomDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.setMarqueeZoomCursor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isMarqueeZoomState()) {
                ImagePanel.this.endMarqueeZoomDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.releaseMarqueeZoomCursor();
                ImagePanel.this.setState(5);
                ImagePanel.this.calculateMarqueeZoomedImage2(ImagePanel.this.newPoint, ImagePanel.this.startMarqueeZoomDragPoint, ImagePanel.this.endMarqueeZoomDragPoint);
                ImagePanel.this.repaint();
                ImagePanel.this.startMarqueeZoomDragPoint = null;
                ImagePanel.this.endMarqueeZoomDragPoint = null;
            }
        }
    }

    class PanningMotionListener
    extends MouseMotionAdapter {
        PanningMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isStateDefault()) {
                ImagePanel.this.endDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.diffPoint.x = ImagePanel.this.endDragPoint.x - ImagePanel.this.startDragPoint.x;
                ImagePanel.this.diffPoint.y = ImagePanel.this.endDragPoint.y - ImagePanel.this.startDragPoint.y;
                ImagePanel.this.newPoint.x = ImagePanel.this.offset.x + ImagePanel.this.diffPoint.x;
                ImagePanel.this.newPoint.y = ImagePanel.this.offset.y + ImagePanel.this.diffPoint.y;
                ImagePanel.this.repaint();
            }
        }
    }

    class PanningMouseListener
    extends MouseAdapter {
        PanningMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isStateDefault()) {
                ImagePanel.this.setPanCursor();
                ImagePanel.this.startDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.offset.x = ImagePanel.this.newPoint.x;
                ImagePanel.this.offset.y = ImagePanel.this.newPoint.y;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ImagePanel.this.isStateDefault()) {
                ImagePanel.this.endDragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.diffPoint.x = ImagePanel.this.endDragPoint.x - ImagePanel.this.startDragPoint.x;
                ImagePanel.this.diffPoint.y = ImagePanel.this.endDragPoint.y - ImagePanel.this.startDragPoint.y;
                ImagePanel.this.offset.x = ImagePanel.this.newPoint.x;
                ImagePanel.this.offset.y = ImagePanel.this.newPoint.y;
                ImagePanel.this.releasePanCursor();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ImagePanel.this.popup.show(ImagePanel.this, mouseEvent.getX(), mouseEvent.getY());
                ImagePanel.this.imagePanelMouseClicked(mouseEvent);
            }
        }
    }
}

