/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.SpatialDockable;
import oracle.dbtools.spatial.SpatialViewer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.sql.STRUCT;

public class SpatialShowGeometriesInMap
extends GridContextMenuItem {
    private static SpatialShowGeometriesInMap _instance;
    public static final String SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP = "SpatialShowGeometryInMap";
    public static final int SPATIAL_SHOW_GEOMETRY_ID_IN_MAP;
    public static IdeAction SPATIAL_SHOW_GEOMETRY_IN_MAP;
    private JEWTDialog dlg = null;
    private boolean anyColIsGeom = false;
    private String geoColname = "";

    private SpatialShowGeometriesInMap() {
        this.initAction();
    }

    private void initAction() {
        if (SPATIAL_SHOW_GEOMETRY_IN_MAP == null) {
            SPATIAL_SHOW_GEOMETRY_IN_MAP = this.createAction(SPATIAL_SHOW_GEOMETRY_ID_IN_MAP, StringUtils.stripMnemonic((String)SpatialArb.getString("ShowGeometries")), null);
        }
    }

    public static SpatialShowGeometriesInMap getInstance() {
        if (_instance == null) {
            _instance = new SpatialShowGeometriesInMap();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        this.anyColIsGeom = false;
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            int n = iResultSetTableModel.getGridColumns().size();
            int n2 = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            n2 = this._table.convertRowIndexToModel(n2);
            for (int i = 0; i <= n - 1 && !this.anyColIsGeom; ++i) {
                this.geoColname = iResultSetTableModel.getColumnName(i);
                int n3 = iResultSetTableModel.getColumnSqlType(i);
                if (n3 != 2002) continue;
                STRUCT sTRUCT = null;
                Object object = iResultSetTableModel.getValueAt(n2, i);
                try {
                    if (object instanceof STRUCT) {
                        sTRUCT = (STRUCT)object;
                    }
                    if (sTRUCT == null || !sTRUCT.getSQLTypeName().equals("MDSYS.SDO_GEOMETRY")) continue;
                    this.anyColIsGeom = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.anyColIsGeom;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SPATIAL_SHOW_GEOMETRY_IN_MAP);
        jMenuItem.setText(SpatialArb.getString("ShowGeometriesInMap"));
        contextMenu.add((Component)jMenuItem);
    }

    private void showGeometryShapeInMap() {
        try {
            PropertyPanel propertyPanel = new PropertyPanel();
            String string = SpatialArb.getString("ShowGeometriesInMap");
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            String string2 = iResultSetTableModel.getModifiedSql();
            String string3 = iResultSetTableModel.getConnectionName();
            SpatialDockable spatialDockable = (SpatialDockable)DockStation.getDockStation().findDockable(new ViewId("SPATIAL_VIEW_TYPE.SPATIAL_VIEW_ID"));
            if (spatialDockable != null) {
                spatialDockable.show();
                SpatialViewer spatialViewer = (SpatialViewer)spatialDockable.getGUI();
                String string4 = "Default";
                if (this.geoColname != null) {
                    string4 = this.geoColname;
                }
                spatialViewer.invokeExternalAddQueryDialogRequest(string3, string4, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == SPATIAL_SHOW_GEOMETRY_ID_IN_MAP) {
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("", false, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() throws TaskException {
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SpatialShowGeometriesInMap.this.showGeometryShapeInMap();
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    });
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    static {
        SPATIAL_SHOW_GEOMETRY_ID_IN_MAP = Ide.findOrCreateCmdID((String)SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP);
        SPATIAL_SHOW_GEOMETRY_IN_MAP = null;
    }
}

