/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial;

import java.awt.Component;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.SpatialViewer;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.BitField;

public class SpatialDockable
extends DockableWindow {
    public static final String VIEW_TYPE = "SPATIAL_VIEW_TYPE";
    public static final String VIEW_ID = "SPATIAL_VIEW_ID";
    public static final String COMMAND_ID = "SpatialCmdId";

    SpatialDockable() {
        super(SpatialDockable.getViewId());
    }

    public String getTabName() {
        return StringUtils.stripMnemonic((String)SpatialArb.getString("MapView"));
    }

    public String getTitleName() {
        return StringUtils.stripMnemonic((String)SpatialArb.getString("MapView"));
    }

    public Icon getTabIcon() {
        return SpatialArb.getIcon("MAP_ICON");
    }

    private static String getViewId() {
        return "SPATIAL_VIEW_TYPE.SPATIAL_VIEW_ID";
    }

    public Component getGUI() {
        return SpatialViewer.getInstance();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mapview_html");
    }

    public Toolbar getToolbar() {
        return ((SpatialViewer)this.getGUI()).getToolbar();
    }

    protected void dockableHidden(DockableEvent dockableEvent) {
        this.stateChange(2);
        if (BitField.isSet((int)dockableEvent.getContext(), (int)16)) {
            this.stateChange(3);
        }
        super.dockableHidden(dockableEvent);
    }

    protected void stateChanged(int n) {
        if (n == 3) {
            System.out.println("SpatialViewer.NewState = CLOSED/");
            SpatialViewer spatialViewer = (SpatialViewer)this.getGUI();
            if (spatialViewer != null) {
                System.out.println("Freeing MapViewerController/");
                spatialViewer.freeMapViewerController();
            }
            Runtime runtime = Runtime.getRuntime();
            System.out.println("dockableHidden.BeforeClosing.freeMemory=" + (runtime.maxMemory() - runtime.freeMemory()));
        }
        if (n == 2) {
            System.out.println("SpatialViewer.NewState = HIDDEN/");
        }
        if (n == 1) {
            System.out.println("SpatialViewerNewState = SHOWN/");
        }
    }
}

