/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.SpatialDockable;
import oracle.dbtools.spatial.actions.SpatialShowGeometriesInMap;
import oracle.dbtools.spatial.actions.SpatialShowGeometry;
import oracle.dbtools.spatial.dialogs.validate.model.SpatialValidationGrid;
import oracle.dbtools.spatial.dialogs.validate.view.ValidateErrors;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;

public class SpatialAddin
implements Addin,
DockableFactory {
    private int _viewActionId;
    private SpatialDockable _dockable;

    public Dockable getDockable(ViewId viewId) {
        return this.getSpatialDockable();
    }

    private SpatialDockable getSpatialDockable() {
        if (this._dockable == null) {
            this._dockable = new SpatialDockable();
        }
        return this._dockable;
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(3);
        DockStation dockStation = DockStation.getDockStation();
        dockStation.dock((Dockable)this.getSpatialDockable(), dockingParam);
    }

    public void initialize() {
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialtablemenu.xml"));
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialviewmenu.xml"));
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialmatviewmenu.xml"));
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialcolumnmenu.xml"));
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialviewcolumnmenu.xml"));
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("spatialmatviewcolumnmenu.xml"));
        SnippetAddin.registerSnippet((URL)this.getClass().getResource("snippets/spatialsnippets.xml"));
        ResultSetTable.addGridContextMenu((GridContextMenuItem)SpatialShowGeometry.getInstance());
        ResultSetTable.addGridContextMenu((GridContextMenuItem)SpatialShowGeometriesInMap.getInstance());
        SpatialValidationGrid.addGridContextMenu((GridContextMenuItem)ValidateErrors.getInstance());
        this.createActions();
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory("SPATIAL_VIEW_TYPE", (DockableFactory)this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void createActions() {
        this._viewActionId = Ide.findOrCreateCmdID((String)"SpatialCmdId");
        String string = SpatialArb.getString("MapView");
        IdeAction ideAction = IdeAction.get((int)this._viewActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)SpatialArb.getIcon("MAP_ICON"), null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 0.001f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != SpatialAddin.this._viewActionId) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)SpatialAddin.this.getSpatialDockable());
            return true;
        }
    }
}

