/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

final class GotoBookmarkPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private BookmarkManager bookmarkManager;
    private GotoDialog gotoDialog;
    private DefaultListModel listModel;
    private JButton button_remove;
    private JButton button_removeAll;
    private JList list_bookmarks;

    static void runDialog(BookmarkManager bookmarkManager) {
        Object selected;
        GotoBookmarkPanel panel = new GotoBookmarkPanel(bookmarkManager);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_idedgotobookmark_html");
        JList component = panel.list_bookmarks;
        String title = "BookmarkArb.getString( BookmarkArb.PANEL_TITLE";
        IdeMainWindow parent = Ide.getMainWindow();
        GotoDialog dialog = new GotoDialog((Frame)parent, panel, component, title);
        panel.setGotoDialog(dialog);
        boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
        if (ok && (selected = panel.list_bookmarks.getSelectedValue()) != null && selected instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)selected;
            bookmarkManager.gotoBookmark(bookmark);
        }
    }

    private GotoBookmarkPanel(BookmarkManager bookmarkManager) {
        super(new GridBagLayout());
        this.bookmarkManager = bookmarkManager;
        this.initializePanel();
    }

    private void setGotoDialog(GotoDialog dialog) {
        this.gotoDialog = dialog;
        this.updateButtonStatus();
    }

    private DefaultListModel createListModel(Object[] objects) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int numObjects = objects.length;
        for (int i = 0; i < numObjects; ++i) {
            model.addElement(objects[i]);
        }
        return model;
    }

    private void initializePanel() {
        String removeText = BookmarkArb.getString(20);
        this.button_remove = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_remove, (String)removeText);
        this.button_remove.addActionListener(this);
        String removeAllText = BookmarkArb.getString(21);
        this.button_removeAll = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_removeAll, (String)removeAllText);
        this.button_removeAll.addActionListener(this);
        String listText = "BookmarkArb.PANEL_LABEL_BOOKMARK";
        JLabel label_bookmarks = new JLabel();
        Object[] allBookmarks = this.bookmarkManager.getAllBookmarks();
        this.listModel = this.createListModel(allBookmarks);
        this.list_bookmarks = new JList(this.listModel);
        this.list_bookmarks.setCellRenderer(new Renderer());
        this.list_bookmarks.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)label_bookmarks, (Component)this.list_bookmarks, (String)listText);
        JScrollPane scrollpane_bookmarks = new JScrollPane(this.list_bookmarks);
        if (this.listModel.size() > 0) {
            this.list_bookmarks.setSelectedIndex(0);
        }
        this.list_bookmarks.addListSelectionListener(this);
        this.list_bookmarks.addMouseListener(this);
        Insets defaultInsets = new Insets(0, 0, 3, 0);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, defaultInsets, 0, 0);
        this.add((Component)label_bookmarks, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0);
        this.add((Component)scrollpane_bookmarks, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.button_remove, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(8, 0, 3, 0), 0, 0);
        this.add((Component)this.button_removeAll, constraints);
    }

    private void updateButtonStatus() {
        Object selected = this.list_bookmarks.getSelectedValue();
        boolean enableButtons = selected != null;
        this.button_remove.setEnabled(enableButtons);
        this.gotoDialog.setOKButtonEnabled(enableButtons);
        boolean hasElements = this.listModel.size() > 0;
        this.button_removeAll.setEnabled(hasElements);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.button_remove) {
            int listSize;
            int index = this.list_bookmarks.getSelectedIndex();
            Object selected = this.list_bookmarks.getSelectedValue();
            if (selected != null && selected instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)selected;
                this.bookmarkManager.removeBookmark(bookmark);
                this.listModel.removeElement(bookmark);
            }
            if ((listSize = this.listModel.size()) > 0) {
                index = Math.min(index, listSize - 1);
                this.list_bookmarks.setSelectedIndex(index);
            }
        } else if (source == this.button_removeAll) {
            this.bookmarkManager.removeAllBookmarks();
            this.listModel.removeAllElements();
        }
        this.updateButtonStatus();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateButtonStatus();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
            this.gotoDialog.pressOK();
        }
    }

    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private static final class GotoDialog
    extends JEWTDialog {
        private GotoDialog(Frame parent, Component contents, Component defaultComponent, String title) {
            super(parent, title, 7);
            this.setContent(contents);
            if (defaultComponent != null) {
                this.setInitialFocus(defaultComponent);
            }
            String goText = "BookmarkArb.PANEL_BUTTON_GO";
            int goMnemonic = StringUtils.getMnemonicKeyCode((String)goText);
            goText = StringUtils.stripMnemonic((String)goText);
            this.setOKButtonText(goText);
            this.setOKButtonMnemonic(goMnemonic);
            String closeText = "BookmarkArb.PANEL_BUTTON_CLOSE";
            int closeMnemonic = StringUtils.getMnemonicKeyCode((String)closeText);
            closeText = StringUtils.stripMnemonic((String)closeText);
            this.setCancelButtonText(closeText);
            this.setCancelButtonMnemonic(closeMnemonic);
        }

        private void pressOK() {
            super.dismissDialog(false);
        }
    }

    private static final class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String textToDisplay = "";
            Bookmark bookmark = (Bookmark)value;
            if (bookmark != null) {
                URL url = bookmark.getURL();
                String filename = URLFileSystem.getFileName((URL)url);
                String line = String.valueOf(bookmark.getLine());
                textToDisplay = BookmarkArb.format(24, filename, line);
            }
            return super.getListCellRendererComponent((JList<?>)list, textToDisplay, index, isSelected, cellHasFocus);
        }
    }
}

