/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.peek.PeekHelper;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.ui.Colors;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.PointingBorder;

final class BookmarkPreviewPanel
extends JPanel {
    private BasicEditorPane ep = new BasicEditorPane();
    private PointingBorder pointingBorder;
    private HighlightLayer highlightLayer;
    private JScrollPane sp;

    public BookmarkPreviewPanel() {
        this.ep.setCaret((Caret)new DefaultCaret(){

            @Override
            public void mouseClicked(MouseEvent me) {
                me.consume();
            }

            @Override
            public void mousePressed(MouseEvent me) {
                me.consume();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                me.consume();
            }
        });
        this.ep.getCaret().setVisible(false);
        this.sp = new JScrollPane((Component)this.ep, 21, 31);
        this.pointingBorder = new PointingBorder(Colors.FLAT_EDITOR_BORDER, this.ep.getBackground());
        this.sp.setBorder(this.pointingBorder);
        this.sp.setOpaque(false);
        this.sp.getViewport().setOpaque(false);
        this.add(this.sp);
    }

    public void previewBookmark(Bookmark bookmark, Point pointingPoint) {
        if (this.highlightLayer != null) {
            this.ep.destroyHighlightLayer(this.highlightLayer);
        }
        this.highlightLayer = null;
        if (bookmark == null) {
            this.ep.setEditable(true);
            this.ep.setText("");
            this.ep.setEditable(false);
        } else {
            if (bookmark.getURL() != null) {
                this.ep.setLanguageSupport(bookmark.getURL().getFile());
            }
            int pad = 6;
            String text = PeekHelper.getPeekText((URL)bookmark.getURL(), (int)bookmark.getLine(), (int)6);
            this.ep.setEditable(true);
            this.ep.setText(text);
            this.ep.setCaretPosition(0);
            this.ep.setEditable(false);
            this.highlightLayer = this.ep.createHighlightLayer();
            EditorProperties properties = EditorProperties.getProperties();
            HighlightStyle style = properties.getHighlightRegistry().lookupStyle("caret-line-highlight");
            this.highlightLayer.addLineHighlight(style, Math.min(6, bookmark.getLine()) - 1);
        }
        this.revalidate();
        this.setPoint(pointingPoint);
    }

    public void setPoint(Point pointingPoint) {
        this.pointingBorder.setPoint(pointingPoint);
        this.doLayout();
        this.repaint();
    }

    @Override
    public void doLayout() {
        Rectangle r = this.getBounds();
        int h = Math.min(r.height, this.sp.getPreferredSize().height);
        int y = r.height / 2 - h / 2;
        if (this.pointingBorder.getPoint() != null) {
            Point p = new Point(this.pointingBorder.getPoint());
            SwingUtilities.convertPointFromScreen(p, this);
            if (p.y < y + PointingBorder.PAD) {
                y = p.y - PointingBorder.PAD;
                y = Math.max(0, y);
            } else if (p.y > y + h - PointingBorder.PAD) {
                y = p.y + PointingBorder.PAD;
                y = Math.min(y, r.height - h);
                y = Math.max(0, y);
            }
        }
        this.sp.setBounds(0, y, r.width, h);
    }
}

