/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkAddin;
import oracle.jdevimpl.bookmarks.BookmarkEvent;
import oracle.jdevimpl.bookmarks.BookmarkIcons;
import oracle.jdevimpl.bookmarks.BookmarkListener;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

public class BookmarkPanel
extends JPanel
implements ContextMenuListener {
    private BookmarkManager bookmarkManager;
    private PeekableList bookmarkList;
    private DefaultListModel bookmarkListModel;
    private JButton removeButton;
    private ContextMenu contextMenu = new ContextMenu();
    private AssignNumberListener assignNumberListener = new AssignNumberListener();
    private static final String ASSIGN_KEY = "ASSIGN_KEY";
    private JMenuItem sourceItem;
    private JMenuItem removeItem;
    private JMenuItem removeAllItem;
    private Toolbar toolbar = new Toolbar();
    private JPanel listPanel;
    private static boolean hasShown = false;

    public BookmarkPanel(BookmarkManager bookmarkManager) {
        this.bookmarkManager = bookmarkManager;
        this._init();
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    private void _init() {
        this.setLayout(new BorderLayout());
        this.bookmarkListModel = new DefaultListModel();
        this.bookmarkList = new PeekableList(this.bookmarkListModel);
        this.bookmarkList.setCellRenderer(new Renderer());
        this.toolbar.setPrimaryViewToolbar(true);
        this._createPopupMenuItems();
        this.bookmarkManager.addBookmarkListener(new BookmarkListener(){

            @Override
            public void bookmarksChanged(BookmarkEvent evt) {
                switch (evt.getType()) {
                    case ADDITION: 
                    case REMOVAL: {
                        boolean isFirst = BookmarkPanel.this.bookmarkListModel.getSize() == 0;
                        BookmarkPanel.this.rebuildList();
                        if (isFirst && BookmarkPanel.this.bookmarkListModel.getSize() > 0) {
                            BookmarkPanel.this.bookmarkList.setSelectedIndex(0);
                        }
                        BookmarkPanel.this.repaint();
                        break;
                    }
                    case UPDATE: {
                        BookmarkPanel.this.repaint();
                    }
                }
            }
        });
        this.bookmarkList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = BookmarkPanel.this.bookmarkList.locationToIndex(e.getPoint());
                if (index == -1 || !BookmarkPanel.this.bookmarkList.getCellBounds(index, index).contains(e.getPoint())) {
                    return;
                }
                if (e.getClickCount() == 2 && index > -1) {
                    BookmarkPanel.this._jumpToSource(index);
                } else {
                    this.maybePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                int index = BookmarkPanel.this.bookmarkList.locationToIndex(e.getPoint());
                if (index == -1 || !BookmarkPanel.this.bookmarkList.getCellBounds(index, index).contains(e.getPoint())) {
                    return;
                }
                if (e.isPopupTrigger() && index > -1) {
                    BookmarkPanel.this.bookmarkList.setSelectedIndex(index);
                    BookmarkPanel.this._showMenu(e);
                }
            }
        });
        this.bookmarkList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                int index;
                if ((ke.getKeyCode() == 32 || ke.getKeyCode() == 10) && (index = BookmarkPanel.this.bookmarkList.getSelectedIndex()) != -1) {
                    BookmarkPanel.this._jumpToSource(index);
                }
            }
        });
        this.bookmarkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = BookmarkPanel.this.bookmarkList.getSelectedIndex();
                BookmarkPanel.this.removeButton.setEnabled(i > -1);
            }
        });
        JScrollPane sp = new JScrollPane(this.bookmarkList);
        sp.setBorder(null);
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(StringUtils.stripMnemonic((String)BookmarkArb.getString(20)));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = BookmarkPanel.this.bookmarkList.getSelectedIndex();
                for (Object o : BookmarkPanel.this.bookmarkList.getSelectedValues()) {
                    BookmarkPanel.this.bookmarkManager.removeBookmark((Bookmark)o);
                }
                BookmarkPanel.this.bookmarkList.setSelectedIndex(Math.min(i, BookmarkPanel.this.bookmarkList.getModel().getSize() - 1));
            }
        });
        this.removeButton.setEnabled(this.bookmarkList.getSelectedIndex() > -1);
        this.toolbar.add((Component)this.removeButton);
        JButton prefsButton = new JButton(OracleIcons.getIcon((String)"settings.png"));
        prefsButton.setToolTipText(StringUtils.stripMnemonic((String)BookmarkArb.getString(26)));
        prefsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{BookmarkArb.getString(27), BookmarkArb.getString(28)});
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)prefsButton);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.add((Component)this.toolbar, "North");
        this.listPanel.add((Component)sp, "Center");
        this.add((Component)this.listPanel, "Center");
    }

    public synchronized ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    private void _createPopupMenuItems() {
        String labelText = StringUtils.stripMnemonic((String)BookmarkArb.getString(23));
        this.sourceItem = new JMenuItem(labelText);
        this.sourceItem.setMnemonic(BookmarkArb.getMnemonic(23));
        labelText = StringUtils.stripMnemonic((String)BookmarkArb.getString(20));
        this.removeItem = new JMenuItem(labelText);
        this.removeItem.setMnemonic(BookmarkArb.getMnemonic(20));
        labelText = StringUtils.stripMnemonic((String)BookmarkArb.getString(21));
        this.removeAllItem = new JMenuItem(labelText);
        this.removeAllItem.setMnemonic(BookmarkArb.getMnemonic(21));
        this.sourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BookmarkPanel.this.bookmarkList.getSelectedIndex();
                if (index > -1) {
                    BookmarkPanel.this._jumpToSource(index);
                }
            }
        });
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = BookmarkPanel.this.bookmarkList.getSelectedValue();
                if (o != null) {
                    BookmarkPanel.this.bookmarkManager.removeBookmark((Bookmark)o);
                }
            }
        });
        this.removeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkPanel.this.bookmarkManager.removeAllBookmarks();
            }
        });
    }

    void setActive(boolean active) {
        Color c = active ? Colors.GRADIENT_SELECTION_DARK : Colors.TAB_PANE_BACKGROUND;
        this.setBackground(c);
    }

    private void _jumpToSource(int index) {
        Bookmark b = (Bookmark)this.bookmarkListModel.getElementAt(index);
        this.bookmarkManager.gotoBookmark(b);
    }

    private Point getPointingPoint() {
        int i = this.bookmarkList.getSelectedIndex();
        Point p = null;
        if (i != -1 && i >= this.bookmarkList.getFirstVisibleIndex() && i <= this.bookmarkList.getLastVisibleIndex()) {
            Rectangle r = this.bookmarkList.getCellBounds(i, i);
            p = new Point((int)r.getMaxX(), (int)r.getCenterY());
            SwingUtilities.convertPointToScreen(p, this.bookmarkList);
        }
        return p;
    }

    private void _showMenu(MouseEvent event) {
        Context context = new Context();
        context.setEvent((EventObject)event);
        this.contextMenu.show(context);
    }

    void rebuildList() {
        Object[] selValues = this.bookmarkList.getSelectedValues();
        this.bookmarkListModel.clear();
        for (Bookmark b : this.bookmarkManager.getAllBookmarks()) {
            this.bookmarkListModel.addElement(b);
        }
        for (Object o : selValues) {
            int i = ((DefaultListModel)this.bookmarkList.getModel()).indexOf(o);
            if (i == -1) continue;
            this.bookmarkList.addSelectionInterval(i, i);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            hasShown = true;
            this.rebuildList();
        }
    }

    public static boolean hasShown() {
        return hasShown;
    }

    public void menuWillShow(ContextMenu popup) {
        this.contextMenu.add((Component)this.sourceItem, 1.0f);
        this.contextMenu.add((Component)this.removeItem, 2.0f);
        this.contextMenu.add((Component)this.removeAllItem, 2.0f);
        String subMenuTitle = BookmarkArb.getString(29);
        JMenu accMenu = this.contextMenu.createSubMenu(StringUtils.stripMnemonic((String)subMenuTitle), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)subMenuTitle)), 0.0f, 3.0f);
        this.contextMenu.add((Component)accMenu);
        List<Integer> gotoNumberList = BookmarkAddin.getGotoActionList();
        for (int i = 0; i < 10; ++i) {
            String acc = KeyUtil.getAcceleratorTooltip((int)gotoNumberList.get(i));
            JMenuItem accItem = new JMenuItem(BookmarkArb.format(30, acc), BookmarkIcons.getIcon(i));
            accItem.putClientProperty(ASSIGN_KEY, i);
            accItem.setMnemonic(("" + i).charAt(0));
            accItem.addActionListener(this.assignNumberListener);
            accMenu.add(accItem);
        }
        String noAccString = BookmarkArb.getString(31);
        JMenuItem accItem = new JMenuItem(StringUtils.stripMnemonic((String)noAccString), OracleIcons.getIcon((String)"bookmark.png"));
        accItem.putClientProperty(ASSIGN_KEY, -1);
        accItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)noAccString));
        accItem.addActionListener(this.assignNumberListener);
        accMenu.add(accItem);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private class AssignNumberListener
    implements ActionListener {
        private AssignNumberListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = (Integer)((JMenuItem)e.getSource()).getClientProperty(BookmarkPanel.ASSIGN_KEY);
            int index = BookmarkPanel.this.bookmarkList.getSelectedIndex();
            Bookmark bookmark = (Bookmark)BookmarkPanel.this.bookmarkListModel.getElementAt(index);
            BookmarkPanel.this.bookmarkManager.changeBookmarkNumber(bookmark, i);
            BookmarkPanel.this.bookmarkList.repaint();
        }
    }

    private class PeekableList
    extends JList
    implements Peekable {
        public PeekableList(ListModel model) {
            super(model);
        }

        public Peek peek(Point p) {
            SwingUtilities.convertPointFromScreen(p, this);
            int i = this.locationToIndex(p);
            Rectangle rect = this.getCellBounds(i, i);
            if (rect.contains(p)) {
                Bookmark b = (Bookmark)BookmarkPanel.this.bookmarkListModel.get(i);
                CodePeek peek = PeekHelper.createCodePeek((JComponent)this, (String)b.getURL().getFile(), (String)PeekHelper.getPeekText((URL)b.getURL(), (int)b.getLine(), (int)5), (String)URLFileSystem.getFileName((URL)b.getURL()), (Rectangle)rect);
                PeekHelper.addHighlight((CodePeek)peek, (int)(Math.min(5, b.getLine()) - 1), (String)"caret-line-highlight");
                peek.showPeek();
                return peek;
            }
            return null;
        }
    }

    private static final class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String textToDisplay = "";
            Bookmark bookmark = (Bookmark)value;
            if (bookmark != null) {
                URL url = bookmark.getURL();
                String filename = URLFileSystem.getFileName((URL)url);
                String line = String.valueOf(bookmark.getLine());
                String description = bookmark.getDescription();
                textToDisplay = BookmarkArb.format(24, filename, line);
                textToDisplay = description == null ? BookmarkArb.format(24, filename, line) : BookmarkArb.format(25, filename, line, description);
            }
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, textToDisplay, index, isSelected, cellHasFocus);
            label.setIcon(BookmarkIcons.getIcon(bookmark.getNumber()));
            return label;
        }
    }
}

