/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkComparator;

public final class BookmarkList
implements Copyable {
    private List<Bookmark> bookmarkList = new ArrayList<Bookmark>();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int numBookmarks = this.bookmarkList.size();
        buffer.append("num bookmarks: " + numBookmarks);
        buffer.append("\n");
        for (int i = 0; i < numBookmarks; ++i) {
            Bookmark bookmark = this.bookmarkList.get(i);
            buffer.append(bookmark.toString());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] getAllBookmarks() {
        Bookmark[] allBookmarks;
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            allBookmarks = this.bookmarkList.toArray(new Bookmark[numBookmarks]);
        }
        return allBookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBookmarkCount() {
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            return this.bookmarkList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getNextBookmark(URL url, int line, boolean thisURLOnly) {
        Bookmark bookmarkFound = null;
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> listToUse = this.bookmarkList;
            if (thisURLOnly) {
                Bookmark[] urlBookmarks = this.findBookmarks(url);
                listToUse = Arrays.asList(urlBookmarks);
            }
            int startIndex = 0;
            Bookmark startBookmark = new Bookmark(url, line);
            int numBookmarks = listToUse.size();
            for (int i = 0; i < numBookmarks; ++i) {
                Bookmark bookmark = listToUse.get(i);
                if (comparator.compare(startBookmark, bookmark) >= 0) continue;
                startIndex = i;
                break;
            }
            if (numBookmarks > 0) {
                bookmarkFound = listToUse.get(startIndex);
            }
        }
        return bookmarkFound;
    }

    public Bookmark getNextBookmark(Bookmark bookmark, boolean thisURLOnly) {
        return this.getNextBookmark(bookmark.getURL(), bookmark.getLine(), thisURLOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getPreviousBookmark(URL url, int line, boolean thisURLOnly) {
        Bookmark bookmarkFound = null;
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> listToUse = this.bookmarkList;
            if (thisURLOnly) {
                Bookmark[] urlBookmarks = this.findBookmarks(url);
                listToUse = Arrays.asList(urlBookmarks);
            }
            int numBookmarks = listToUse.size();
            int startIndex = numBookmarks - 1;
            Bookmark startBookmark = new Bookmark(url, line);
            for (int i = startIndex; i >= 0; --i) {
                Bookmark bookmark = listToUse.get(i);
                if (comparator.compare(startBookmark, bookmark) <= 0) continue;
                startIndex = i;
                break;
            }
            if (numBookmarks > 0) {
                bookmarkFound = listToUse.get(startIndex);
            }
        }
        return bookmarkFound;
    }

    public Bookmark getPreviousBookmark(Bookmark bookmark, boolean thisURLOnly) {
        return this.getPreviousBookmark(bookmark.getURL(), bookmark.getLine(), thisURLOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] findBookmarks(URL url) {
        ArrayList<Bookmark> matchingList = new ArrayList<Bookmark>();
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            for (int i = 0; i < numBookmarks; ++i) {
                Bookmark bookmark = this.bookmarkList.get(i);
                if (!bookmark.matches(url)) continue;
                matchingList.add(bookmark);
            }
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new Bookmark[numMatches]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark findBookmark(URL url, int line) {
        Bookmark foundBookmark = null;
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            int numBookmarks = this.bookmarkList.size();
            for (int i = 0; i < numBookmarks; ++i) {
                Bookmark bookmark = this.bookmarkList.get(i);
                if (!bookmark.matches(url, line)) continue;
                foundBookmark = bookmark;
                break;
            }
        }
        return foundBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark addBookmark(URL url, int line) {
        Bookmark existingBookmark = this.findBookmark(url, line);
        if (existingBookmark != null) {
            return existingBookmark;
        }
        Bookmark newBookmark = new Bookmark(url, line);
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            this.insertBookmark(newBookmark);
        }
        return newBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyBookmark(Bookmark bookmark, int line) {
        boolean result;
        if (bookmark.getLine() == line) {
            return true;
        }
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            this.removeBookmark(bookmark);
            bookmark.setLine(line);
            result = this.insertBookmark(bookmark);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBookmark(Bookmark bookmark) {
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            int index = this.bookmarkList.indexOf(bookmark);
            if (index != -1) {
                this.bookmarkList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBookmarks() {
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            this.bookmarkList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertBookmark(Bookmark bookmarkToInsert) {
        BookmarkComparator comparator = BookmarkComparator.BOOKMARK_COMPARATOR;
        boolean result = true;
        List<Bookmark> list = this.bookmarkList;
        synchronized (list) {
            boolean inserted = false;
            int numBookmarks = this.bookmarkList.size();
            for (int i = 0; i < numBookmarks; ++i) {
                Bookmark bookmark = this.bookmarkList.get(i);
                int order = comparator.compare(bookmarkToInsert, bookmark);
                if (order < 0) {
                    this.bookmarkList.add(i, bookmarkToInsert);
                    inserted = true;
                    break;
                }
                if (order != 0) continue;
                inserted = true;
                result = false;
                break;
            }
            if (!inserted) {
                this.bookmarkList.add(bookmarkToInsert);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object target) {
        BookmarkList copy = target != null ? (BookmarkList)target : new BookmarkList();
        List<Bookmark> list = copy.bookmarkList;
        synchronized (list) {
            copy.bookmarkList.clear();
            copy.bookmarkList.addAll(this.bookmarkList);
        }
        return copy;
    }

    public List<Bookmark> getBookmarkList() {
        return this.bookmarkList;
    }

    public void setBookmarkList(List<Bookmark> list) {
        this.bookmarkList = list;
    }

    public Bookmark findNumberedBookmark(int number) {
        for (Bookmark bookmark : this.bookmarkList) {
            if (bookmark.getNumber() != number) continue;
            return bookmark;
        }
        return null;
    }
}

