/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.saveactions.SaveActionsArb;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class SaveActionsPlugin
implements EditorPlugin {
    private Listener listener = new Listener();
    private CodeEditor codeEditor;
    private static boolean isExecuting = false;

    public void install(BasicEditorPane editor) {
        this.codeEditor = CodeEditor.getCodeEditor(editor);
        this.codeEditor.getContext().getNode().addNodeListener((NodeListener)this.listener);
    }

    public void deinstall(BasicEditorPane editor) {
        this.codeEditor.getContext().getNode().removeNodeListener((NodeListener)this.listener);
        this.codeEditor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSaveActions() {
        block8: {
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            if (isExecuting) {
                return;
            }
            Context context = this.codeEditor.getContext();
            CommandProcessor cp = CommandProcessor.getInstance();
            try {
                isExecuting = true;
                cp.beginTrans(SaveActionsArb.getString(0));
                SaveActionsOptions saOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                Editor originalEditor = EditorManager.getEditorManager().getCurrentEditor();
                Component originalFocusComponent = FocusManager.getCurrentManager().getPermanentFocusOwner();
                for (Object name : saOptions.getActionList()) {
                    Integer cmdId = Ide.findCmdID((String)((String)name));
                    if (cmdId == null) continue;
                    this.doAction(context, cmdId);
                }
                Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                if (originalEditor == currentEditor) break block8;
                for (EditorInfo editorInfo : EditorManager.getEditorManager().getEditorsInfo()) {
                    if (editorInfo._getEditor() != originalEditor) continue;
                    EditorManager.getEditorManager().activateEditor(editorInfo);
                    editorInfo._getEditor().getGUI().requestFocus();
                    if (originalFocusComponent != null) {
                        originalFocusComponent.requestFocus();
                    }
                    break;
                }
            }
            finally {
                cp.endTrans();
                isExecuting = false;
            }
        }
    }

    private void doAction(Context context, int commandID) {
        try {
            IdeAction action = IdeAction.get((int)commandID);
            action.updateAction(context);
            if (action.isEnabled()) {
                action.performAction(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isExecuting() {
        return isExecuting;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class Listener
    extends NodeListener {
        private Listener() {
        }

        public void nodeWillBeSaved(NodeEvent e) {
            SaveActionsPlugin.this.runSaveActions();
        }
    }
}

