/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.util.Collections;
import java.util.List;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.saveactions.SaveActionsArb;
import oracle.ide.ceditor.saveactions.SaveActionsOptionsPanel;
import oracle.ide.ceditor.saveactions.SaveActionsPlugin;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.panels.SearchableNavigable;

public final class SaveActionsAddin
implements Addin,
EditorPluginsFactory {
    private static final String[] saveActions = new String[]{"CodeEditor.Format", "CodingStyleController.ORGANIZE_IMPORTS_CMD", "CodingStyleController.NARROW_IMPORTS_CMD", "CodingStyleController.WIDEN_IMPORTS_CMD", "CancelHighlightingCommand", "ojb.RemoveBookmarksFromFileCommand", "trim-whitespace"};
    public static final String SAVE_ACTION = "SaveAction";

    public void initialize() {
        CodeEditor.registerFactory(this);
        SearchableNavigable saveActionsNavigable = new SearchableNavigable(SaveActionsArb.getString(2), SaveActionsOptionsPanel.class);
        saveActionsNavigable.setSearchTags(SaveActionsArb.getString(1));
        CodeEditorAddin codeEditorAddin = (CodeEditorAddin)AddinManager.getAddinManager().getAddin(CodeEditorAddin.class);
        if (codeEditorAddin != null) {
            Navigable editorNavigable = codeEditorAddin.getEditorNavigable();
            editorNavigable.addChildNavigable((Navigable)saveActionsNavigable);
        } else {
            ClientSetting.registerUI((Navigable)saveActionsNavigable);
        }
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent e) {
                Ide.removeIdeListener((IdeListener)this);
                SaveActionsAddin.this.updateActions();
            }

            public void mainWindowOpened(IdeEvent e) {
            }

            public void mainWindowClosing(IdeEvent e) {
            }
        });
    }

    private void updateActions() {
        for (String actionString : saveActions) {
            IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)actionString));
            if (action == null || action.getValue(SAVE_ACTION) != null) continue;
            action.putValue(SAVE_ACTION, (Object)"true");
        }
    }

    @Override
    public List createPlugins(Context ideContext) {
        return Collections.singletonList(new SaveActionsPlugin());
    }
}

