/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.SaveActionsArb;
import oracle.ide.ceditor.saveactions.SaveActionsOptionsPanel;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.javatools.ui.list.EmptyListTextLayer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

final class AddActionsDialog
extends JEWTDialog {
    private JList list;
    private List<IdeAction> recommendedList;
    private SaveActionsOptionsPanel.ActionRenderer actionRenderer = new SaveActionsOptionsPanel.ActionRenderer();

    public AddActionsDialog(List<IdeAction> usedActions) {
        super((Frame)Ide.getMainWindow(), SaveActionsArb.getString(9), 7);
        this.init(usedActions);
    }

    private void init(List<IdeAction> usedActions) {
        this.list = new JList(){

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null) {
                    throw new IllegalArgumentException();
                }
                if (startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                prefix = prefix.toUpperCase();
                int increment = bias == Position.Bias.Forward ? 1 : -1;
                int index = startIndex;
                do {
                    String string;
                    Object o;
                    if ((o = model.getElementAt(index)) == null) continue;
                    if (o instanceof String) {
                        string = ((String)o).toUpperCase();
                    } else if (o instanceof IdeAction) {
                        string = (String)((IdeAction)o).getValue("Name");
                    } else {
                        string = o.toString();
                        if (string != null) {
                            string = string.toUpperCase();
                        }
                    }
                    if (string == null || !string.startsWith(prefix)) continue;
                    return index;
                } while ((index = (index + increment + max) % max) != startIndex);
                return -1;
            }
        };
        this.list.setCellRenderer(this.actionRenderer);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Window w;
                if (e.getClickCount() == 2 && AddActionsDialog.this.list.getSelectedIndex() != -1 && (w = SwingUtilities.windowForComponent(AddActionsDialog.this.list)) instanceof JEWTDialog) {
                    ((JEWTDialog)w).closeDialog(false);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddActionsDialog.this.setOKButtonEnabled(AddActionsDialog.this.list.getSelectedIndex() != -1);
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        EmptyListTextLayer emptyTextLayer = new EmptyListTextLayer(this.list, SaveActionsArb.getString(8));
        emptyTextLayer.setFont(EmptyListTextLayer.LARGE_FONT);
        JXLayer layer = new JXLayer((Component)sp, (LayerUI)emptyTextLayer);
        this.setResizable(true);
        this.setPreferredSize(325, 400);
        JPanel p = new JPanel(new BorderLayout(5, 5));
        String inst = SaveActionsArb.getString(10);
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)inst));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)inst));
        label.setLabelFor(this.list);
        p.add((Component)label, "North");
        p.add((Component)layer);
        this.setContent(p);
        HelpSystem.getHelpSystem().registerTopic((JComponent)p, "f1_idedidesetselectactions_html");
        this.loadActions(usedActions);
        final Object[] listData = this.recommendedList.toArray();
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listData.length;
            }

            @Override
            public Object getElementAt(int i) {
                return listData[i];
            }
        });
        this.setOKButtonEnabled(this.list.getSelectedIndex() != -1);
    }

    public List<IdeAction> getSelectedActions() {
        ArrayList<IdeAction> selList = new ArrayList<IdeAction>();
        for (int i : this.list.getSelectedIndices()) {
            selList.add((IdeAction)this.list.getModel().getElementAt(i));
        }
        return selList;
    }

    private void loadActions(List<IdeAction> usedActions) {
        this.recommendedList = new ArrayList<IdeAction>();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        Iterator iter = kscr.getAllContexts();
        while (iter.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iter.next();
            for (int i = 0; i < 2; ++i) {
                Set setAllActions = AddActionsDialog.getAllActions(ksc, i == 0);
                if (setAllActions == null) continue;
                for (IdeAction action : setAllActions) {
                    String saveAction = (String)action.getValue("SaveAction");
                    if (saveAction == null || !"true".equalsIgnoreCase(saveAction) || usedActions.contains(action)) continue;
                    this.recommendedList.add(action);
                }
            }
        }
        Collections.sort(this.recommendedList, new ActionComparator());
    }

    private static Set getAllActions(KeyStrokeContext ksc, boolean global) {
        Set allActions = ksc.getAllActions(global);
        if (allActions == null || allActions.remove(null)) {
            // empty if block
        }
        return allActions;
    }

    private class ActionComparator
    implements Comparator {
        private ActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            IdeAction a1 = (IdeAction)o1;
            IdeAction a2 = (IdeAction)o2;
            if (a1 == a2) {
                return 0;
            }
            return ((String)a1.getValue("Name")).compareTo((String)a2.getValue("Name"));
        }
    }
}

