/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.UndoOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class UndoOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JSlider slider_editMergeCount;
    private JLabel label_editCount;
    private JCheckBox checkbox_mergeTypedInsert;
    private JCheckBox checkbox_mergeTypedReplace;
    private JCheckBox checkbox_mergeDeleteNext;
    private JCheckBox checkbox_mergeDeletePrevious;
    private JCheckBox checkbox_enableNavigationUndo;
    private JSlider slider_navigationMergeCount;
    private JLabel label_navigationCount;

    public UndoOptionsPanel() {
        this.setHelpID("f1_idedidesetundo_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        UndoOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        UndoOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private UndoOptions findOptions(TraversableContext tc) {
        UndoOptions options = UndoOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        UndoOptions options = this.findOptions(tc);
        UndoOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(UndoOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        int editMergeCount = options.getEditMergeCount();
        properties.putProperty("edit-merge-count", (Object)new Integer(editMergeCount));
        boolean mergeTypedInsert = options.getMergeTypedInsert();
        properties.putProperty("merge-typed-insert", (Object)(mergeTypedInsert ? Boolean.TRUE : Boolean.FALSE));
        boolean mergeTypedReplace = options.getMergeTypedReplace();
        properties.putProperty("merge-typed-replace", (Object)(mergeTypedReplace ? Boolean.TRUE : Boolean.FALSE));
        boolean mergeDeleteNext = options.getMergeDeleteNext();
        properties.putProperty("merge-delete-next", (Object)(mergeDeleteNext ? Boolean.TRUE : Boolean.FALSE));
        boolean mergeDeletePrevious = options.getMergeDeletePrevious();
        properties.putProperty("merge-delete-previous", (Object)(mergeDeletePrevious ? Boolean.TRUE : Boolean.FALSE));
        boolean enableNavigationUndo = options.getEnableNavigationUndo();
        properties.putProperty("undo-navigation", (Object)(enableNavigationUndo ? Boolean.TRUE : Boolean.FALSE));
        int navigationMergeCount = options.getNavigationMergeCount();
        properties.putProperty("navigation-merge-count", (Object)new Integer(navigationMergeCount));
        properties.putProperty("merge-navigation", (Object)Boolean.TRUE);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof JSlider) {
            this.updateSliderText((JSlider)source);
        }
    }

    private void updateSliderText(JSlider slider) {
        int value = slider.getValue();
        if (slider == this.slider_editMergeCount) {
            int template = value == 1 ? 75 : 76;
            String text = OptionsArb.format(template, Integer.toString(value));
            this.label_editCount.setText(text);
            this.slider_editMergeCount.setToolTipText(text);
            boolean enable = value > 1;
            this.checkbox_mergeTypedInsert.setEnabled(enable);
            this.checkbox_mergeTypedReplace.setEnabled(enable);
            this.checkbox_mergeDeleteNext.setEnabled(enable);
            this.checkbox_mergeDeletePrevious.setEnabled(enable);
        } else if (slider == this.slider_navigationMergeCount) {
            int template = value == 1 ? 85 : 86;
            String text = OptionsArb.format(template, Integer.toString(value));
            this.label_navigationCount.setText(text);
            this.slider_navigationMergeCount.setToolTipText(text);
        }
    }

    void loadSettingsFrom(UndoOptions options) {
        int editMergeCount = options.getEditMergeCount();
        boolean mergeTypedInsert = options.getMergeTypedInsert();
        boolean mergeTypedReplace = options.getMergeTypedReplace();
        boolean mergeDeleteNext = options.getMergeDeleteNext();
        boolean mergeDeletePrevious = options.getMergeDeletePrevious();
        boolean enableNavigationUndo = options.getEnableNavigationUndo();
        int navigationMergeCount = options.getNavigationMergeCount();
        this.slider_editMergeCount.setValue(editMergeCount);
        this.checkbox_mergeTypedInsert.setSelected(mergeTypedInsert);
        this.checkbox_mergeTypedReplace.setSelected(mergeTypedReplace);
        this.checkbox_mergeDeleteNext.setSelected(mergeDeleteNext);
        this.checkbox_mergeDeletePrevious.setSelected(mergeDeletePrevious);
        this.checkbox_enableNavigationUndo.setSelected(enableNavigationUndo);
        this.slider_navigationMergeCount.setValue(navigationMergeCount);
    }

    void saveSettingsTo(UndoOptions options) {
        int editMergeCount = this.slider_editMergeCount.getValue();
        boolean mergeTypedInsert = this.checkbox_mergeTypedInsert.isSelected();
        boolean mergeTypedReplace = this.checkbox_mergeTypedReplace.isSelected();
        boolean mergeDeleteNext = this.checkbox_mergeDeleteNext.isSelected();
        boolean mergeDeletePrevious = this.checkbox_mergeDeletePrevious.isSelected();
        boolean enableNavigationUndo = this.checkbox_enableNavigationUndo.isSelected();
        int navigationMergeCount = this.slider_navigationMergeCount.getValue();
        options.setEditMergeCount(editMergeCount);
        options.setMergeTypedInsert(mergeTypedInsert);
        options.setMergeTypedReplace(mergeTypedReplace);
        options.setMergeDeleteNext(mergeDeleteNext);
        options.setMergeDeletePrevious(mergeDeletePrevious);
        options.setEnableNavigationUndo(enableNavigationUndo);
        options.setNavigationMergeCount(navigationMergeCount);
    }

    private void initializeComponent() {
        String editMergeCountText = OptionsArb.getString(74);
        JLabel label_editMergeCount = new JLabel();
        this.slider_editMergeCount = new JSlider(1, 40, 40);
        this.slider_editMergeCount.addChangeListener(this);
        ResourceUtils.resLabel((JLabel)label_editMergeCount, (Component)this.slider_editMergeCount, (String)editMergeCountText);
        this.label_editCount = new JLabel();
        String beginScale = OptionsArb.getString(77);
        String endScale = OptionsArb.getString(78);
        JLabel label_minValue = new JLabel(beginScale);
        JLabel label_maxValue = new JLabel(endScale);
        this.slider_editMergeCount.setPaintLabels(false);
        this.slider_editMergeCount.setPaintTicks(true);
        this.slider_editMergeCount.setMajorTickSpacing(10);
        this.slider_editMergeCount.setMinorTickSpacing(1);
        this.slider_editMergeCount.setSnapToTicks(true);
        String mergeTypedInsertText = OptionsArb.getString(79);
        this.checkbox_mergeTypedInsert = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_mergeTypedInsert, (String)mergeTypedInsertText);
        String mergeTypedReplaceText = OptionsArb.getString(80);
        this.checkbox_mergeTypedReplace = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_mergeTypedReplace, (String)mergeTypedReplaceText);
        String mergeDeleteNextText = OptionsArb.getString(81);
        this.checkbox_mergeDeleteNext = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_mergeDeleteNext, (String)mergeDeleteNextText);
        String mergeDeletePreviousText = OptionsArb.getString(82);
        this.checkbox_mergeDeletePrevious = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_mergeDeletePrevious, (String)mergeDeletePreviousText);
        String enableNavigationUndoText = OptionsArb.getString(83);
        this.checkbox_enableNavigationUndo = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_enableNavigationUndo, (String)enableNavigationUndoText);
        String navigationMergeCountText = OptionsArb.getString(84);
        JLabel label_navigationMergeCount = new JLabel();
        this.slider_navigationMergeCount = new JSlider(1, 40, 1);
        this.slider_navigationMergeCount.addChangeListener(this);
        ResourceUtils.resLabel((JLabel)label_navigationMergeCount, (Component)this.slider_navigationMergeCount, (String)navigationMergeCountText);
        this.label_navigationCount = new JLabel();
        JLabel label_navigationsMinValue = new JLabel(beginScale);
        JLabel label_navigationsMaxValue = new JLabel(endScale);
        this.slider_navigationMergeCount.setPaintLabels(false);
        this.slider_navigationMergeCount.setPaintTicks(true);
        this.slider_navigationMergeCount.setMajorTickSpacing(10);
        this.slider_navigationMergeCount.setMinorTickSpacing(1);
        this.slider_navigationMergeCount.setSnapToTicks(true);
        Component[] dependents = new Component[]{this.slider_navigationMergeCount, label_navigationMergeCount, this.label_navigationCount, label_navigationsMinValue, label_navigationsMaxValue};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_enableNavigationUndo, dependents);
        this.updateSliderText(this.slider_editMergeCount);
        this.updateSliderText(this.slider_navigationMergeCount);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        Insets indentedInsets = new Insets(0, 18, 5, 0);
        Insets headerInsets = new Insets(0, 0, 7, 0);
        JPanel editMergePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, headerInsets, 0, 0);
        editMergePanel.add((Component)label_editMergeCount, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        editMergePanel.add((Component)label_minValue, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        editMergePanel.add((Component)this.slider_editMergeCount, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        editMergePanel.add((Component)label_maxValue, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        editMergePanel.add((Component)this.label_editCount, constraints);
        JPanel navigationMergePanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, headerInsets, 0, 0);
        navigationMergePanel.add((Component)label_navigationMergeCount, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        navigationMergePanel.add((Component)label_navigationsMinValue, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        navigationMergePanel.add((Component)this.slider_navigationMergeCount, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        navigationMergePanel.add((Component)label_navigationsMaxValue, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 0, 0);
        navigationMergePanel.add((Component)this.label_navigationCount, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(editMergePanel, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(this.checkbox_mergeTypedInsert, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(this.checkbox_mergeTypedReplace, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(this.checkbox_mergeDeleteNext, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(this.checkbox_mergeDeletePrevious, constraints);
        Component strut = Box.createVerticalStrut(15);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(strut, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.checkbox_enableNavigationUndo, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        this.add(navigationMergePanel, constraints);
        Component glue = Box.createVerticalGlue();
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(glue, constraints);
    }
}

