/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.S2Style;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.ceditor.options.SyntaxComparator;
import oracle.ide.ceditor.options.SyntaxHighlight;
import oracle.ide.ceditor.options.SyntaxSchemes;
import oracle.ide.ceditor.options.SyntaxStyle;
import oracle.ide.config.DTCache;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.SortedListModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.util.Copyable;

public final class SyntaxColorsOptionsPanel
extends DefaultTraversablePanel
implements ActionListener,
ApplyListener,
CaretListener,
ChangeListener,
ItemListener,
ListSelectionListener,
PropertyChangeListener,
ToolTipProvider {
    private static final String DEFAULT_SCHEME = "Default";
    private static final String DEFAULT_SCHEME_FILE = "default_schemes.xml";
    private SyntaxSchemes schemeMap;
    private CardPanel panel_card;
    private static final String STYLE_CARD = "style";
    private static final String HIGHLIGHT_CARD = "highlight";
    private JComboBox comboBox_scheme;
    private JButton button_saveAs;
    private JButton button_delete;
    private JComboBox comboBox_category;
    private JList list_styles;
    private JLabel label_styleSample;
    private JTextField field_styleSample;
    private JLabel label_foreground;
    private CustomColorChoice colorChoice_specifyForeground;
    private JLabel label_background;
    private CustomColorChoice colorChoice_specifyBackground;
    private JLabel label_fontStyle;
    private JComboBox comboBox_fontStyle;
    private ComboBoxModel cbModel_extended;
    private ComboBoxModel cbModel_base;
    private JLabel label_highlightSample;
    private UnderlineField field_highlightSample;
    private JCheckBox checkBox_enableHighlight;
    private JLabel label_priority;
    private JSlider slider_priority;
    private JLabel label_priorityText;
    private JLabel label_highlightFG;
    private CustomColorChoice colorChoice_highlightFG;
    private JLabel label_highlightBG;
    private CustomColorChoice colorChoice_highlightBG;
    private JLabel label_highlightFont;
    private JComboBox comboBox_highlightFont;
    private ComboBoxModel cbModel_highlight;
    private JLabel label_underlineStyle;
    private ComboBoxModel cbModel_underline;
    private JComboBox comboBox_underlineStyle;
    private JLabel label_underlineColor;
    private CustomColorChoice colorChoice_underlineColor;
    private JScrollPane scrollPane_sampleText;
    private JLabel label_sampleText;
    private BasicEditorPane editor_sampleText;
    private StyleRegistry styleRegistry;
    private HighlightRegistry highlightRegistry;
    private HighlightLayer highlightLayer;
    private BaseStyle editedStyle;
    private HighlightStyle editedHighlight;
    private DefaultListModel styleListModel;
    private static final String FONT_STYLE_USE_DEFAULT = OptionsArb.getString(114);
    private static final String FONT_STYLE_NORMAL = OptionsArb.getString(115);
    private static final String FONT_STYLE_BOLD = OptionsArb.getString(116);
    private static final String FONT_STYLE_ITALIC = OptionsArb.getString(117);
    private static final String FONT_STYLE_BOLDITALIC = OptionsArb.getString(118);
    private static final String CATEGORY_ALL = OptionsArb.getString(98);
    private static final String UNDERLINE_STYLE_NONE = OptionsArb.getString(121);
    private static final String UNDERLINE_STYLE_SINGLE = OptionsArb.getString(124);
    private static final String UNDERLINE_STYLE_DOUBLE = OptionsArb.getString(125);
    private static final String UNDERLINE_STYLE_SINGLE_DOTTED = OptionsArb.getString(126);
    private static final String UNDERLINE_STYLE_DOUBLE_DOTTED = OptionsArb.getString(127);
    private static final String UNDERLINE_STYLE_WAVY = OptionsArb.getString(128);
    private static final String SEPARATOR_STYLE_SINGLE = OptionsArb.getString(129);
    private static final String SEPARATOR_STYLE_DOUBLE = OptionsArb.getString(130);
    private static final String SEPARATOR_STYLE_SINGLE_DOTTED = OptionsArb.getString(131);
    private static final String SEPARATOR_STYLE_DOUBLE_DOTTED = OptionsArb.getString(132);
    private static final String SEPARATOR_STYLE_PERFORATED = OptionsArb.getString(133);
    private static final String STRIKETHRU_STYLE_SINGLE = OptionsArb.getString(122);
    private static final String STRIKETHRU_STYLE_DOUBLE = OptionsArb.getString(123);
    private static final String SCHEME_CUSTOM = " ";
    private static boolean SHOW_PRIORITY_CONTROLS = false;
    private boolean inUpdate;

    public SyntaxColorsOptionsPanel() {
        this.setHelpID("f1_idedidesetsyntaxcolors_html");
        this.setLayout(new GridBagLayout());
        this.inUpdate = false;
        DTCache dtCache = Ide.getDTCache();
        this.schemeMap = (SyntaxSchemes)dtCache.getData("SyntaxSchemes");
        if (this.schemeMap == null) {
            this.schemeMap = SyntaxColorsOptionsPanel.loadDefaultSchemes();
            dtCache.putData("SyntaxSchemes", (Copyable)this.schemeMap);
        }
        this.initializeComponent();
    }

    private static SyntaxSchemes loadDefaultSchemes() {
        SyntaxSchemes schemes = new SyntaxSchemes();
        try {
            URL url = SyntaxColorsOptionsPanel.class.getResource(DEFAULT_SCHEME_FILE);
            Object2Dom o2d = Object2Dom.newInstance();
            SyntaxSchemes defaultSchemes = (SyntaxSchemes)o2d.toObject(url);
            defaultSchemes.copyTo(schemes);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return schemes;
    }

    private static void saveSchemes(SyntaxSchemes schemes) {
        try {
            File dest = new File(DEFAULT_SCHEME_FILE);
            URL url = URLFactory.newFileURL((File)dest);
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(XMLUtil.toNamespaceURI((String)"default-syntax-schemes"));
            o2d.toDocument((Object)schemes, "schemes", url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onEntry(TraversableContext tc) {
        SyntaxColorsOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
        FontSizeOptions fontOptions = FontSizeOptions.getInstance(tc.getPropertyStorage());
        String fontFamily = fontOptions.getFontFamily();
        int fontSize = fontOptions.getFontSize();
        this.editor_sampleText.setBaseFont(fontFamily, fontSize);
        FontHelper fontHelper = this.editor_sampleText.getFontHelper();
        Font baseFont = fontHelper.getBaseFont();
        this.field_styleSample.setFont(baseFont);
        this.field_highlightSample.setFont(baseFont);
        this.updateStyleSample();
        this.updateHighlightSample();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        SyntaxColorsOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private SyntaxColorsOptions findOptions(TraversableContext tc) {
        SyntaxColorsOptions options = SyntaxColorsOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        SyntaxColorsOptions options = this.findOptions(tc);
        SyntaxColorsOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(SyntaxColorsOptions options) {
        List styleList;
        EditorProperties properties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = properties.getStyleRegistry();
        StyleRegistry styleRegistryCopy = (StyleRegistry)styleRegistry.clone();
        HighlightRegistry highlightRegistry = properties.getHighlightRegistry();
        HighlightRegistry highlightRegistryCopy = (HighlightRegistry)highlightRegistry.clone();
        if (options.getFirstTime()) {
            options.setFirstTime(false);
            DTCache dtCache = Ide.getDTCache();
            SyntaxSchemes schemeMap = SyntaxColorsOptionsPanel.loadDefaultSchemes();
            dtCache.putData("SyntaxSchemes", (Copyable)schemeMap);
            List styleList2 = schemeMap.getScheme(DEFAULT_SCHEME);
            ArrayList<Object> copyList = new ArrayList<Object>();
            for (Copyable style : styleList2) {
                Object copy = style.copyTo(null);
                copyList.add(copy);
            }
            options.setStyleList(copyList);
            options.setSelectedScheme(DEFAULT_SCHEME);
        }
        if (!options.getMigrated()) {
            options.setMigrated(true);
            styleList = options.getStyleList();
            List migratedList = SyntaxColorsOptionsPanel.migrateStyleList(styleList);
            options.setStyleList(migratedList);
            DTCache dtCache = Ide.getDTCache();
            SyntaxSchemes currentSchemes = (SyntaxSchemes)dtCache.getData("SyntaxSchemes");
            if (currentSchemes != null) {
                SyntaxSchemes migratedSchemes = new SyntaxSchemes();
                String[] names = currentSchemes.getSchemeNames();
                int numSchemes = names != null ? names.length : 0;
                for (int i = 0; i < numSchemes; ++i) {
                    String schemeName = names[i];
                    styleList = currentSchemes.getScheme(schemeName);
                    migratedList = SyntaxColorsOptionsPanel.migrateStyleList(styleList);
                    migratedSchemes.putScheme(schemeName, migratedList);
                }
                dtCache.putData("SyntaxSchemes", (Copyable)migratedSchemes);
            }
        }
        styleList = options.getStyleList();
        int numStyles = styleList.size();
        for (int i = 0; i < numStyles; ++i) {
            Object style = styleList.get(i);
            if (style instanceof SyntaxStyle) {
                SyntaxStyle syntaxStyle = (SyntaxStyle)((Object)style);
                SyntaxColorsOptionsPanel.copySyntaxStyleToStyleRegistry(syntaxStyle, styleRegistryCopy);
                continue;
            }
            if (!(style instanceof SyntaxHighlight)) continue;
            SyntaxHighlight syntaxHighlight = (SyntaxHighlight)((Object)style);
            SyntaxColorsOptionsPanel.copySyntaxHighlightToHighlightRegistry(syntaxHighlight, highlightRegistryCopy);
        }
        properties.setStyleRegistry(styleRegistryCopy);
        properties.setHighlightRegistry(highlightRegistryCopy);
    }

    private static List migrateStyleList(List styleList) {
        int count = styleList.size();
        ArrayList<Copyable> migratedList = new ArrayList<Copyable>(count);
        for (int i = 0; i < count; ++i) {
            Copyable style = (Copyable)styleList.get(i);
            if (style == null) continue;
            if (style instanceof SyntaxHighlight) {
                style = (Copyable)style.copyTo((Object)new S2Highlight());
            } else if (style instanceof SyntaxStyle) {
                style = (Copyable)style.copyTo((Object)new S2Style());
            }
            migratedList.add(style);
        }
        return migratedList;
    }

    void loadSettingsFrom(SyntaxColorsOptions options) {
        List styleList = options.getStyleList();
        SyntaxColorsOptionsPanel.copyStyleListToRegistries(styleList, this.styleRegistry, this.highlightRegistry);
        String selectedScheme = options.getSelectedScheme();
        if (selectedScheme == null) {
            selectedScheme = SCHEME_CUSTOM;
        }
        this.selectSchemeName(selectedScheme);
    }

    void saveSettingsTo(SyntaxColorsOptions options) throws TraversalException {
        List styleList = options.getStyleList();
        SyntaxColorsOptionsPanel.copyRegistriesToStyleList(this.styleRegistry, this.highlightRegistry, styleList);
        options.setStyleList(styleList);
        String selectedScheme = (String)this.comboBox_scheme.getSelectedItem();
        options.setSelectedScheme(selectedScheme);
    }

    private static void copyStyleListToRegistries(List styleList, StyleRegistry styleRegistry, HighlightRegistry highlightRegistry) {
        String lfStyleName = "base-lf-style";
        int numStyles = styleList.size();
        for (int i = 0; i < numStyles; ++i) {
            Object style = styleList.get(i);
            if (style == null) continue;
            if (style instanceof SyntaxStyle) {
                SyntaxStyle syntaxStyle = (SyntaxStyle)((Object)style);
                if (syntaxStyle.getStyleName().equals(lfStyleName)) continue;
                SyntaxColorsOptionsPanel.copySyntaxStyleToStyleRegistry(syntaxStyle, styleRegistry);
                continue;
            }
            if (!(style instanceof SyntaxHighlight)) continue;
            SyntaxHighlight syntaxHighlight = (SyntaxHighlight)((Object)style);
            SyntaxColorsOptionsPanel.copySyntaxHighlightToHighlightRegistry(syntaxHighlight, highlightRegistry);
        }
    }

    private static void copyRegistriesToStyleList(StyleRegistry styleRegistry, HighlightRegistry highlightRegistry, List styleList) {
        String lfStyleName = "base-lf-style";
        Iterator iterator = styleRegistry.getStyleIterator();
        while (iterator.hasNext()) {
            BaseStyle baseStyle = (BaseStyle)iterator.next();
            if (baseStyle == null || baseStyle.getName().equals(lfStyleName)) continue;
            S2Style syntaxStyle = new S2Style();
            SyntaxColorsOptionsPanel.copyBaseStyleToSyntaxStyle(baseStyle, syntaxStyle);
            SyntaxColorsOptionsPanel.addSyntaxStyleToStyleList(syntaxStyle, styleList);
        }
        iterator = highlightRegistry.getStyleIterator();
        while (iterator.hasNext()) {
            HighlightStyle highlightStyle = (HighlightStyle)iterator.next();
            S2Highlight syntaxHighlight = new S2Highlight();
            SyntaxColorsOptionsPanel.copyHighlightStyleToSyntaxHighlight(highlightStyle, syntaxHighlight);
            SyntaxColorsOptionsPanel.addSyntaxHighlightToStyleList(syntaxHighlight, styleList);
        }
    }

    private static void copyHighlightStyleToSyntaxHighlight(HighlightStyle fromHighlightStyle, SyntaxHighlight toSyntaxHighlight) {
        String styleName = fromHighlightStyle.getName();
        Color fgColor = fromHighlightStyle.getForegroundColor();
        Color bgColor = fromHighlightStyle.getBackgroundColor();
        int priority = fromHighlightStyle.getPriority();
        boolean enabled = fromHighlightStyle.getEnabled();
        int fontStyle = fromHighlightStyle.getFontStyle();
        UnderlinePainter painter = fromHighlightStyle.getUnderlinePainter();
        int painterIndex = HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)painter);
        Color underlineColor = fromHighlightStyle.getUnderlineColor();
        toSyntaxHighlight.setStyleName(styleName);
        toSyntaxHighlight.setEnabled(enabled);
        toSyntaxHighlight.setPriority(priority);
        boolean useFG = fgColor != null;
        int saveFG = fgColor != null ? fgColor.getRGB() : 0;
        toSyntaxHighlight.setUseFG(useFG);
        toSyntaxHighlight.setForegroundRGB(saveFG);
        boolean useBG = bgColor != null;
        int saveBG = bgColor != null ? bgColor.getRGB() : 0;
        toSyntaxHighlight.setUseBG(useBG);
        toSyntaxHighlight.setBackgroundRGB(saveBG);
        toSyntaxHighlight.setFontStyle(fontStyle);
        toSyntaxHighlight.setUnderlineStyle(painterIndex);
        int saveUC = underlineColor != null ? underlineColor.getRGB() : 0;
        toSyntaxHighlight.setUnderlineRGB(saveUC);
    }

    private static void copyBaseStyleToSyntaxStyle(BaseStyle fromBaseStyle, SyntaxStyle toSyntaxStyle) {
        String styleName = fromBaseStyle.getName();
        Color fgColor = fromBaseStyle.getForegroundColor();
        boolean useFgColor = fromBaseStyle.getUsesParentForegroundColor();
        Color bgColor = fromBaseStyle.getBackgroundColor();
        boolean useBgColor = fromBaseStyle.getUsesParentBackgroundColor();
        int fontStyle = fromBaseStyle.getFontStyle();
        boolean useFontStyle = fromBaseStyle.getUsesParentFontStyle();
        toSyntaxStyle.setStyleName(styleName);
        toSyntaxStyle.setForegroundRGB(fgColor.getRGB());
        toSyntaxStyle.setUseParentFG(useFgColor);
        toSyntaxStyle.setBackgroundRGB(bgColor.getRGB());
        toSyntaxStyle.setUseParentBG(useBgColor);
        toSyntaxStyle.setFontStyle(fontStyle);
        toSyntaxStyle.setUseParentFontStyle(useFontStyle);
    }

    private static void copySyntaxHighlightToHighlightRegistry(SyntaxHighlight fromSyntaxHighlight, HighlightRegistry destRegistry) {
        String styleName = fromSyntaxHighlight.getStyleName();
        boolean useFG = fromSyntaxHighlight.getUseFG();
        Color fgColor = useFG ? new Color(fromSyntaxHighlight.getForegroundRGB(), true) : null;
        boolean useBG = fromSyntaxHighlight.getUseBG();
        Color bgColor = useBG ? new Color(fromSyntaxHighlight.getBackgroundRGB(), true) : null;
        int priority = fromSyntaxHighlight.getPriority();
        boolean enabled = fromSyntaxHighlight.getEnabled();
        int fontStyle = fromSyntaxHighlight.getFontStyle();
        int underlineStyle = fromSyntaxHighlight.getUnderlineStyle();
        int underlineRGB = fromSyntaxHighlight.getUnderlineRGB();
        Color underlineColor = underlineRGB == 0 ? null : new Color(underlineRGB, true);
        destRegistry.modifyStyle(styleName, enabled, priority, fgColor, bgColor, fontStyle, underlineStyle, underlineColor);
    }

    private static void copySyntaxStyleToStyleRegistry(SyntaxStyle fromSyntaxStyle, StyleRegistry destRegistry) {
        String styleName = fromSyntaxStyle.getStyleName();
        Color fgColor = new Color(fromSyntaxStyle.getForegroundRGB());
        boolean useFgColor = fromSyntaxStyle.getUseParentFG();
        Color bgColor = new Color(fromSyntaxStyle.getBackgroundRGB());
        boolean useBgColor = fromSyntaxStyle.getUseParentBG();
        int fontStyle = fromSyntaxStyle.getFontStyle();
        boolean useFontStyle = fromSyntaxStyle.getUseParentFontStyle();
        destRegistry.modifyStyle(styleName, useFgColor, fgColor, useBgColor, bgColor, useFontStyle, fontStyle);
    }

    private static void addSyntaxHighlightToStyleList(SyntaxHighlight syntaxHighlight, List styleList) {
        if (syntaxHighlight == null) {
            return;
        }
        int index = SyntaxColorsOptionsPanel.findSyntaxHighlightInStyleList(syntaxHighlight, styleList);
        if (index != -1) {
            SyntaxHighlight destStyle = (SyntaxHighlight)((Object)styleList.get(index));
            syntaxHighlight.copyTo((Object)destStyle);
        } else {
            styleList.add(syntaxHighlight);
        }
    }

    private static void addSyntaxStyleToStyleList(SyntaxStyle syntaxStyle, List styleList) {
        if (syntaxStyle == null) {
            return;
        }
        int index = SyntaxColorsOptionsPanel.findSyntaxStyleInStyleList(syntaxStyle, styleList);
        if (index != -1) {
            SyntaxStyle destStyle = (SyntaxStyle)((Object)styleList.get(index));
            syntaxStyle.copyTo((Object)destStyle);
        } else {
            styleList.add(syntaxStyle);
        }
    }

    private static int findSyntaxHighlightInStyleList(SyntaxHighlight syntaxHighlight, List styleList) {
        String styleName = syntaxHighlight.getStyleName();
        int numStyles = styleList.size();
        for (int i = 0; i < numStyles; ++i) {
            SyntaxHighlight checkStyle;
            Object style = styleList.get(i);
            if (!(style instanceof SyntaxHighlight) || !(checkStyle = (SyntaxHighlight)((Object)style)).getStyleName().equals(styleName)) continue;
            return i;
        }
        return -1;
    }

    private static int findSyntaxStyleInStyleList(SyntaxStyle syntaxStyle, List styleList) {
        String styleName = syntaxStyle.getStyleName();
        int numStyles = styleList.size();
        for (int i = 0; i < numStyles; ++i) {
            SyntaxStyle checkStyle;
            Object style = styleList.get(i);
            if (!(style instanceof SyntaxStyle) || !(checkStyle = (SyntaxStyle)((Object)style)).getStyleName().equals(styleName)) continue;
            return i;
        }
        return -1;
    }

    private ComboBoxModel createSchemeModel() {
        Object[] schemeNames = this.schemeMap.getSchemeNames();
        Arrays.sort(schemeNames, String.CASE_INSENSITIVE_ORDER);
        NonNullableComboBoxModel model = new NonNullableComboBoxModel(schemeNames);
        return model;
    }

    private void addSchemeName(String schemeName) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        if (model.getIndexOf(schemeName) == -1) {
            int numItems;
            int insertPoint = numItems = model.getSize();
            for (int i = 0; i < numItems; ++i) {
                String item = (String)model.getElementAt(i);
                if (item.equals(SCHEME_CUSTOM) || item.compareToIgnoreCase(schemeName) <= 0) continue;
                insertPoint = i;
                break;
            }
            this.beginUIUpdate();
            model.insertElementAt(schemeName, insertPoint);
            this.endUIUpdate();
        }
        this.selectSchemeName(schemeName);
    }

    private void selectSchemeName(String selectedScheme) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        if (model.getIndexOf(selectedScheme) == -1 || selectedScheme == SCHEME_CUSTOM) {
            if (model.getIndexOf(SCHEME_CUSTOM) == -1) {
                this.beginUIUpdate();
                model.insertElementAt(SCHEME_CUSTOM, 0);
                this.endUIUpdate();
            }
            this.comboBox_scheme.setSelectedItem(SCHEME_CUSTOM);
            return;
        }
        this.comboBox_scheme.setSelectedItem(selectedScheme);
        int index = model.getIndexOf(SCHEME_CUSTOM);
        if (index != -1) {
            this.beginUIUpdate();
            model.removeElementAt(index);
            this.endUIUpdate();
        }
    }

    private void deleteSchemeName(String schemeName) {
        this.selectSchemeName(SCHEME_CUSTOM);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        int index = model.getIndexOf(schemeName);
        if (index != -1) {
            this.beginUIUpdate();
            model.removeElementAt(index);
            this.endUIUpdate();
        }
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, title, 2);
    }

    private void initializeComponent() {
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        ComboBoxModel schemeModel = this.createSchemeModel();
        this.comboBox_scheme = new JComboBox(schemeModel);
        this.comboBox_scheme.setEditable(false);
        this.comboBox_scheme.addItemListener(this);
        String schemeLabelText = OptionsArb.getString(94);
        JLabel label_scheme = new JLabel();
        ResourceUtils.resLabel((JLabel)label_scheme, (Component)this.comboBox_scheme, (String)schemeLabelText);
        String saveAsText = OptionsArb.getString(95);
        this.button_saveAs = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_saveAs, (String)saveAsText);
        this.button_saveAs.addActionListener(this);
        String deleteText = OptionsArb.getString(96);
        this.button_delete = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_delete, (String)deleteText);
        this.button_delete.addActionListener(this);
        JPanel panel_scheme = new JPanel(new BorderLayout(10, 10));
        panel_scheme.add((Component)label_scheme, "Before");
        panel_scheme.add(this.comboBox_scheme);
        ButtonBar buttonBar = new ButtonBar(0);
        buttonBar.add((Component)this.button_saveAs);
        buttonBar.add((Component)this.button_delete);
        panel_scheme.add((Component)buttonBar, "After");
        panel_scheme.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ArrayList categoryList = new ArrayList();
        Iterator categoryIterator = LanguageModule.getLanguageIterator();
        while (categoryIterator.hasNext()) {
            categoryList.add(categoryIterator.next());
        }
        categoryList.add(CATEGORY_ALL);
        Collections.sort(categoryList, new SyntaxComparator());
        Object[] categoryArray = categoryList.toArray();
        NonNullableComboBoxModel categoryModel = new NonNullableComboBoxModel(categoryArray);
        this.comboBox_category = new JComboBox(categoryModel);
        this.comboBox_category.setEditable(false);
        this.comboBox_category.addItemListener(this);
        String categoryLabelText = OptionsArb.getString(97);
        JLabel label_category = new JLabel();
        ResourceUtils.resLabel((JLabel)label_category, (Component)this.comboBox_category, (String)categoryLabelText);
        JPanel panel_category = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 17, 0, emptyInsets, 0, 0);
        panel_category.add((Component)label_category, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.7, 1.0, 17, 2, emptyInsets, 0, 0);
        panel_category.add((Component)this.comboBox_category, constraints);
        this.list_styles = new JList();
        ListSelectionModel selectionModel = this.list_styles.getSelectionModel();
        selectionModel.setSelectionMode(0);
        JScrollPane scrollPane_styles = new JScrollPane(this.list_styles);
        this.list_styles.addListSelectionListener(this);
        String stylesLabelText = OptionsArb.getString(99);
        JLabel label_styles = new JLabel();
        ResourceUtils.resLabel((JLabel)label_styles, (Component)this.list_styles, (String)stylesLabelText);
        JPanel panel_styles = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_styles.add((Component)label_styles, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_styles.add((Component)scrollPane_styles, constraints);
        String styleSampleLabelText = OptionsArb.getString(100);
        String styleSampleFieldText = OptionsArb.getString(101);
        this.label_styleSample = new JLabel();
        this.field_styleSample = new JTextField(styleSampleFieldText);
        this.field_styleSample.setCaretPosition(0);
        ResourceUtils.resLabel((JLabel)this.label_styleSample, (Component)this.field_styleSample, (String)styleSampleLabelText);
        String fontStyleLabelText = OptionsArb.getString(102);
        this.label_fontStyle = new JLabel();
        Object[] extendedFontStyles = new String[]{FONT_STYLE_USE_DEFAULT, FONT_STYLE_NORMAL, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
        Object[] baseFontStyles = new String[]{FONT_STYLE_NORMAL};
        this.cbModel_extended = new NonNullableComboBoxModel(extendedFontStyles);
        this.cbModel_base = new NonNullableComboBoxModel(baseFontStyles);
        this.comboBox_fontStyle = new JComboBox(this.cbModel_extended);
        this.comboBox_fontStyle.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_fontStyle, (Component)this.comboBox_fontStyle, (String)fontStyleLabelText);
        String foregroundLabelText = OptionsArb.getString(103);
        this.label_foreground = new JLabel();
        this.colorChoice_specifyForeground = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)this.label_foreground, (Component)this.colorChoice_specifyForeground, (String)foregroundLabelText);
        this.colorChoice_specifyForeground.addPropertyChangeListener((PropertyChangeListener)this);
        String backgroundLabelText = OptionsArb.getString(104);
        this.label_background = new JLabel(backgroundLabelText);
        this.colorChoice_specifyBackground = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)this.label_background, (Component)this.colorChoice_specifyBackground, (String)backgroundLabelText);
        this.colorChoice_specifyBackground.addPropertyChangeListener((PropertyChangeListener)this);
        JPanel panel_colors = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.label_styleSample, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 17, 2, emptyInsets, 0, 0);
        panel_colors.add((Component)this.field_styleSample, constraints);
        constraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_colors.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.label_fontStyle, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.8, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.comboBox_fontStyle, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_colors.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 0.2, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.label_foreground, constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 0.8, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.colorChoice_specifyForeground, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_colors.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 0.2, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.label_background, constraints);
        constraints = new GridBagConstraints(1, 6, 1, 1, 0.8, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_colors.add((Component)this.colorChoice_specifyBackground, constraints);
        constraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_colors.add(Box.createGlue(), constraints);
        String highlightSampleLabelText = OptionsArb.getString(105);
        this.label_highlightSample = new JLabel();
        String highlightSampleFieldText = OptionsArb.getString(106);
        this.field_highlightSample = new UnderlineField(highlightSampleFieldText);
        this.field_highlightSample.setCaretPosition(0);
        ResourceUtils.resLabel((JLabel)this.label_highlightSample, (Component)this.field_highlightSample, (String)highlightSampleLabelText);
        String enableHighlightText = OptionsArb.getString(107);
        this.checkBox_enableHighlight = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_enableHighlight, (String)enableHighlightText);
        this.checkBox_enableHighlight.addItemListener(this);
        String priorityText = OptionsArb.getString(108);
        this.label_priority = new JLabel();
        this.slider_priority = new JSlider(1, 100);
        this.slider_priority.addChangeListener(this);
        this.label_priorityText = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_priority, (Component)this.slider_priority, (String)priorityText);
        String minValue = "1";
        String maxValue = "100";
        JLabel label_minValue = new JLabel(minValue);
        JLabel label_maxValue = new JLabel(maxValue);
        Hashtable<Integer, JLabel> table_labels = new Hashtable<Integer, JLabel>(5);
        table_labels.put(new Integer(1), label_minValue);
        table_labels.put(new Integer(100), label_maxValue);
        this.slider_priority.setLabelTable(table_labels);
        this.slider_priority.setPaintLabels(true);
        this.slider_priority.setPaintTicks(true);
        this.slider_priority.setMajorTickSpacing(20);
        this.slider_priority.setMinorTickSpacing(10);
        this.colorChoice_highlightFG = new CustomColorChoice();
        this.colorChoice_highlightFG.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_highlightFG.setTransparentAllowed(true);
        String useFGText = OptionsArb.getString(109);
        this.label_highlightFG = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_highlightFG, (Component)this.colorChoice_highlightFG, (String)useFGText);
        this.colorChoice_highlightBG = new CustomColorChoice();
        this.colorChoice_highlightBG.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_highlightBG.setTransparentAllowed(true);
        String useBGText = OptionsArb.getString(110);
        this.label_highlightBG = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_highlightBG, (Component)this.colorChoice_highlightBG, (String)useBGText);
        String highlightFontLabelText = OptionsArb.getString(112);
        this.label_highlightFont = new JLabel();
        Object[] highlightFontStyles = new String[]{FONT_STYLE_USE_DEFAULT, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
        this.cbModel_highlight = new NonNullableComboBoxModel(highlightFontStyles);
        this.comboBox_highlightFont = new JComboBox(this.cbModel_highlight);
        this.comboBox_highlightFont.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_highlightFont, (Component)this.comboBox_highlightFont, (String)highlightFontLabelText);
        String underlineStyleLabelText = OptionsArb.getString(119);
        this.label_underlineStyle = new JLabel();
        Object[] underlineStyles = new String[]{UNDERLINE_STYLE_NONE, STRIKETHRU_STYLE_SINGLE, STRIKETHRU_STYLE_DOUBLE, UNDERLINE_STYLE_SINGLE, UNDERLINE_STYLE_DOUBLE, UNDERLINE_STYLE_SINGLE_DOTTED, UNDERLINE_STYLE_DOUBLE_DOTTED, UNDERLINE_STYLE_WAVY, SEPARATOR_STYLE_SINGLE, SEPARATOR_STYLE_DOUBLE, SEPARATOR_STYLE_SINGLE_DOTTED, SEPARATOR_STYLE_DOUBLE_DOTTED, SEPARATOR_STYLE_PERFORATED};
        this.cbModel_underline = new NonNullableComboBoxModel(underlineStyles);
        this.comboBox_underlineStyle = new JComboBox(this.cbModel_underline);
        this.comboBox_underlineStyle.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_underlineStyle, (Component)this.comboBox_underlineStyle, (String)underlineStyleLabelText);
        this.colorChoice_underlineColor = new CustomColorChoice();
        this.colorChoice_underlineColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_underlineColor.setTransparentAllowed(true);
        String underlineColorText = OptionsArb.getString(120);
        this.label_underlineColor = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_underlineColor, (Component)this.colorChoice_underlineColor, (String)underlineColorText);
        JPanel panel_highlight = new JPanel(new GridBagLayout());
        Insets indentedInsets = new Insets(0, 25, 0, 0);
        JPanel panel_sub = new JPanel(new GridBagLayout());
        if (SHOW_PRIORITY_CONTROLS) {
            constraints = new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
            panel_sub.add((Component)this.label_priority, constraints);
            constraints = new GridBagConstraints(1, 0, 1, 1, 0.6, 0.0, 17, 2, emptyInsets, 0, 0);
            panel_sub.add((Component)this.slider_priority, constraints);
            constraints = new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 17, 0, emptyInsets, 0, 0);
            panel_sub.add((Component)this.label_priorityText, constraints);
            constraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
            panel_sub.add(Box.createVerticalStrut(2), constraints);
        }
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.label_highlightFont, constraints);
        constraints = new GridBagConstraints(1, 2, 2, 1, 0.9, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.comboBox_highlightFont, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_sub.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.label_highlightFG, constraints);
        constraints = new GridBagConstraints(1, 4, 2, 1, 0.9, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.colorChoice_highlightFG, constraints);
        constraints = new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_sub.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.label_highlightBG, constraints);
        constraints = new GridBagConstraints(1, 6, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.colorChoice_highlightBG, constraints);
        constraints = new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_sub.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.label_underlineStyle, constraints);
        constraints = new GridBagConstraints(1, 8, 2, 1, 0.9, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.comboBox_underlineStyle, constraints);
        constraints = new GridBagConstraints(0, 9, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        panel_sub.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 10, 1, 1, 0.1, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.label_underlineColor, constraints);
        constraints = new GridBagConstraints(1, 10, 2, 1, 0.9, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_sub.add((Component)this.colorChoice_underlineColor, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_highlight.add((Component)this.label_highlightSample, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        panel_highlight.add((Component)this.field_highlightSample, constraints);
        constraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_highlight.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_highlight.add((Component)this.checkBox_enableHighlight, constraints);
        constraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_highlight.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, indentedInsets, 0, 0);
        panel_highlight.add((Component)panel_sub, constraints);
        String editorLabelText = OptionsArb.getString(113);
        this.label_sampleText = new JLabel();
        this.editor_sampleText = new BasicEditorPane();
        this.editor_sampleText.setProtected(true);
        this.editor_sampleText.addToolTipProvider((ToolTipProvider)this);
        this.editor_sampleText.addCaretListener((CaretListener)this);
        this.highlightLayer = this.editor_sampleText.createHighlightLayer();
        this.scrollPane_sampleText = new JScrollPane((Component)this.editor_sampleText);
        ResourceUtils.resLabel((JLabel)this.label_sampleText, (Component)this.editor_sampleText, (String)editorLabelText);
        JPanel panel_editor = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_editor.add((Component)this.label_sampleText, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_editor.add((Component)this.scrollPane_sampleText, constraints);
        this.panel_card = new CardPanel();
        this.panel_card.add((Component)panel_colors, STYLE_CARD);
        this.panel_card.add((Component)panel_highlight, HIGHLIGHT_CARD);
        Insets panelInsets = new Insets(1, 3, 1, 3);
        constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, panelInsets, 0, 0);
        this.add(panel_scheme, constraints);
        constraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, panelInsets, 0, 0);
        this.add(Box.createVerticalStrut(1), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, panelInsets, 0, 0);
        this.add(panel_category, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 1, panelInsets, 0, 0);
        this.add(panel_styles, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 2, 0.5, 0.0, 17, 1, panelInsets, 0, 0);
        this.add(this.panel_card, constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, panelInsets, 0, 0);
        this.add(panel_editor, constraints);
        EditorProperties properties = EditorProperties.getProperties();
        StyleRegistry globalStyleRegistry = properties.getStyleRegistry();
        this.styleRegistry = (StyleRegistry)globalStyleRegistry.clone();
        this.editor_sampleText.setStyleRegistry(this.styleRegistry);
        HighlightRegistry globalHighlightRegistry = properties.getHighlightRegistry();
        this.highlightRegistry = (HighlightRegistry)globalHighlightRegistry.clone();
        this.editor_sampleText.setHighlightRegistry(this.highlightRegistry);
        LanguageModule defaultModule = LanguageModule.getDefaultModule();
        this.comboBox_category.setSelectedItem(defaultModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        String tooltipText = null;
        try {
            document.readLock();
            LineMap lineMap = document.getLineMap();
            int line = lineMap.getLineFromOffset(offset);
            DocumentRenderer renderer = document.getDocumentRenderer();
            if (renderer instanceof SCOPDR) {
                if (line >= this.styleListModel.getSize()) return tooltipText;
                Object style = this.styleListModel.getElementAt(line);
                if (style instanceof BaseStyle) {
                    BaseStyle baseStyle = (BaseStyle)style;
                    String name = baseStyle.getPresentationName();
                    tooltipText = OptionsArb.format(134, name);
                    return tooltipText;
                } else {
                    if (!(style instanceof HighlightStyle)) throw new IllegalStateException("bad style type");
                    HighlightStyle highlightStyle = (HighlightStyle)style;
                    String name = highlightStyle.getPresentationName();
                    tooltipText = OptionsArb.format(135, name);
                }
                return tooltipText;
            } else {
                StyledFragmentsList fragmentsList = renderer.renderLines(line, line);
                StyleRegistry styleRegistry = editorPane.getStyleRegistry();
                int numFragments = fragmentsList.size();
                for (int i = 0; i < numFragments; ++i) {
                    StyledFragment fragment = fragmentsList.get(i);
                    if (fragment.startOffset > offset || offset >= fragment.endOffset) continue;
                    BaseStyle style = styleRegistry.lookupStyle(fragment.styleName);
                    if (style == null) {
                        throw new IllegalStateException("style not found: " + fragment.styleName);
                    }
                    String name = style.getPresentationName();
                    tooltipText = OptionsArb.format(134, name);
                }
                renderer.recycleFragmentsList(fragmentsList);
            }
            return tooltipText;
        }
        finally {
            document.readUnlock();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.isInUIUpdate()) {
            return;
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equals("selectedColor")) {
            this.beginUIUpdate();
            Object source = event.getSource();
            if (source == this.colorChoice_specifyForeground || source == this.colorChoice_specifyBackground) {
                CustomColorChoice colorChoice = (CustomColorChoice)source;
                boolean useParentColor = false;
                if (colorChoice.isDefaultAllowed()) {
                    useParentColor = colorChoice.isDefaultSelected();
                }
                Color selectedColor = colorChoice.getSelectedColor();
                if (source == this.colorChoice_specifyForeground) {
                    this.styleRegistry.modifyStyleForeground(this.editedStyle.getName(), useParentColor, selectedColor);
                } else {
                    this.styleRegistry.modifyStyleBackground(this.editedStyle.getName(), useParentColor, selectedColor);
                }
            } else if (source == this.colorChoice_highlightFG) {
                Color fgColor = this.colorChoice_highlightFG.getSelectedColor();
                this.highlightRegistry.modifyStyleForeground(this.editedHighlight.getName(), fgColor);
            } else if (source == this.colorChoice_highlightBG) {
                Color bgColor = this.colorChoice_highlightBG.getSelectedColor();
                this.highlightRegistry.modifyStyleBackground(this.editedHighlight.getName(), bgColor);
            } else if (source == this.colorChoice_underlineColor) {
                Color underlineColor = this.colorChoice_underlineColor.getSelectedColor();
                this.highlightRegistry.modifyStyleUnderline(this.editedHighlight.getName(), this.editedHighlight.getUnderlinePainter(), underlineColor);
            }
            this.selectSchemeName(SCHEME_CUSTOM);
            this.endUIUpdate();
            this.updateStyleSample();
            this.updateHighlightSample();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.isInUIUpdate()) {
            return;
        }
        Object sourceList = event.getSource();
        if (sourceList == this.list_styles) {
            Object selected = this.list_styles.getSelectedValue();
            if (selected instanceof BaseStyle) {
                this.editedStyle = (BaseStyle)selected;
                this.panel_card.showCard(STYLE_CARD);
                this.updateStylePanel();
            } else if (selected instanceof HighlightStyle) {
                this.editedHighlight = (HighlightStyle)selected;
                this.panel_card.showCard(HIGHLIGHT_CARD);
                this.updateHighlightPanel();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.button_saveAs) {
            String schemeName;
            String labelText = OptionsArb.getString(87);
            JLabel label_name = new JLabel();
            JTextField field_name = new JTextField();
            ResourceUtils.resLabel((JLabel)label_name, (Component)field_name, (String)labelText);
            JPanel panel_name = new JPanel(new GridBagLayout());
            Insets defaultInsets = new Insets(2, 2, 2, 2);
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null) {
                helpSystem.registerTopic((JComponent)panel_name, "f1_idedsavescheme_html");
            }
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
            panel_name.add((Component)label_name, constraints);
            constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, defaultInsets, 0, 0);
            panel_name.add((Component)field_name, constraints);
            String dialogTitle = OptionsArb.getString(88);
            while (true) {
                field_name.selectAll();
                boolean resultOK = OnePageWizardDialogFactory.runDialog((Component)panel_name, (Component)field_name, (String)dialogTitle);
                if (!resultOK) return;
                schemeName = field_name.getText().trim();
                if (schemeName.length() != 0) break;
                String message = OptionsArb.getString(89);
                String title = OptionsArb.getString(90);
                this.showErrorDialog(message, title);
            }
            ArrayList styleList = new ArrayList();
            SyntaxColorsOptionsPanel.copyRegistriesToStyleList(this.styleRegistry, this.highlightRegistry, styleList);
            this.schemeMap.putScheme(schemeName, styleList);
            this.addSchemeName(schemeName);
            return;
        } else {
            if (source != this.button_delete) return;
            String schemeName = (String)this.comboBox_scheme.getSelectedItem();
            if (schemeName.equals(SCHEME_CUSTOM)) {
                String message = OptionsArb.getString(91);
                String title = OptionsArb.getString(92);
                this.showErrorDialog(message, title);
                return;
            } else {
                this.schemeMap.removeScheme(schemeName);
                this.deleteSchemeName(schemeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent event) {
        if (this.isInUIUpdate()) {
            return;
        }
        BasicEditorPane editorPane = this.editor_sampleText;
        int caretOffset = editorPane.getCaretPosition();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        LineMap lineMap = document.getLineMap();
        int indexToSelect = -1;
        document.readLock();
        try {
            int line = lineMap.getLineFromOffset(caretOffset);
            DocumentRenderer renderer = document.getDocumentRenderer();
            if (renderer instanceof SCOPDR) {
                int numStyles = this.styleListModel.getSize();
                if (line < numStyles) {
                    indexToSelect = line;
                }
            } else {
                StyledFragmentsList fragmentsList = renderer.renderLines(line, line);
                StyleRegistry styleRegistry = editorPane.getStyleRegistry();
                int numFragments = fragmentsList.size();
                for (int i = 0; i < numFragments; ++i) {
                    StyledFragment fragment = fragmentsList.get(i);
                    if (fragment.startOffset > caretOffset || caretOffset >= fragment.endOffset) continue;
                    BaseStyle style = styleRegistry.lookupStyle(fragment.styleName);
                    indexToSelect = this.styleListModel.indexOf(style);
                    break;
                }
                renderer.recycleFragmentsList(fragmentsList);
            }
        }
        finally {
            document.readUnlock();
        }
        if (indexToSelect != -1) {
            this.list_styles.setSelectedIndex(indexToSelect);
            this.list_styles.ensureIndexIsVisible(indexToSelect);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.isInUIUpdate()) {
            return;
        }
        this.beginUIUpdate();
        Object source = event.getSource();
        if (source == this.slider_priority) {
            int value = this.slider_priority.getValue();
            this.highlightRegistry.modifyStylePriority(this.editedHighlight.getName(), value);
            this.selectSchemeName(SCHEME_CUSTOM);
        }
        this.endUIUpdate();
        this.updateHighlightSample();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.isInUIUpdate()) {
            return;
        }
        this.beginUIUpdate();
        Object source = event.getSource();
        if (source == this.comboBox_fontStyle) {
            int fontStyle;
            boolean useParentFontStyle;
            String fontStyleValue = (String)this.comboBox_fontStyle.getSelectedItem();
            if (fontStyleValue.equals(FONT_STYLE_USE_DEFAULT)) {
                useParentFontStyle = true;
                fontStyle = 0;
            } else if (fontStyleValue.equals(FONT_STYLE_NORMAL)) {
                useParentFontStyle = false;
                fontStyle = 0;
            } else if (fontStyleValue.equals(FONT_STYLE_BOLD)) {
                useParentFontStyle = false;
                fontStyle = 1;
            } else if (fontStyleValue.equals(FONT_STYLE_ITALIC)) {
                useParentFontStyle = false;
                fontStyle = 2;
            } else if (fontStyleValue.equals(FONT_STYLE_BOLDITALIC)) {
                useParentFontStyle = false;
                fontStyle = 3;
            } else {
                throw new IllegalStateException("unknown style: " + fontStyleValue);
            }
            this.styleRegistry.modifyStyleFontStyle(this.editedStyle.getName(), useParentFontStyle, fontStyle);
            this.selectSchemeName(SCHEME_CUSTOM);
        } else if (source == this.comboBox_underlineStyle) {
            int underlineIndex;
            String underlineStyleValue = (String)this.comboBox_underlineStyle.getSelectedItem();
            if (underlineStyleValue.equals(UNDERLINE_STYLE_NONE)) {
                underlineIndex = -1;
            } else if (underlineStyleValue.equals(UNDERLINE_STYLE_SINGLE)) {
                underlineIndex = 0;
            } else if (underlineStyleValue.equals(UNDERLINE_STYLE_DOUBLE)) {
                underlineIndex = 1;
            } else if (underlineStyleValue.equals(UNDERLINE_STYLE_SINGLE_DOTTED)) {
                underlineIndex = 2;
            } else if (underlineStyleValue.equals(UNDERLINE_STYLE_DOUBLE_DOTTED)) {
                underlineIndex = 3;
            } else if (underlineStyleValue.equals(UNDERLINE_STYLE_WAVY)) {
                underlineIndex = 4;
            } else if (underlineStyleValue.equals(SEPARATOR_STYLE_SINGLE)) {
                underlineIndex = 5;
            } else if (underlineStyleValue.equals(SEPARATOR_STYLE_DOUBLE)) {
                underlineIndex = 6;
            } else if (underlineStyleValue.equals(SEPARATOR_STYLE_SINGLE_DOTTED)) {
                underlineIndex = 7;
            } else if (underlineStyleValue.equals(SEPARATOR_STYLE_DOUBLE_DOTTED)) {
                underlineIndex = 8;
            } else if (underlineStyleValue.equals(SEPARATOR_STYLE_PERFORATED)) {
                underlineIndex = 9;
            } else if (underlineStyleValue.equals(STRIKETHRU_STYLE_SINGLE)) {
                underlineIndex = 10;
            } else if (underlineStyleValue.equals(STRIKETHRU_STYLE_DOUBLE)) {
                underlineIndex = 11;
            } else {
                throw new IllegalStateException("unknown style: " + underlineStyleValue);
            }
            this.highlightRegistry.modifyStyleUnderline(this.editedHighlight.getName(), underlineIndex, this.editedHighlight.getUnderlineColor());
            this.selectSchemeName(SCHEME_CUSTOM);
        } else if (source == this.comboBox_highlightFont) {
            int fontStyle;
            String fontStyleValue = (String)this.comboBox_highlightFont.getSelectedItem();
            if (fontStyleValue.equals(FONT_STYLE_USE_DEFAULT)) {
                fontStyle = 0;
            } else if (fontStyleValue.equals(FONT_STYLE_BOLD)) {
                fontStyle = 1;
            } else if (fontStyleValue.equals(FONT_STYLE_ITALIC)) {
                fontStyle = 2;
            } else if (fontStyleValue.equals(FONT_STYLE_BOLDITALIC)) {
                fontStyle = 3;
            } else {
                throw new IllegalStateException("unknown style: " + fontStyleValue);
            }
            this.highlightRegistry.modifyStyleFont(this.editedHighlight.getName(), fontStyle);
            this.selectSchemeName(SCHEME_CUSTOM);
        } else {
            if (source == this.checkBox_enableHighlight) {
                boolean enabled = this.checkBox_enableHighlight.isSelected();
                this.highlightRegistry.modifyStyleEnabled(this.editedHighlight.getName(), enabled);
                this.selectSchemeName(SCHEME_CUSTOM);
                this.endUIUpdate();
                this.updateHighlightPanel();
                return;
            }
            if (source == this.comboBox_category) {
                LanguageModule defaultModule;
                Object selectedModule = this.comboBox_category.getSelectedItem();
                LanguageModule languageModule = defaultModule = LanguageModule.getDefaultModule();
                SortedListModel sortedModel = new SortedListModel();
                sortedModel.setComparator((Comparator)new SyntaxComparator());
                this.styleListModel = sortedModel;
                if (selectedModule == CATEGORY_ALL) {
                    BaseStyle validatedStyle;
                    Iterator iterator = this.styleRegistry.getStyleIterator();
                    while (iterator.hasNext()) {
                        BaseStyle baseStyle = (BaseStyle)iterator.next();
                        validatedStyle = this.styleRegistry.lookupStyle(baseStyle.getName());
                        if (validatedStyle == null) continue;
                        this.styleListModel.addElement(validatedStyle);
                    }
                    iterator = this.highlightRegistry.getStyleIterator();
                    while (iterator.hasNext()) {
                        HighlightStyle highlightStyle = (HighlightStyle)iterator.next();
                        validatedStyle = this.highlightRegistry.lookupStyle(highlightStyle.getName());
                        if (validatedStyle == null) continue;
                        this.styleListModel.addElement(validatedStyle);
                    }
                } else {
                    languageModule = (LanguageModule)selectedModule;
                    String[] moduleStyles = languageModule.getStyleNames();
                    int numStyles = moduleStyles.length;
                    for (int i = 0; i < numStyles; ++i) {
                        BaseStyle style = this.styleRegistry.lookupStyle(moduleStyles[i]);
                        if (style == null) continue;
                        this.styleListModel.addElement(style);
                    }
                    if (languageModule == defaultModule) {
                        SortedListModel highlightModel = new SortedListModel();
                        Iterator iterator = this.highlightRegistry.getStyleIterator();
                        while (iterator.hasNext()) {
                            UnderlinePainter painter;
                            HighlightStyle highlightStyle = (HighlightStyle)iterator.next();
                            HighlightStyle validatedStyle = this.highlightRegistry.lookupStyle(highlightStyle.getName());
                            if (validatedStyle == null || (painter = validatedStyle.getUnderlinePainter()) != null && HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)painter) == -1) continue;
                            highlightModel.addElement((Object)validatedStyle);
                        }
                        Object lfStyle = null;
                        String lfStyleName = "base-lf-style";
                        numStyles = this.styleListModel.getSize();
                        for (int i = 0; i < numStyles; ++i) {
                            Object style = this.styleListModel.getElementAt(i);
                            if (!(style instanceof BaseStyle) || !((BaseStyle)style).getName().equals("base-lf-style")) continue;
                            lfStyle = style;
                            break;
                        }
                        this.styleListModel.removeElement(lfStyle);
                        Object plainStyle = null;
                        String plainStyleName = "base-plain-style";
                        numStyles = this.styleListModel.getSize();
                        for (int i = 0; i < numStyles; ++i) {
                            Object style = this.styleListModel.getElementAt(i);
                            if (!(style instanceof BaseStyle) || !((BaseStyle)style).getName().equals("base-plain-style")) continue;
                            plainStyle = style;
                            break;
                        }
                        this.styleListModel.removeElement(plainStyle);
                        DefaultListModel<Object> newModel = new DefaultListModel<Object>();
                        newModel.addElement(plainStyle);
                        numStyles = this.styleListModel.getSize();
                        for (int i = 0; i < numStyles; ++i) {
                            Object style = this.styleListModel.getElementAt(i);
                            newModel.addElement(style);
                        }
                        int numHighlights = highlightModel.getSize();
                        for (int i = 0; i < numHighlights; ++i) {
                            Object highlight = highlightModel.getElementAt(i);
                            newModel.addElement(highlight);
                        }
                        this.styleListModel = newModel;
                    }
                }
                this.list_styles.setModel(this.styleListModel);
                String contentText = null;
                Object support = null;
                if (languageModule == defaultModule) {
                    int numStyles = this.styleListModel.getSize();
                    Object[] styles = new Object[numStyles];
                    for (int i = 0; i < numStyles; ++i) {
                        styles[i] = this.styleListModel.getElementAt(i);
                    }
                    SCOPLS scoSupport = new SCOPLS(styles);
                    contentText = scoSupport.getContentSample();
                    support = scoSupport;
                } else {
                    support = languageModule.createLanguageSupport();
                    contentText = languageModule.getContentSample();
                }
                this.highlightLayer.removeAllHighlights();
                BasicDocument document = (BasicDocument)this.editor_sampleText.getDocument();
                if (support != null) {
                    document.setLanguageSupport(support);
                }
                if (contentText != null) {
                    char[] contentChars = contentText.toCharArray();
                    CharArrayReader contentReader = new CharArrayReader(contentChars);
                    try {
                        TextBuffer buffer = document.getTextBuffer();
                        buffer.read((Reader)contentReader);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (languageModule == defaultModule) {
                    LineMap lineMap = document.getLineMap();
                    int numStyles = this.styleListModel.getSize();
                    for (int i = 0; i < numStyles; ++i) {
                        Object style = this.styleListModel.getElementAt(i);
                        if (!(style instanceof HighlightStyle)) continue;
                        HighlightStyle highlightStyle = (HighlightStyle)style;
                        int lineStart = lineMap.getLineStartOffset(i);
                        int lineEnd = lineMap.getLineEndOffset(i);
                        this.highlightLayer.addHighlight(highlightStyle, lineStart, lineEnd);
                    }
                }
                this.endUIUpdate();
                int numStyles = this.styleListModel.getSize();
                if (numStyles > 0) {
                    this.list_styles.setSelectedIndex(0);
                }
                return;
            }
            if (source == this.comboBox_scheme) {
                String schemeName = (String)this.comboBox_scheme.getSelectedItem();
                if (schemeName.equals(SCHEME_CUSTOM)) {
                    this.endUIUpdate();
                    return;
                }
                this.selectSchemeName(schemeName);
                List styleList = this.schemeMap.getScheme(schemeName);
                if (styleList != null) {
                    SyntaxColorsOptionsPanel.copyStyleListToRegistries(styleList, this.styleRegistry, this.highlightRegistry);
                    this.endUIUpdate();
                    this.updateStylePanel();
                    this.updateHighlightPanel();
                } else {
                    this.endUIUpdate();
                }
                return;
            }
        }
        this.endUIUpdate();
        this.updateStyleSample();
        this.updateHighlightSample();
    }

    private void updateStylePanel() {
        this.beginUIUpdate();
        boolean enableAll = this.editedStyle != null;
        Component[] allComponents = new Component[]{this.label_styleSample, this.field_styleSample, this.label_foreground, this.colorChoice_specifyForeground, this.label_background, this.colorChoice_specifyBackground, this.label_fontStyle, this.comboBox_fontStyle};
        int numComponents = allComponents.length;
        for (int i = 0; i < numComponents; ++i) {
            allComponents[i].setEnabled(enableAll);
        }
        if (this.editedStyle != null) {
            Color fgColor = this.editedStyle.getForegroundColor();
            boolean useParentFg = this.editedStyle.getUsesParentForegroundColor();
            Color bgColor = this.editedStyle.getBackgroundColor();
            boolean useParentBg = this.editedStyle.getUsesParentBackgroundColor();
            int fontStyle = this.editedStyle.getFontStyle();
            boolean useFontStyle = this.editedStyle.getUsesParentFontStyle();
            BaseStyle parentStyle = this.styleRegistry.lookupStyle(this.editedStyle.getParentName());
            if (parentStyle == null) {
                parentStyle = this.editedStyle;
            }
            Color parentFgColor = parentStyle.getForegroundColor();
            Color parentBgColor = parentStyle.getBackgroundColor();
            if (this.editedStyle.getName().equals("base-plain-style")) {
                this.comboBox_fontStyle.setEnabled(false);
                this.label_fontStyle.setEnabled(false);
                this.comboBox_fontStyle.setModel(this.cbModel_base);
            } else {
                this.comboBox_fontStyle.setModel(this.cbModel_extended);
            }
            String fontStyleValue = FONT_STYLE_USE_DEFAULT;
            if (!useFontStyle) {
                int BOLDITALIC = 3;
                switch (fontStyle) {
                    case 0: {
                        fontStyleValue = FONT_STYLE_NORMAL;
                        break;
                    }
                    case 1: {
                        fontStyleValue = FONT_STYLE_BOLD;
                        break;
                    }
                    case 2: {
                        fontStyleValue = FONT_STYLE_ITALIC;
                        break;
                    }
                    case 3: {
                        fontStyleValue = FONT_STYLE_BOLDITALIC;
                    }
                }
            }
            this.comboBox_fontStyle.setSelectedItem(fontStyleValue);
            this.colorChoice_specifyForeground.setClosestSelectedColor(fgColor);
            this.colorChoice_specifyBackground.setClosestSelectedColor(bgColor);
            if (!this.editedStyle.getHasParent()) {
                this.colorChoice_specifyForeground.setDefaultAllowed(false);
                this.colorChoice_specifyBackground.setDefaultAllowed(false);
            } else {
                this.colorChoice_specifyForeground.setDefaultAllowed(true);
                Color closestParentFg = this.colorChoice_specifyForeground.getClosestColor(parentFgColor);
                this.colorChoice_specifyForeground.setDefaultColor(closestParentFg);
                this.colorChoice_specifyForeground.setDefaultSelected(useParentFg);
                this.colorChoice_specifyBackground.setDefaultAllowed(true);
                Color closestParentBg = this.colorChoice_specifyBackground.getClosestColor(parentBgColor);
                this.colorChoice_specifyBackground.setDefaultColor(closestParentBg);
                this.colorChoice_specifyBackground.setDefaultSelected(useParentBg);
            }
            this.updateStyleSample();
        }
        this.endUIUpdate();
    }

    private void updateHighlightPanel() {
        this.beginUIUpdate();
        boolean enableAll = this.editedHighlight != null;
        Component[] allComponents = new Component[]{this.label_highlightSample, this.field_highlightSample, this.checkBox_enableHighlight, this.label_priority, this.slider_priority, this.label_priorityText, this.label_highlightFG, this.colorChoice_highlightFG, this.label_highlightBG, this.colorChoice_highlightBG, this.label_highlightFont, this.comboBox_highlightFont, this.label_underlineStyle, this.comboBox_underlineStyle, this.label_underlineColor, this.colorChoice_underlineColor};
        int numComponents = allComponents.length;
        for (int i = 0; i < numComponents; ++i) {
            allComponents[i].setEnabled(enableAll);
        }
        if (this.editedHighlight != null) {
            String underlineStyleValue;
            Color fgColor = this.editedHighlight.getForegroundColor();
            Color bgColor = this.editedHighlight.getBackgroundColor();
            int priority = this.editedHighlight.getPriority();
            boolean enabled = this.editedHighlight.getEnabled();
            int fontStyle = this.editedHighlight.getFontStyle();
            UnderlinePainter painter = this.editedHighlight.getUnderlinePainter();
            int painterIndex = HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)painter);
            if (painter == null || painterIndex == -1) {
                // empty if block
            }
            Color underlineColor = this.editedHighlight.getUnderlineColor();
            this.checkBox_enableHighlight.setSelected(enabled);
            if (!enabled) {
                this.label_priority.setEnabled(false);
                this.slider_priority.setEnabled(false);
                this.label_priorityText.setEnabled(false);
                this.label_highlightFG.setEnabled(false);
                this.colorChoice_highlightFG.setEnabled(false);
                this.label_highlightBG.setEnabled(false);
                this.colorChoice_highlightBG.setEnabled(false);
                this.label_highlightFont.setEnabled(false);
                this.comboBox_highlightFont.setEnabled(false);
                this.label_underlineStyle.setEnabled(false);
                this.comboBox_underlineStyle.setEnabled(false);
                this.label_underlineColor.setEnabled(false);
                this.colorChoice_underlineColor.setEnabled(false);
            }
            this.slider_priority.setValue(priority);
            this.colorChoice_highlightFG.setClosestSelectedColor(fgColor);
            this.colorChoice_highlightBG.setClosestSelectedColor(bgColor);
            String fontStyleValue = FONT_STYLE_USE_DEFAULT;
            switch (fontStyle) {
                case 0: {
                    fontStyleValue = FONT_STYLE_USE_DEFAULT;
                    break;
                }
                case 1: {
                    fontStyleValue = FONT_STYLE_BOLD;
                    break;
                }
                case 2: {
                    fontStyleValue = FONT_STYLE_ITALIC;
                    break;
                }
                case 3: {
                    fontStyleValue = FONT_STYLE_BOLDITALIC;
                }
            }
            this.comboBox_highlightFont.setSelectedItem(fontStyleValue);
            switch (painterIndex) {
                default: {
                    underlineStyleValue = UNDERLINE_STYLE_NONE;
                    break;
                }
                case 0: {
                    underlineStyleValue = UNDERLINE_STYLE_SINGLE;
                    break;
                }
                case 1: {
                    underlineStyleValue = UNDERLINE_STYLE_DOUBLE;
                    break;
                }
                case 2: {
                    underlineStyleValue = UNDERLINE_STYLE_SINGLE_DOTTED;
                    break;
                }
                case 3: {
                    underlineStyleValue = UNDERLINE_STYLE_DOUBLE_DOTTED;
                    break;
                }
                case 4: {
                    underlineStyleValue = UNDERLINE_STYLE_WAVY;
                    break;
                }
                case 5: {
                    underlineStyleValue = SEPARATOR_STYLE_SINGLE;
                    break;
                }
                case 6: {
                    underlineStyleValue = SEPARATOR_STYLE_DOUBLE;
                    break;
                }
                case 7: {
                    underlineStyleValue = SEPARATOR_STYLE_SINGLE_DOTTED;
                    break;
                }
                case 8: {
                    underlineStyleValue = SEPARATOR_STYLE_DOUBLE_DOTTED;
                    break;
                }
                case 9: {
                    underlineStyleValue = SEPARATOR_STYLE_PERFORATED;
                    break;
                }
                case 10: {
                    underlineStyleValue = STRIKETHRU_STYLE_SINGLE;
                    break;
                }
                case 11: {
                    underlineStyleValue = STRIKETHRU_STYLE_DOUBLE;
                }
            }
            this.comboBox_underlineStyle.setSelectedItem(underlineStyleValue);
            this.colorChoice_underlineColor.setClosestSelectedColor(underlineColor);
            this.updateHighlightSample();
        }
        this.endUIUpdate();
    }

    private void updateStyleSample() {
        if (this.editedStyle == null) {
            return;
        }
        int fontStyle = this.editedStyle.getFontStyle();
        Color fgColor = this.editedStyle.getForegroundColor();
        Color bgColor = this.editedStyle.getBackgroundColor();
        Font currentFont = this.field_styleSample.getFont();
        Font newFont = currentFont.deriveFont(fontStyle);
        this.field_styleSample.setFont(newFont);
        this.field_styleSample.setForeground(fgColor);
        this.field_styleSample.setBackground(bgColor);
    }

    private void updateHighlightSample() {
        if (this.editedHighlight == null) {
            return;
        }
        BaseStyle plainStyle = this.styleRegistry.lookupStyle("base-plain-style");
        Color fgColor = plainStyle.getForegroundColor();
        Color bgColor = plainStyle.getBackgroundColor();
        int fontStyle = 0;
        if (this.editedHighlight.getEnabled()) {
            if (this.editedHighlight.getUseForegroundColor()) {
                fgColor = this.editedHighlight.getForegroundColor();
            }
            if (this.editedHighlight.getUseBackgroundColor()) {
                bgColor = this.editedHighlight.getBackgroundColor();
            }
            fontStyle = this.editedHighlight.getFontStyle();
        }
        this.field_highlightSample.setForeground(fgColor);
        this.field_highlightSample.setBackground(bgColor);
        Font currentFont = this.field_highlightSample.getFont();
        Font newFont = currentFont.deriveFont(fontStyle);
        this.field_highlightSample.setFont(newFont);
        this.field_highlightSample.setUnderline(this.editedHighlight.getUnderlinePainter(), this.editedHighlight.getUnderlineColor());
        int priority = this.editedHighlight.getPriority();
        this.label_priorityText.setText(Integer.toString(priority));
    }

    private void beginUIUpdate() {
        this.inUpdate = true;
    }

    private boolean isInUIUpdate() {
        return this.inUpdate;
    }

    private void endUIUpdate() {
        this.inUpdate = false;
    }

    static {
        String property = System.getProperty("ceditor.syntaxcolors.show.priority", "false");
        SHOW_PRIORITY_CONTROLS = property != null && Boolean.valueOf(property.toString()) != false;
    }

    private final class UnderlineField
    extends JTextField {
        private UnderlinePainter _underlinePainter;
        private Color _underlineColor;

        private UnderlineField(String text) {
            super(text);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this._underlinePainter != null && this._underlineColor != null) {
                try {
                    Rectangle firstBox = this.modelToView(0);
                    int endOffset = this.getText().length();
                    Rectangle lastBox = this.modelToView(endOffset);
                    Font font = this.getFont();
                    FontMetrics metrics = this.getFontMetrics(font);
                    int ascent = metrics.getAscent();
                    int descent = metrics.getDescent();
                    int startX = firstBox.x;
                    int startY = firstBox.y;
                    int width = lastBox.x - startX;
                    int baseline = startY + ascent;
                    this._underlinePainter.paintUnderline(graphics, this._underlineColor, startY, width, startY, baseline, descent);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void setUnderline(UnderlinePainter painter, Color color) {
            this._underlinePainter = painter;
            this._underlineColor = color;
            this.repaint();
        }
    }

    private static final class CardPanel
    extends JPanel
    implements LayoutManager {
        public CardPanel() {
            this.setLayout(this);
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
            if (name != null) {
                child.setName(name);
            }
            child.setVisible(child.getParent().getComponentCount() == 1);
        }

        @Override
        public void removeLayoutComponent(Component child) {
            Container parent;
            if (child.isVisible() && (parent = child.getParent()).getComponentCount() > 0) {
                parent.getComponent(0).setVisible(true);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getPreferredSize();
                if (d.width + insets.left + insets.right > width) {
                    width = d.width + insets.left + insets.right;
                }
                if (d.height + insets.top + insets.bottom <= height) continue;
                height = d.height + insets.top + insets.bottom;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getMinimumSize();
                if (d.width + insets.left + insets.right > width) {
                    width = d.width + insets.left + insets.right;
                }
                if (d.height + insets.top + insets.bottom <= height) continue;
                height = d.height + insets.top + insets.bottom;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            for (int i = 0; i < nChildren; ++i) {
                Component child = parent.getComponent(i);
                if (!child.isVisible()) continue;
                Rectangle r = parent.getBounds();
                int width = r.width - insets.left + insets.right;
                int height = r.height - insets.top + insets.bottom;
                Dimension d = child.getPreferredSize();
                if (d.height < height) {
                    height = d.height;
                }
                child.setBounds(insets.left, insets.top, width, height);
                break;
            }
        }

        public void showCard(String name) {
            int nChildren = this.getComponentCount();
            for (int i = 0; i < nChildren; ++i) {
                Component child = this.getComponent(i);
                if (child.getName().equals(name)) {
                    child.setVisible(true);
                    continue;
                }
                if (!child.isVisible()) continue;
                child.setVisible(false);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static final class SCOPDR
    extends AbstractDocumentRenderer {
        private Object[] styles;

        private SCOPDR(LanguageSupport support, Object[] styles) {
            super(support);
            this.styles = styles;
        }

        public void renderRegion(StyledFragmentsList fragmentsList, int startOffset, int endOffset) {
            LineMap lineMap = this.getLineMap();
            int lastLine = lineMap.getLineCount() - 1;
            for (int i = 0; i < lastLine; ++i) {
                boolean hasEOL;
                int lineStart = lineMap.getLineStartOffset(i);
                int lineEnd = lineMap.getLineEndOffset(i);
                boolean bl = hasEOL = i != lastLine;
                if (hasEOL) {
                    --lineEnd;
                }
                String styleToUse = "base-plain-style";
                if (this.styles[i] instanceof BaseStyle) {
                    BaseStyle style = (BaseStyle)this.styles[i];
                    styleToUse = style.getName();
                }
                fragmentsList.add(styleToUse, lineStart, lineEnd);
                if (!hasEOL) continue;
                fragmentsList.add("base-plain-style", lineEnd, lineEnd + 1);
            }
        }

        public void calculateDamage(DocumentEvent changes, NumberRange damageRange) {
        }
    }

    private static final class SCOPLS
    extends AbstractLanguageSupport {
        private Object[] styles;

        private SCOPLS(Object[] styles) {
            this.styles = styles;
        }

        private String getContentSample() {
            StringBuffer buffer = new StringBuffer();
            int numStyles = this.styles.length;
            for (int i = 0; i < numStyles; ++i) {
                String nameToAdd;
                BaseStyle style;
                if (this.styles[i] instanceof BaseStyle) {
                    style = (BaseStyle)this.styles[i];
                    nameToAdd = style.getPresentationName();
                } else if (this.styles[i] instanceof HighlightStyle) {
                    style = (HighlightStyle)this.styles[i];
                    nameToAdd = style.getPresentationName();
                } else {
                    throw new IllegalStateException("bad style type");
                }
                buffer.append(nameToAdd);
                buffer.append("\n");
            }
            return buffer.toString();
        }

        protected DocumentRenderer createDocumentRenderer() {
            return new SCOPDR((LanguageSupport)this, this.styles);
        }
    }
}

