/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class InsightOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private static String DEFAULT_FONT = "Dialog";
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_completionEnablePopup;
    private JSlider slider_completionPopupDelay;
    private JLabel label_completionSliderMax;
    private JLabel label_completionSliderMin;
    private JLabel label_completionPopupDelayText;
    private JCheckBox checkbox_parameterEnablePopup;
    private JSlider slider_parameterPopupDelay;
    private JLabel label_parameterPopupDelayText;
    private JLabel label_parameterSliderMin;
    private JLabel label_parameterSliderMax;
    private NumberFormat numberFormatter;

    public InsightOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private InsightOptions findOptions(TraversableContext tc) {
        InsightOptions options = InsightOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        InsightOptions options = this.findOptions(tc);
        InsightOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(InsightOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        String fontFamily = options.getFontFamily();
        properties.putProperty("insight-font-family", (Object)fontFamily);
        int fontSize = options.getFontSize();
        properties.putIntegerProperty("insight-font-size", fontSize);
        boolean completionEnablePopup = options.getCompletionEnablePopup();
        properties.putBooleanProperty("completion-enable-autopopup", completionEnablePopup);
        int completionPopupDelay = options.getCompletionPopupDelay();
        properties.putIntegerProperty("completion-popup-delay", completionPopupDelay);
        boolean parameterEnablePopup = options.getParameterEnablePopup();
        properties.putBooleanProperty("parameter-enable-autopopup", parameterEnablePopup);
        int parameterPopupDelay = options.getParameterPopupDelay();
        properties.putIntegerProperty("parameter-popup-delay", parameterPopupDelay);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JLabel label;
        JSlider slider;
        Object source = event.getSource();
        if (source == this.slider_completionPopupDelay) {
            slider = this.slider_completionPopupDelay;
            label = this.label_completionPopupDelayText;
        } else if (source == this.slider_parameterPopupDelay) {
            slider = this.slider_parameterPopupDelay;
            label = this.label_parameterPopupDelayText;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float value = (float)slider.getValue() / 10.0f;
        String valueStr = OptionsArb.format(142, this.numberFormatter.format(value));
        label.setText(valueStr);
        slider.setToolTipText(valueStr);
    }

    void loadSettingsFrom(InsightOptions options) {
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        boolean completionEnablePopup = options.getCompletionEnablePopup();
        int completionPopupDelay = options.getCompletionPopupDelay();
        boolean parameterEnablePopup = options.getParameterEnablePopup();
        int parameterPopupDelay = options.getParameterPopupDelay();
        this.setSelectedFontFamily(fontFamily);
        this.combobox_fontSize.setSelectedItem(new Integer(fontSize));
        this.checkbox_completionEnablePopup.setSelected(completionEnablePopup);
        this.slider_completionPopupDelay.setValue(completionPopupDelay / 100);
        this.checkbox_parameterEnablePopup.setSelected(parameterEnablePopup);
        this.slider_parameterPopupDelay.setValue(parameterPopupDelay / 100);
    }

    void saveSettingsTo(InsightOptions options) {
        String fontFamily = this.combobox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.combobox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        boolean completionEnablePopup = this.checkbox_completionEnablePopup.isSelected();
        int completionPopupDelay = this.slider_completionPopupDelay.getValue() * 100;
        boolean parameterEnablePopup = this.checkbox_parameterEnablePopup.isSelected();
        int parameterPopupDelay = this.slider_parameterPopupDelay.getValue() * 100;
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
        options.setCompletionEnablePopup(completionEnablePopup);
        options.setCompletionPopupDelay(completionPopupDelay);
        options.setParameterEnablePopup(parameterEnablePopup);
        options.setParameterPopupDelay(parameterPopupDelay);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.combobox_fontFamily.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Object element = model.getElementAt(i);
            if (!element.equals(fontFamily)) continue;
            this.combobox_fontFamily.setSelectedItem(fontFamily);
        }
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String fontFamilyText = OptionsArb.getString(46);
        JLabel label_fontFamily = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] families = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.combobox_fontFamily = new JComboBox(fontModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem(DEFAULT_FONT);
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.combobox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(47);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16)};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.combobox_fontSize = new JComboBox(sizeModel);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(sizes[0]);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.combobox_fontSize, (String)fontSizeText);
        String completionEnablePopupText = OptionsArb.getString(48);
        this.checkbox_completionEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_completionEnablePopup, (String)completionEnablePopupText);
        String completionPopupDelayText = OptionsArb.getString(49);
        JLabel label_completionPopupDelay = new JLabel();
        this.slider_completionPopupDelay = new JSlider(1, 30, 10);
        this.slider_completionPopupDelay.addChangeListener(this);
        this.label_completionPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_completionPopupDelay, (Component)this.slider_completionPopupDelay, (String)completionPopupDelayText);
        String completionPopupMinText = OptionsArb.getString(143);
        this.label_completionSliderMin = new JLabel(completionPopupMinText);
        String completionPopupMaxText = OptionsArb.getString(144);
        this.label_completionSliderMax = new JLabel(completionPopupMaxText);
        this.slider_completionPopupDelay.setPaintLabels(false);
        this.slider_completionPopupDelay.setPaintTicks(true);
        this.slider_completionPopupDelay.setMajorTickSpacing(10);
        this.slider_completionPopupDelay.setMinorTickSpacing(1);
        this.slider_completionPopupDelay.setSnapToTicks(true);
        Component[] completionDependents = new Component[]{this.slider_completionPopupDelay, label_completionPopupDelay, this.label_completionPopupDelayText, this.label_completionSliderMin, this.label_completionSliderMax};
        ItemSelectableTracker completionTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_completionEnablePopup, completionDependents);
        this.checkbox_completionEnablePopup.addItemListener((ItemListener)completionTracker);
        String parameterEnablePopupText = OptionsArb.getString(50);
        this.checkbox_parameterEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_parameterEnablePopup, (String)parameterEnablePopupText);
        String parameterPopupDelayText = OptionsArb.getString(51);
        JLabel label_parameterPopupDelay = new JLabel();
        this.slider_parameterPopupDelay = new JSlider(1, 30, 10);
        this.slider_parameterPopupDelay.addChangeListener(this);
        this.label_parameterPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_parameterPopupDelay, (Component)this.slider_parameterPopupDelay, (String)parameterPopupDelayText);
        String paramPopupMinText = OptionsArb.getString(143);
        this.label_parameterSliderMin = new JLabel(paramPopupMinText);
        String paramPopupMaxText = OptionsArb.getString(144);
        this.label_parameterSliderMax = new JLabel(paramPopupMaxText);
        this.slider_parameterPopupDelay.setPaintLabels(false);
        this.slider_parameterPopupDelay.setPaintTicks(true);
        this.slider_parameterPopupDelay.setMajorTickSpacing(10);
        this.slider_parameterPopupDelay.setMinorTickSpacing(1);
        this.slider_parameterPopupDelay.setSnapToTicks(true);
        Component[] parameterDependents = new Component[]{this.slider_parameterPopupDelay, label_parameterPopupDelay, this.label_parameterPopupDelayText, this.label_parameterSliderMin, this.label_parameterSliderMax};
        ItemSelectableTracker parameterTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_parameterEnablePopup, parameterDependents);
        this.checkbox_parameterEnablePopup.addItemListener((ItemListener)parameterTracker);
        this.slider_completionPopupDelay.setValue(1);
        this.slider_parameterPopupDelay.setValue(1);
        this.setLayout((LayoutManager)new MigLayout("ins 0"));
        this.add(label_fontFamily, "");
        this.add(this.combobox_fontFamily, "wrap");
        this.add(label_fontSize, "");
        this.add(this.combobox_fontSize, "wrap");
        this.add(this.checkbox_completionEnablePopup, "span, wrap, gaptop 10px");
        this.add(label_completionPopupDelay, "span, wrap");
        this.add(this.label_completionSliderMin, "span, split, aligny center");
        this.add(this.slider_completionPopupDelay, "");
        this.add(this.label_completionSliderMax, "aligny center, wrap");
        this.add(this.label_completionPopupDelayText, "span, alignx center, wrap");
        this.add(this.checkbox_parameterEnablePopup, "span, wrap, gaptop 10px");
        this.add(label_parameterPopupDelay, "wrap");
        this.add(this.label_parameterSliderMin, "span, aligny center, split");
        this.add(this.slider_parameterPopupDelay, "");
        this.add(this.label_parameterSliderMax, "aligny center, wrap");
        this.add(this.label_parameterPopupDelayText, "span, alignx center, wrap");
    }
}

