/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.FontSettings;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.config.DTCache;
import oracle.javatools.util.Copyable;

public final class FontManager {
    private static FontManager singleton;
    private String[] proportionalList;
    private String[] fixedList;
    private String[] symbolList;
    private String[] allList;
    private List unknownList;

    public static FontManager getInstance() {
        if (singleton == null) {
            singleton = new FontManager();
        }
        return singleton;
    }

    private FontManager() {
        this.loadSettings();
        this.unknownList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFontInfoComplete() {
        boolean complete = false;
        FontManager fontManager = this;
        synchronized (fontManager) {
            if (this.unknownList == null) {
                complete = true;
            } else if (this.unknownList.size() <= 0) {
                ArrayList<String> knownList = new ArrayList<String>();
                knownList.addAll(Arrays.asList(this.proportionalList));
                knownList.addAll(Arrays.asList(this.fixedList));
                knownList.addAll(Arrays.asList(this.symbolList));
                for (String fontToCheck : this.getAllFontFamilies()) {
                    if (knownList.indexOf(fontToCheck) != -1) continue;
                    this.unknownList.add(fontToCheck);
                }
                if (this.unknownList.size() == 0) {
                    this.unknownList = null;
                    complete = true;
                }
            }
        }
        return complete;
    }

    public void updateFontInfo(Frame parent) {
        if (this.isFontInfoComplete()) {
            return;
        }
        FontDialog dialog = new FontDialog();
        dialog.showDialog(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownProportionalFamilies() {
        String[] list;
        FontManager fontManager = this;
        synchronized (fontManager) {
            list = this.proportionalList;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownFixedFamilies() {
        String[] list;
        FontManager fontManager = this;
        synchronized (fontManager) {
            list = this.fixedList;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownSymbolFamilies() {
        String[] list;
        FontManager fontManager = this;
        synchronized (fontManager) {
            list = this.symbolList;
        }
        return list;
    }

    public String[] getAllFontFamilies() {
        if (this.allList == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.allList = graphicsEnvironment.getAvailableFontFamilyNames();
            Arrays.sort(this.allList);
        }
        return this.allList;
    }

    private void loadSettings() {
        DTCache dtCache = Ide.getDTCache();
        FontSettings fontSettings = (FontSettings)dtCache.getData("FontSettings");
        if (fontSettings == null) {
            fontSettings = new FontSettings();
            dtCache.putData("FontSettings", (Copyable)fontSettings);
        }
        this.proportionalList = fontSettings.getProportionalFamilies();
        this.fixedList = fontSettings.getFixedFamilies();
        this.symbolList = fontSettings.getSymbolFamilies();
        Arrays.sort(this.proportionalList);
        Arrays.sort(this.fixedList);
        Arrays.sort(this.symbolList);
    }

    private void saveSettings() {
        FontSettings fontSettings = new FontSettings();
        fontSettings.setProportionalFamilies(this.proportionalList);
        fontSettings.setFixedFamilies(this.fixedList);
        fontSettings.setSymbolFamilies(this.symbolList);
        DTCache dtCache = Ide.getDTCache();
        dtCache.putData("FontSettings", (Copyable)fontSettings);
    }

    static /* synthetic */ String[] access$302(FontManager x0, String[] x1) {
        x0.proportionalList = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(FontManager x0, String[] x1) {
        x0.fixedList = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(FontManager x0, String[] x1) {
        x0.symbolList = x1;
        return x1;
    }

    private final class FontDialog
    implements ActionListener,
    Runnable {
        private JLabel statusLabel;
        private JProgressBar progressBar;
        private JEWTDialog statusDialog;
        private int completionStatus;
        private String currentFont;
        private Timer labelTimer;
        private Timer completionTimer;
        private boolean bail;

        private FontDialog() {
        }

        private void showDialog(Frame parent) {
            String initialText = OptionsArb.getString(70);
            this.statusLabel = new JLabel(initialText);
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.statusLabel.setLabelFor(this.progressBar);
            JPanel statusPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            statusPanel.add((Component)this.statusLabel, constraints);
            constraints.gridy = 1;
            statusPanel.add((Component)this.progressBar, constraints);
            constraints.gridy = 2;
            statusPanel.add(Box.createHorizontalStrut(300), constraints);
            this.labelTimer = new Timer(1, this);
            this.labelTimer.setRepeats(false);
            this.completionTimer = new Timer(1, this);
            this.labelTimer.setRepeats(false);
            this.bail = false;
            String titleText = OptionsArb.getString(69);
            this.statusDialog = new JEWTDialog(parent, titleText, 2);
            this.statusDialog.setContent((Component)statusPanel);
            this.statusDialog.setDefaultButton(2);
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
            this.statusDialog.runDialog();
            this.bail = true;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.labelTimer) {
                String fontText = OptionsArb.getString(71);
                fontText = fontText + "  " + this.currentFont;
                this.statusLabel.setText(fontText);
                this.progressBar.setValue(this.completionStatus);
            } else if (source == this.completionTimer) {
                if (this.statusDialog.isVisible()) {
                    this.statusDialog.hide();
                    this.statusDialog.dispose();
                }
                this.labelTimer.stop();
                this.labelTimer.removeActionListener(this);
                this.completionTimer.stop();
                this.completionTimer.removeActionListener(this);
                this.labelTimer = null;
                this.completionTimer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FontManager fontManager = FontManager.this;
            synchronized (fontManager) {
                int numUnknown = FontManager.this.unknownList.size();
                String[] unknowns = FontManager.this.unknownList.toArray(new String[numUnknown]);
                ArrayList<String> newPropList = new ArrayList<String>();
                ArrayList<String> newFixedList = new ArrayList<String>();
                ArrayList<String> newSymbolList = new ArrayList<String>();
                long lastPause = System.currentTimeMillis();
                for (int i = 0; i < numUnknown && !this.bail; ++i) {
                    String fontToCheck;
                    long current = System.currentTimeMillis();
                    long elapsed = current - lastPause;
                    if (elapsed > 1000L) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        lastPause = current;
                    }
                    if (this.bail) break;
                    this.currentFont = fontToCheck = unknowns[i];
                    this.completionStatus = i * 100 / numUnknown;
                    this.labelTimer.start();
                    if (this.bail) break;
                    Font font = new Font(fontToCheck, 0, 12);
                    if (this.bail) break;
                    if (!font.canDisplay('a')) {
                        newSymbolList.add(fontToCheck);
                        continue;
                    }
                    if (this.bail) break;
                    FontMetrics metrics = this.statusDialog.getFontMetrics(font);
                    if (metrics.charWidth('l') == metrics.charWidth('w')) {
                        newFixedList.add(fontToCheck);
                        continue;
                    }
                    newPropList.add(fontToCheck);
                }
                FontManager.this.unknownList.clear();
                newPropList.addAll(Arrays.asList(FontManager.this.proportionalList));
                int numProp = newPropList.size();
                FontManager.access$302(FontManager.this, newPropList.toArray(new String[numProp]));
                Arrays.sort(FontManager.this.proportionalList);
                newFixedList.addAll(Arrays.asList(FontManager.this.fixedList));
                int numFixed = newFixedList.size();
                FontManager.access$402(FontManager.this, newFixedList.toArray(new String[numFixed]));
                Arrays.sort(FontManager.this.fixedList);
                newSymbolList.addAll(Arrays.asList(FontManager.this.symbolList));
                int numSymbol = newSymbolList.size();
                FontManager.access$502(FontManager.this, newSymbolList.toArray(new String[numSymbol]));
                Arrays.sort(FontManager.this.symbolList);
                FontManager.this.saveSettings();
            }
            this.completionTimer.start();
        }
    }
}

