/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class DisplayOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "DisplayOptions";
    private static final String SHOW_WHITESPACE_CHARS = "showWhitespaceChars";
    private static final String SHOW_LINE_NUMBERS = "showLineNumbers";
    private static final String SHARED_ICON_COLUMN = "sharedIconColumn";
    private static final String ENABLE_CLICK_DRAGGING = "enableClickDragging";
    private static final String GUTTER_COLOR_SOURCE = "gutterColorSource";
    private static final String GUTTER_BACKGROUND_COLOR = "gutterBackgroundColor";
    private static final String GUTTER_FOREGROUND_COLOR = "gutterForegroundColor";
    private static final String SHOW_CODE_FOLDING_MARGIN = "showCodeFoldingMargin";
    private static final String SHOW_CODE_FOLDING_HIGHLIGHT = "showCodeFoldingHighlight";
    private static final String CODE_FOLDING_ENABLED = "codeFoldingEnabled";
    private static final String SHOW_RIGHT_MARGIN = "showRightMargin";
    private static final String RIGHT_MARGIN_COLUMN = "rightMarginColumn";
    private static final String RIGHT_MARGIN_COLOR = "rightMarginColor";
    private static final String AUTO_BRACE_MATCH = "autoBraceMatch";
    private static final String BRACE_ENCLOSING_BLOCK = "braceEnclosingBlock";
    private static final String BRACE_ENCLOSING_PARENS = "braceEnclosingParens";
    private static final int MINIMUM_DELAY = 100;
    private static final int MAXIMUM_DELAY = 2000;
    private static final String BRACE_MATCH_DELAY = "braceMatchDelay";
    private static final String USE_AA_TEXT = "useAAText";
    private static final String SHOW_BREADCRUMBS = "showBreadcrumbs";
    private static final String SHOW_SCROLLTIP = "showScrollTip";

    public DisplayOptions() {
        this(HashStructure.newInstance());
    }

    private DisplayOptions(HashStructure hash) {
        super(hash);
    }

    public static DisplayOptions getInstance(PropertyStorage prefs) {
        return new DisplayOptions(DisplayOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean getShowWhitespaceChars() {
        return this._hash.getBoolean(SHOW_WHITESPACE_CHARS, false);
    }

    public void setShowWhitespaceChars(boolean showWhitespaceChars) {
        this._hash.putBoolean(SHOW_WHITESPACE_CHARS, showWhitespaceChars);
    }

    public boolean getShowLineNumbers() {
        return this._hash.getBoolean(SHOW_LINE_NUMBERS, false);
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this._hash.putBoolean(SHOW_LINE_NUMBERS, showLineNumbers);
    }

    public boolean getSharedIconColumn() {
        return this._hash.getBoolean(SHARED_ICON_COLUMN, true);
    }

    public void setSharedIconColumn(boolean sharedIconColumn) {
        this._hash.putBoolean(SHARED_ICON_COLUMN, sharedIconColumn);
    }

    public boolean getEnableClickDragging() {
        return this._hash.getBoolean(ENABLE_CLICK_DRAGGING, true);
    }

    public void setEnableClickDragging(boolean enableClickDragging) {
        this._hash.putBoolean(ENABLE_CLICK_DRAGGING, enableClickDragging);
    }

    public int getGutterColorSource() {
        return this._hash.getInt(GUTTER_COLOR_SOURCE, 2);
    }

    public void setGutterColorSource(int gutterColorSource) {
        this._hash.putInt(GUTTER_COLOR_SOURCE, gutterColorSource);
    }

    public int getGutterBackgroundColor() {
        return this._hash.getInt(GUTTER_BACKGROUND_COLOR, Color.lightGray.getRGB());
    }

    public void setGutterBackgroundColor(int gutterBackgroundColor) {
        this._hash.putInt(GUTTER_BACKGROUND_COLOR, gutterBackgroundColor);
    }

    public int getGutterForegroundColor() {
        return this._hash.getInt(GUTTER_FOREGROUND_COLOR, Color.darkGray.getRGB());
    }

    public void setGutterForegroundColor(int gutterForegroundColor) {
        this._hash.putInt(GUTTER_FOREGROUND_COLOR, gutterForegroundColor);
    }

    public boolean getShowCodeFoldingMargin() {
        return this._hash.getBoolean(SHOW_CODE_FOLDING_MARGIN, true);
    }

    public void setShowCodeFoldingMargin(boolean showCodeFoldingMargin) {
        this._hash.putBoolean(SHOW_CODE_FOLDING_MARGIN, showCodeFoldingMargin);
    }

    public boolean getShowCodeFoldingHighlight() {
        return this._hash.getBoolean(SHOW_CODE_FOLDING_HIGHLIGHT, true);
    }

    public void setShowCodeFoldingHighlight(boolean showCodeFoldingHighlight) {
        this._hash.putBoolean(SHOW_CODE_FOLDING_HIGHLIGHT, showCodeFoldingHighlight);
    }

    public boolean getCodeFoldingEnabled() {
        return this._hash.getBoolean(CODE_FOLDING_ENABLED, true);
    }

    public void setCodeFoldingEnabled(boolean codeFoldingEnabled) {
        this._hash.putBoolean(CODE_FOLDING_ENABLED, codeFoldingEnabled);
    }

    public boolean getShowRightMargin() {
        return this._hash.getBoolean(SHOW_RIGHT_MARGIN, true);
    }

    public void setShowRightMargin(boolean showRightMargin) {
        this._hash.putBoolean(SHOW_RIGHT_MARGIN, showRightMargin);
    }

    public int getRightMarginColumn() {
        return this._hash.getInt(RIGHT_MARGIN_COLUMN, 80);
    }

    public void setRightMarginColumn(int rightMarginColumn) {
        this._hash.putInt(RIGHT_MARGIN_COLUMN, rightMarginColumn);
    }

    public int getRightMarginColor() {
        return this._hash.getInt(RIGHT_MARGIN_COLOR, Color.lightGray.getRGB());
    }

    public void setRightMarginColor(int rightMarginColor) {
        this._hash.putInt(RIGHT_MARGIN_COLOR, rightMarginColor);
    }

    public boolean getAutoBraceMatch() {
        return this._hash.getBoolean(AUTO_BRACE_MATCH, true);
    }

    public void setAutoBraceMatch(boolean autoBraceMatch) {
        this._hash.putBoolean(AUTO_BRACE_MATCH, autoBraceMatch);
    }

    public boolean getBraceEnclosingBlock() {
        return this._hash.getBoolean(BRACE_ENCLOSING_BLOCK, true);
    }

    public void setBraceEnclosingBlock(boolean braceEnclosingBlock) {
        this._hash.putBoolean(BRACE_ENCLOSING_BLOCK, braceEnclosingBlock);
    }

    public boolean getBraceEnclosingParens() {
        return this._hash.getBoolean(BRACE_ENCLOSING_PARENS, true);
    }

    public void setBraceEnclosingParens(boolean braceEnclosingParens) {
        this._hash.putBoolean(BRACE_ENCLOSING_PARENS, braceEnclosingParens);
    }

    public int getBraceMatchDelay() {
        return this._hash.getInt(BRACE_MATCH_DELAY, 300);
    }

    public void setBraceMatchDelay(int braceMatchDelay) {
        this._hash.putInt(BRACE_MATCH_DELAY, Math.min(Math.max(braceMatchDelay, 100), 2000));
    }

    public boolean getUseAAText() {
        return this._hash.getBoolean(USE_AA_TEXT, false);
    }

    public void setUseAAText(boolean useAAText) {
        this._hash.putBoolean(USE_AA_TEXT, useAAText);
    }

    public boolean getShowBreadcrumbs() {
        return this._hash.getBoolean(SHOW_BREADCRUMBS, true);
    }

    public void setShowBreadcrumbs(boolean showBreadcrumbs) {
        this._hash.putBoolean(SHOW_BREADCRUMBS, showBreadcrumbs);
    }

    public boolean getShowScrollTip() {
        return this._hash.getBoolean(SHOW_SCROLLTIP, true);
    }

    public void setShowScrollTip(boolean showScrollTip) {
        this._hash.putBoolean(SHOW_SCROLLTIP, showScrollTip);
    }
}

