/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class CompletionOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_invokeMatching;
    private JCheckBox checkbox_partialMatching;
    private JCheckBox checkbox_typedMatching;
    private JCheckBox checkbox_filterCompletion;

    public CompletionOptionsPanel() {
        this.setHelpID("f1_idedidesetcompletion_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private InsightOptions findOptions(TraversableContext tc) {
        InsightOptions options = InsightOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        InsightOptions options = this.findOptions(tc);
        CompletionOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(InsightOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean invokeMatching = options.getInvokeCompleteMatch();
        boolean partialMatching = options.getPartialCompleteMatch();
        boolean typedMatching = options.getTypedCompleteMatch();
        boolean filterCompletion = options.getFilterCompletion();
        properties.putBooleanProperty("insight-manual-complete-single", invokeMatching);
        properties.putBooleanProperty("insight-partial-complete-single", partialMatching);
        properties.putBooleanProperty("insight-typed-complete-single", typedMatching);
        properties.putBooleanProperty("insight-filter-matching", filterCompletion);
        boolean newDataMatching = options.getNewDataCompleteMatch();
        properties.putBooleanProperty("insight-newdata-complete-single", newDataMatching && invokeMatching);
    }

    void loadSettingsFrom(InsightOptions options) {
        boolean invokeMatching = options.getInvokeCompleteMatch();
        boolean partialMatching = options.getPartialCompleteMatch();
        boolean typedMatching = options.getTypedCompleteMatch();
        boolean filterCompletion = options.getFilterCompletion();
        this.checkbox_invokeMatching.setSelected(invokeMatching);
        this.checkbox_partialMatching.setSelected(partialMatching);
        this.checkbox_typedMatching.setSelected(typedMatching);
        this.checkbox_filterCompletion.setSelected(filterCompletion);
    }

    void saveSettingsTo(InsightOptions options) {
        boolean invokeMatching = this.checkbox_invokeMatching.isSelected();
        boolean partialMatching = this.checkbox_partialMatching.isSelected();
        boolean typedMatching = this.checkbox_typedMatching.isSelected();
        boolean filterCompletion = this.checkbox_filterCompletion.isSelected();
        options.setInvokeCompleteMatch(invokeMatching);
        options.setPartialCompleteMatch(partialMatching);
        options.setTypedCompleteMatch(typedMatching);
        options.setFilterCompletion(filterCompletion);
    }

    private void initializeComponent() {
        String singleMatchingText = OptionsArb.getString(54);
        String invokeMatchingText = OptionsArb.getString(55);
        String partialMatchingText = OptionsArb.getString(56);
        String typedMatchingText = OptionsArb.getString(57);
        JLabel label_completeSingleMatching = new JLabel(singleMatchingText);
        this.checkbox_invokeMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_invokeMatching, (String)invokeMatchingText);
        this.checkbox_partialMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_partialMatching, (String)partialMatchingText);
        this.checkbox_typedMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_typedMatching, (String)typedMatchingText);
        String filterCompletionText = OptionsArb.getString(58);
        String filterExplainText = OptionsArb.getString(59);
        JLabel label_filterExplain = new JLabel(filterExplainText);
        this.checkbox_filterCompletion = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_filterCompletion, (String)filterCompletionText);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(0, 30, 2, 2);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_completeSingleMatching, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_invokeMatching, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_partialMatching, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_typedMatching, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_filterCompletion, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_filterExplain, constraints);
        constraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 0, defaultInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

