/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.BasicEditorPane;

public final class EditorFactory {
    public static BasicEditorPane createIdeEditorPane() {
        return EditorFactory.createIdeEditorPane(null);
    }

    public static BasicEditorPane createIdeEditorPane(KeyStrokeContext[] keystrokeContexts) {
        try {
            IdeEditorPane editor = new IdeEditorPane();
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper ideHelper = keymapManager.createIdeKeymapHelper(keystrokeContexts);
            editor.installPlugin(ideHelper);
            return editor;
        }
        catch (RuntimeException e) {
            System.out.println("Unexpected exception: " + e.toString());
            e.printStackTrace();
            BasicEditorPane pane = new BasicEditorPane();
            return pane;
        }
    }

    public static BasicEditorPane createStandaloneEditorPane() {
        return EditorFactory.createStandaloneEditorPane(null);
    }

    private static BasicEditorPane createStandaloneEditorPane(KeyStrokeContext[] keystrokeContexts) {
        try {
            IdeEditorPane editor = new IdeEditorPane();
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper standaloneHelper = keymapManager.createStandaloneKeymapHelper(keystrokeContexts);
            editor.installPlugin(standaloneHelper);
            return editor;
        }
        catch (RuntimeException e) {
            System.out.println("Unexpected exception: " + e.toString());
            e.printStackTrace();
            return new BasicEditorPane();
        }
    }

    public static void initialize() {
        KeymapManager.getInstance();
    }
}

